/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancing.model.transform;

import com.amazonaws.services.elasticloadbalancing.model.LoadBalancerDescription;
import com.amazonaws.services.elasticloadbalancing.model.transform.HealthCheckUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.InstanceUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.ListenerUnmarshaller;
import com.amazonaws.transform.SimpleTypeUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.XpathUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadBalancerDescriptionUnmarshaller
implements Unmarshaller<LoadBalancerDescription, Node> {
    @Override
    public LoadBalancerDescription unmarshall(Node node) throws Exception {
        if (node == null) {
            return null;
        }
        LoadBalancerDescription loadBalancerDescription = new LoadBalancerDescription();
        Node loadBalancerNameNode = XpathUtils.asNode("LoadBalancerName", node);
        loadBalancerDescription.setLoadBalancerName(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(loadBalancerNameNode));
        Node dNSNameNode = XpathUtils.asNode("DNSName", node);
        loadBalancerDescription.setDNSName(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(dNSNameNode));
        NodeList listenersNodes = XpathUtils.asNodeList("Listeners/member", node);
        for (int listenersIndex = 0; listenersIndex < XpathUtils.nodeLength(listenersNodes); ++listenersIndex) {
            Node listenersNode = listenersNodes.item(listenersIndex);
            loadBalancerDescription.getListeners().add(new ListenerUnmarshaller().unmarshall(listenersNode));
            listenersNode.getParentNode().removeChild(listenersNode);
        }
        NodeList availabilityZonesNodes = XpathUtils.asNodeList("AvailabilityZones/member", node);
        for (int availabilityZonesIndex = 0; availabilityZonesIndex < XpathUtils.nodeLength(availabilityZonesNodes); ++availabilityZonesIndex) {
            Node availabilityZonesNode = availabilityZonesNodes.item(availabilityZonesIndex);
            loadBalancerDescription.getAvailabilityZones().add(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(availabilityZonesNode));
            availabilityZonesNode.getParentNode().removeChild(availabilityZonesNode);
        }
        NodeList instancesNodes = XpathUtils.asNodeList("Instances/member", node);
        for (int instancesIndex = 0; instancesIndex < XpathUtils.nodeLength(instancesNodes); ++instancesIndex) {
            Node instancesNode = instancesNodes.item(instancesIndex);
            loadBalancerDescription.getInstances().add(new InstanceUnmarshaller().unmarshall(instancesNode));
            instancesNode.getParentNode().removeChild(instancesNode);
        }
        Node healthCheckNode = XpathUtils.asNode("HealthCheck", node);
        loadBalancerDescription.setHealthCheck(new HealthCheckUnmarshaller().unmarshall(healthCheckNode));
        Node createdTimeNode = XpathUtils.asNode("CreatedTime", node);
        loadBalancerDescription.setCreatedTime(new SimpleTypeUnmarshallers.DateUnmarshaller().unmarshall(createdTimeNode));
        return loadBalancerDescription;
    }
}

