/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.elasticmapreduce.model.HadoopJarStepConfig;
import com.amazonaws.services.elasticmapreduce.model.JobFlowInstancesConfig;
import com.amazonaws.services.elasticmapreduce.model.KeyValue;
import com.amazonaws.services.elasticmapreduce.model.PlacementType;
import com.amazonaws.services.elasticmapreduce.model.RunJobFlowRequest;
import com.amazonaws.services.elasticmapreduce.model.StepConfig;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunJobFlowRequestMarshaller
implements Marshaller<Request<RunJobFlowRequest>, RunJobFlowRequest> {
    @Override
    public Request<RunJobFlowRequest> marshall(RunJobFlowRequest runJobFlowRequest) {
        DefaultRequest<RunJobFlowRequest> request = new DefaultRequest<RunJobFlowRequest>(runJobFlowRequest, "AmazonElasticMapReduce");
        request.addParameter("Action", "RunJobFlow");
        request.addParameter("Version", "2009-03-31");
        if (runJobFlowRequest != null && runJobFlowRequest.getName() != null) {
            request.addParameter("Name", StringUtils.fromString(runJobFlowRequest.getName()));
        }
        if (runJobFlowRequest != null && runJobFlowRequest.getLogUri() != null) {
            request.addParameter("LogUri", StringUtils.fromString(runJobFlowRequest.getLogUri()));
        }
        if (runJobFlowRequest != null) {
            PlacementType placement;
            JobFlowInstancesConfig instances = runJobFlowRequest.getInstances();
            if (instances != null && instances.getMasterInstanceType() != null) {
                request.addParameter("Instances.MasterInstanceType", StringUtils.fromString(instances.getMasterInstanceType()));
            }
            if (instances != null && instances.getSlaveInstanceType() != null) {
                request.addParameter("Instances.SlaveInstanceType", StringUtils.fromString(instances.getSlaveInstanceType()));
            }
            if (instances != null && instances.getInstanceCount() != null) {
                request.addParameter("Instances.InstanceCount", StringUtils.fromInteger(instances.getInstanceCount()));
            }
            if (instances != null && instances.getEc2KeyName() != null) {
                request.addParameter("Instances.Ec2KeyName", StringUtils.fromString(instances.getEc2KeyName()));
            }
            if (instances != null && (placement = instances.getPlacement()) != null && placement.getAvailabilityZone() != null) {
                request.addParameter("Instances.Placement.AvailabilityZone", StringUtils.fromString(placement.getAvailabilityZone()));
            }
            if (instances != null && instances.isKeepJobFlowAliveWhenNoSteps() != null) {
                request.addParameter("Instances.KeepJobFlowAliveWhenNoSteps", StringUtils.fromBoolean(instances.isKeepJobFlowAliveWhenNoSteps()));
            }
        }
        if (runJobFlowRequest != null) {
            List<StepConfig> stepsList = runJobFlowRequest.getSteps();
            int stepsListIndex = 1;
            for (StepConfig stepsListValue : stepsList) {
                if (stepsListValue != null && stepsListValue.getName() != null) {
                    request.addParameter("Steps.member." + stepsListIndex + ".Name", StringUtils.fromString(stepsListValue.getName()));
                }
                if (stepsListValue != null && stepsListValue.getActionOnFailure() != null) {
                    request.addParameter("Steps.member." + stepsListIndex + ".ActionOnFailure", StringUtils.fromString(stepsListValue.getActionOnFailure()));
                }
                if (stepsListValue != null) {
                    HadoopJarStepConfig hadoopJarStep = stepsListValue.getHadoopJarStep();
                    if (hadoopJarStep != null) {
                        List<KeyValue> propertiesList = hadoopJarStep.getProperties();
                        int propertiesListIndex = 1;
                        for (KeyValue propertiesListValue : propertiesList) {
                            if (propertiesListValue != null && propertiesListValue.getKey() != null) {
                                request.addParameter("Steps.member." + stepsListIndex + ".HadoopJarStep.Properties.member." + propertiesListIndex + ".Key", StringUtils.fromString(propertiesListValue.getKey()));
                            }
                            if (propertiesListValue != null && propertiesListValue.getValue() != null) {
                                request.addParameter("Steps.member." + stepsListIndex + ".HadoopJarStep.Properties.member." + propertiesListIndex + ".Value", StringUtils.fromString(propertiesListValue.getValue()));
                            }
                            ++propertiesListIndex;
                        }
                    }
                    if (hadoopJarStep != null && hadoopJarStep.getJar() != null) {
                        request.addParameter("Steps.member." + stepsListIndex + ".HadoopJarStep.Jar", StringUtils.fromString(hadoopJarStep.getJar()));
                    }
                    if (hadoopJarStep != null && hadoopJarStep.getMainClass() != null) {
                        request.addParameter("Steps.member." + stepsListIndex + ".HadoopJarStep.MainClass", StringUtils.fromString(hadoopJarStep.getMainClass()));
                    }
                    if (hadoopJarStep != null) {
                        List<String> argsList = hadoopJarStep.getArgs();
                        int argsListIndex = 1;
                        for (String argsListValue : argsList) {
                            if (argsListValue != null) {
                                request.addParameter("Steps.member." + stepsListIndex + ".HadoopJarStep.Args.member." + argsListIndex, StringUtils.fromString(argsListValue));
                            }
                            ++argsListIndex;
                        }
                    }
                }
                ++stepsListIndex;
            }
        }
        return request;
    }
}

