/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model.transform;

import com.amazonaws.services.cloudwatch.model.Datapoint;
import com.amazonaws.transform.SimpleTypeUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.XpathUtils;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatapointUnmarshaller
implements Unmarshaller<Datapoint, Node> {
    @Override
    public Datapoint unmarshall(Node node) throws Exception {
        Datapoint datapoint = new Datapoint();
        Node timestampNode = XpathUtils.asNode("Timestamp", node);
        datapoint.setTimestamp(new SimpleTypeUnmarshallers.DateUnmarshaller().unmarshall(timestampNode));
        Node unitNode = XpathUtils.asNode("Unit", node);
        datapoint.setUnit(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(unitNode));
        Node customUnitNode = XpathUtils.asNode("CustomUnit", node);
        datapoint.setCustomUnit(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(customUnitNode));
        Node samplesNode = XpathUtils.asNode("Samples", node);
        datapoint.setSamples(new SimpleTypeUnmarshallers.DoubleUnmarshaller().unmarshall(samplesNode));
        Node averageNode = XpathUtils.asNode("Average", node);
        datapoint.setAverage(new SimpleTypeUnmarshallers.DoubleUnmarshaller().unmarshall(averageNode));
        Node sumNode = XpathUtils.asNode("Sum", node);
        datapoint.setSum(new SimpleTypeUnmarshallers.DoubleUnmarshaller().unmarshall(sumNode));
        Node minimumNode = XpathUtils.asNode("Minimum", node);
        datapoint.setMinimum(new SimpleTypeUnmarshallers.DoubleUnmarshaller().unmarshall(minimumNode));
        Node maximumNode = XpathUtils.asNode("Maximum", node);
        datapoint.setMaximum(new SimpleTypeUnmarshallers.DoubleUnmarshaller().unmarshall(maximumNode));
        return datapoint;
    }
}

