/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.services.autoscaling.model.Trigger;
import com.amazonaws.services.autoscaling.model.transform.DimensionUnmarshaller;
import com.amazonaws.transform.SimpleTypeUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.XpathUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TriggerUnmarshaller
implements Unmarshaller<Trigger, Node> {
    @Override
    public Trigger unmarshall(Node node) throws Exception {
        Trigger trigger = new Trigger();
        Node triggerNameNode = XpathUtils.asNode("TriggerName", node);
        trigger.setTriggerName(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(triggerNameNode));
        Node autoScalingGroupNameNode = XpathUtils.asNode("AutoScalingGroupName", node);
        trigger.setAutoScalingGroupName(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(autoScalingGroupNameNode));
        Node measureNameNode = XpathUtils.asNode("MeasureName", node);
        trigger.setMeasureName(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(measureNameNode));
        Node statisticNode = XpathUtils.asNode("Statistic", node);
        trigger.setStatistic(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(statisticNode));
        NodeList dimensionsNodes = XpathUtils.asNodeList("Dimensions/member", node);
        for (int dimensionsIndex = 0; dimensionsIndex < XpathUtils.nodeLength(dimensionsNodes); ++dimensionsIndex) {
            Node dimensionsNode = dimensionsNodes.item(dimensionsIndex);
            trigger.getDimensions().add(new DimensionUnmarshaller().unmarshall(dimensionsNode));
            dimensionsNode.getParentNode().removeChild(dimensionsNode);
        }
        Node periodNode = XpathUtils.asNode("Period", node);
        trigger.setPeriod(new SimpleTypeUnmarshallers.IntegerUnmarshaller().unmarshall(periodNode));
        Node unitNode = XpathUtils.asNode("Unit", node);
        trigger.setUnit(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(unitNode));
        Node customUnitNode = XpathUtils.asNode("CustomUnit", node);
        trigger.setCustomUnit(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(customUnitNode));
        Node namespaceNode = XpathUtils.asNode("Namespace", node);
        trigger.setNamespace(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(namespaceNode));
        Node lowerThresholdNode = XpathUtils.asNode("LowerThreshold", node);
        trigger.setLowerThreshold(new SimpleTypeUnmarshallers.DoubleUnmarshaller().unmarshall(lowerThresholdNode));
        Node lowerBreachScaleIncrementNode = XpathUtils.asNode("LowerBreachScaleIncrement", node);
        trigger.setLowerBreachScaleIncrement(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(lowerBreachScaleIncrementNode));
        Node upperThresholdNode = XpathUtils.asNode("UpperThreshold", node);
        trigger.setUpperThreshold(new SimpleTypeUnmarshallers.DoubleUnmarshaller().unmarshall(upperThresholdNode));
        Node upperBreachScaleIncrementNode = XpathUtils.asNode("UpperBreachScaleIncrement", node);
        trigger.setUpperBreachScaleIncrement(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(upperBreachScaleIncrementNode));
        Node breachDurationNode = XpathUtils.asNode("BreachDuration", node);
        trigger.setBreachDuration(new SimpleTypeUnmarshallers.IntegerUnmarshaller().unmarshall(breachDurationNode));
        Node statusNode = XpathUtils.asNode("Status", node);
        trigger.setStatus(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(statusNode));
        Node createdTimeNode = XpathUtils.asNode("CreatedTime", node);
        trigger.setCreatedTime(new SimpleTypeUnmarshallers.DateUnmarshaller().unmarshall(createdTimeNode));
        return trigger;
    }
}

