/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workspaces.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.workspaces.model.Workspace;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class DescribeWorkspacesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private SdkInternalList<Workspace> workspaces;
    private String nextToken;

    public List<Workspace> getWorkspaces() {
        if (this.workspaces == null) {
            this.workspaces = new SdkInternalList();
        }
        return this.workspaces;
    }

    public void setWorkspaces(Collection<Workspace> workspaces) {
        if (workspaces == null) {
            this.workspaces = null;
            return;
        }
        this.workspaces = new SdkInternalList(workspaces);
    }

    public DescribeWorkspacesResult withWorkspaces(Workspace ... workspaces) {
        if (this.workspaces == null) {
            this.setWorkspaces((Collection<Workspace>)new SdkInternalList(workspaces.length));
        }
        for (Workspace ele : workspaces) {
            this.workspaces.add((Object)ele);
        }
        return this;
    }

    public DescribeWorkspacesResult withWorkspaces(Collection<Workspace> workspaces) {
        this.setWorkspaces(workspaces);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public DescribeWorkspacesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getWorkspaces() != null) {
            sb.append("Workspaces: ").append(this.getWorkspaces()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWorkspacesResult)) {
            return false;
        }
        DescribeWorkspacesResult other = (DescribeWorkspacesResult)obj;
        if (other.getWorkspaces() == null ^ this.getWorkspaces() == null) {
            return false;
        }
        if (other.getWorkspaces() != null && !other.getWorkspaces().equals(this.getWorkspaces())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getWorkspaces() == null ? 0 : this.getWorkspaces().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public DescribeWorkspacesResult clone() {
        try {
            return (DescribeWorkspacesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

