/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workspaces.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.workspaces.model.WorkspaceDirectory;
import com.amazonaws.services.workspaces.model.transform.DefaultWorkspaceCreationPropertiesJsonMarshaller;
import com.amazonaws.util.json.SdkJsonGenerator;

public class WorkspaceDirectoryJsonMarshaller {
    private static WorkspaceDirectoryJsonMarshaller instance;

    public void marshall(WorkspaceDirectory workspaceDirectory, SdkJsonGenerator jsonGenerator) {
        if (workspaceDirectory == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList dnsIpAddressesList;
            SdkInternalList subnetIdsList;
            jsonGenerator.writeStartObject();
            if (workspaceDirectory.getDirectoryId() != null) {
                jsonGenerator.writeFieldName("DirectoryId").writeValue(workspaceDirectory.getDirectoryId());
            }
            if (workspaceDirectory.getAlias() != null) {
                jsonGenerator.writeFieldName("Alias").writeValue(workspaceDirectory.getAlias());
            }
            if (workspaceDirectory.getDirectoryName() != null) {
                jsonGenerator.writeFieldName("DirectoryName").writeValue(workspaceDirectory.getDirectoryName());
            }
            if (workspaceDirectory.getRegistrationCode() != null) {
                jsonGenerator.writeFieldName("RegistrationCode").writeValue(workspaceDirectory.getRegistrationCode());
            }
            if (!(subnetIdsList = (SdkInternalList)workspaceDirectory.getSubnetIds()).isEmpty() || !subnetIdsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("SubnetIds");
                jsonGenerator.writeStartArray();
                for (String subnetIdsListValue : subnetIdsList) {
                    if (subnetIdsListValue == null) continue;
                    jsonGenerator.writeValue(subnetIdsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (!(dnsIpAddressesList = (SdkInternalList)workspaceDirectory.getDnsIpAddresses()).isEmpty() || !dnsIpAddressesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("DnsIpAddresses");
                jsonGenerator.writeStartArray();
                for (String dnsIpAddressesListValue : dnsIpAddressesList) {
                    if (dnsIpAddressesListValue == null) continue;
                    jsonGenerator.writeValue(dnsIpAddressesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (workspaceDirectory.getCustomerUserName() != null) {
                jsonGenerator.writeFieldName("CustomerUserName").writeValue(workspaceDirectory.getCustomerUserName());
            }
            if (workspaceDirectory.getIamRoleId() != null) {
                jsonGenerator.writeFieldName("IamRoleId").writeValue(workspaceDirectory.getIamRoleId());
            }
            if (workspaceDirectory.getDirectoryType() != null) {
                jsonGenerator.writeFieldName("DirectoryType").writeValue(workspaceDirectory.getDirectoryType());
            }
            if (workspaceDirectory.getWorkspaceSecurityGroupId() != null) {
                jsonGenerator.writeFieldName("WorkspaceSecurityGroupId").writeValue(workspaceDirectory.getWorkspaceSecurityGroupId());
            }
            if (workspaceDirectory.getState() != null) {
                jsonGenerator.writeFieldName("State").writeValue(workspaceDirectory.getState());
            }
            if (workspaceDirectory.getWorkspaceCreationProperties() != null) {
                jsonGenerator.writeFieldName("WorkspaceCreationProperties");
                DefaultWorkspaceCreationPropertiesJsonMarshaller.getInstance().marshall(workspaceDirectory.getWorkspaceCreationProperties(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static WorkspaceDirectoryJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new WorkspaceDirectoryJsonMarshaller();
        }
        return instance;
    }
}

