/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.vpclattice;

import javax.annotation.Generated;

import com.amazonaws.services.vpclattice.model.*;

/**
 * Abstract implementation of {@code AmazonVPCLatticeAsync}. Convenient method forms pass through to the corresponding
 * overload that takes a request object and an {@code AsyncHandler}, which throws an
 * {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAmazonVPCLatticeAsync extends AbstractAmazonVPCLattice implements AmazonVPCLatticeAsync {

    protected AbstractAmazonVPCLatticeAsync() {
    }

    @Override
    public java.util.concurrent.Future<BatchUpdateRuleResult> batchUpdateRuleAsync(BatchUpdateRuleRequest request) {

        return batchUpdateRuleAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<BatchUpdateRuleResult> batchUpdateRuleAsync(BatchUpdateRuleRequest request,
            com.amazonaws.handlers.AsyncHandler<BatchUpdateRuleRequest, BatchUpdateRuleResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateAccessLogSubscriptionResult> createAccessLogSubscriptionAsync(CreateAccessLogSubscriptionRequest request) {

        return createAccessLogSubscriptionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateAccessLogSubscriptionResult> createAccessLogSubscriptionAsync(CreateAccessLogSubscriptionRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateAccessLogSubscriptionRequest, CreateAccessLogSubscriptionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateListenerResult> createListenerAsync(CreateListenerRequest request) {

        return createListenerAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateListenerResult> createListenerAsync(CreateListenerRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateListenerRequest, CreateListenerResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateRuleResult> createRuleAsync(CreateRuleRequest request) {

        return createRuleAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateRuleResult> createRuleAsync(CreateRuleRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateRuleRequest, CreateRuleResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateServiceResult> createServiceAsync(CreateServiceRequest request) {

        return createServiceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateServiceResult> createServiceAsync(CreateServiceRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateServiceRequest, CreateServiceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateServiceNetworkResult> createServiceNetworkAsync(CreateServiceNetworkRequest request) {

        return createServiceNetworkAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateServiceNetworkResult> createServiceNetworkAsync(CreateServiceNetworkRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateServiceNetworkRequest, CreateServiceNetworkResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateServiceNetworkServiceAssociationResult> createServiceNetworkServiceAssociationAsync(
            CreateServiceNetworkServiceAssociationRequest request) {

        return createServiceNetworkServiceAssociationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateServiceNetworkServiceAssociationResult> createServiceNetworkServiceAssociationAsync(
            CreateServiceNetworkServiceAssociationRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateServiceNetworkServiceAssociationRequest, CreateServiceNetworkServiceAssociationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateServiceNetworkVpcAssociationResult> createServiceNetworkVpcAssociationAsync(
            CreateServiceNetworkVpcAssociationRequest request) {

        return createServiceNetworkVpcAssociationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateServiceNetworkVpcAssociationResult> createServiceNetworkVpcAssociationAsync(
            CreateServiceNetworkVpcAssociationRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateServiceNetworkVpcAssociationRequest, CreateServiceNetworkVpcAssociationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateTargetGroupResult> createTargetGroupAsync(CreateTargetGroupRequest request) {

        return createTargetGroupAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateTargetGroupResult> createTargetGroupAsync(CreateTargetGroupRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateTargetGroupRequest, CreateTargetGroupResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteAccessLogSubscriptionResult> deleteAccessLogSubscriptionAsync(DeleteAccessLogSubscriptionRequest request) {

        return deleteAccessLogSubscriptionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteAccessLogSubscriptionResult> deleteAccessLogSubscriptionAsync(DeleteAccessLogSubscriptionRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteAccessLogSubscriptionRequest, DeleteAccessLogSubscriptionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteAuthPolicyResult> deleteAuthPolicyAsync(DeleteAuthPolicyRequest request) {

        return deleteAuthPolicyAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteAuthPolicyResult> deleteAuthPolicyAsync(DeleteAuthPolicyRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteAuthPolicyRequest, DeleteAuthPolicyResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteListenerResult> deleteListenerAsync(DeleteListenerRequest request) {

        return deleteListenerAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteListenerResult> deleteListenerAsync(DeleteListenerRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteListenerRequest, DeleteListenerResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteResourcePolicyResult> deleteResourcePolicyAsync(DeleteResourcePolicyRequest request) {

        return deleteResourcePolicyAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteResourcePolicyResult> deleteResourcePolicyAsync(DeleteResourcePolicyRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteResourcePolicyRequest, DeleteResourcePolicyResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteRuleResult> deleteRuleAsync(DeleteRuleRequest request) {

        return deleteRuleAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteRuleResult> deleteRuleAsync(DeleteRuleRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteRuleRequest, DeleteRuleResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteServiceResult> deleteServiceAsync(DeleteServiceRequest request) {

        return deleteServiceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteServiceResult> deleteServiceAsync(DeleteServiceRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteServiceRequest, DeleteServiceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteServiceNetworkResult> deleteServiceNetworkAsync(DeleteServiceNetworkRequest request) {

        return deleteServiceNetworkAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteServiceNetworkResult> deleteServiceNetworkAsync(DeleteServiceNetworkRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteServiceNetworkRequest, DeleteServiceNetworkResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteServiceNetworkServiceAssociationResult> deleteServiceNetworkServiceAssociationAsync(
            DeleteServiceNetworkServiceAssociationRequest request) {

        return deleteServiceNetworkServiceAssociationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteServiceNetworkServiceAssociationResult> deleteServiceNetworkServiceAssociationAsync(
            DeleteServiceNetworkServiceAssociationRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteServiceNetworkServiceAssociationRequest, DeleteServiceNetworkServiceAssociationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteServiceNetworkVpcAssociationResult> deleteServiceNetworkVpcAssociationAsync(
            DeleteServiceNetworkVpcAssociationRequest request) {

        return deleteServiceNetworkVpcAssociationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteServiceNetworkVpcAssociationResult> deleteServiceNetworkVpcAssociationAsync(
            DeleteServiceNetworkVpcAssociationRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteServiceNetworkVpcAssociationRequest, DeleteServiceNetworkVpcAssociationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteTargetGroupResult> deleteTargetGroupAsync(DeleteTargetGroupRequest request) {

        return deleteTargetGroupAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteTargetGroupResult> deleteTargetGroupAsync(DeleteTargetGroupRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteTargetGroupRequest, DeleteTargetGroupResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeregisterTargetsResult> deregisterTargetsAsync(DeregisterTargetsRequest request) {

        return deregisterTargetsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeregisterTargetsResult> deregisterTargetsAsync(DeregisterTargetsRequest request,
            com.amazonaws.handlers.AsyncHandler<DeregisterTargetsRequest, DeregisterTargetsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetAccessLogSubscriptionResult> getAccessLogSubscriptionAsync(GetAccessLogSubscriptionRequest request) {

        return getAccessLogSubscriptionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetAccessLogSubscriptionResult> getAccessLogSubscriptionAsync(GetAccessLogSubscriptionRequest request,
            com.amazonaws.handlers.AsyncHandler<GetAccessLogSubscriptionRequest, GetAccessLogSubscriptionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetAuthPolicyResult> getAuthPolicyAsync(GetAuthPolicyRequest request) {

        return getAuthPolicyAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetAuthPolicyResult> getAuthPolicyAsync(GetAuthPolicyRequest request,
            com.amazonaws.handlers.AsyncHandler<GetAuthPolicyRequest, GetAuthPolicyResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetListenerResult> getListenerAsync(GetListenerRequest request) {

        return getListenerAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetListenerResult> getListenerAsync(GetListenerRequest request,
            com.amazonaws.handlers.AsyncHandler<GetListenerRequest, GetListenerResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetResourcePolicyResult> getResourcePolicyAsync(GetResourcePolicyRequest request) {

        return getResourcePolicyAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetResourcePolicyResult> getResourcePolicyAsync(GetResourcePolicyRequest request,
            com.amazonaws.handlers.AsyncHandler<GetResourcePolicyRequest, GetResourcePolicyResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetRuleResult> getRuleAsync(GetRuleRequest request) {

        return getRuleAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetRuleResult> getRuleAsync(GetRuleRequest request,
            com.amazonaws.handlers.AsyncHandler<GetRuleRequest, GetRuleResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetServiceResult> getServiceAsync(GetServiceRequest request) {

        return getServiceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetServiceResult> getServiceAsync(GetServiceRequest request,
            com.amazonaws.handlers.AsyncHandler<GetServiceRequest, GetServiceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetServiceNetworkResult> getServiceNetworkAsync(GetServiceNetworkRequest request) {

        return getServiceNetworkAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetServiceNetworkResult> getServiceNetworkAsync(GetServiceNetworkRequest request,
            com.amazonaws.handlers.AsyncHandler<GetServiceNetworkRequest, GetServiceNetworkResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetServiceNetworkServiceAssociationResult> getServiceNetworkServiceAssociationAsync(
            GetServiceNetworkServiceAssociationRequest request) {

        return getServiceNetworkServiceAssociationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetServiceNetworkServiceAssociationResult> getServiceNetworkServiceAssociationAsync(
            GetServiceNetworkServiceAssociationRequest request,
            com.amazonaws.handlers.AsyncHandler<GetServiceNetworkServiceAssociationRequest, GetServiceNetworkServiceAssociationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetServiceNetworkVpcAssociationResult> getServiceNetworkVpcAssociationAsync(
            GetServiceNetworkVpcAssociationRequest request) {

        return getServiceNetworkVpcAssociationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetServiceNetworkVpcAssociationResult> getServiceNetworkVpcAssociationAsync(
            GetServiceNetworkVpcAssociationRequest request,
            com.amazonaws.handlers.AsyncHandler<GetServiceNetworkVpcAssociationRequest, GetServiceNetworkVpcAssociationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetTargetGroupResult> getTargetGroupAsync(GetTargetGroupRequest request) {

        return getTargetGroupAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetTargetGroupResult> getTargetGroupAsync(GetTargetGroupRequest request,
            com.amazonaws.handlers.AsyncHandler<GetTargetGroupRequest, GetTargetGroupResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListAccessLogSubscriptionsResult> listAccessLogSubscriptionsAsync(ListAccessLogSubscriptionsRequest request) {

        return listAccessLogSubscriptionsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListAccessLogSubscriptionsResult> listAccessLogSubscriptionsAsync(ListAccessLogSubscriptionsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListAccessLogSubscriptionsRequest, ListAccessLogSubscriptionsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListListenersResult> listListenersAsync(ListListenersRequest request) {

        return listListenersAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListListenersResult> listListenersAsync(ListListenersRequest request,
            com.amazonaws.handlers.AsyncHandler<ListListenersRequest, ListListenersResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListRulesResult> listRulesAsync(ListRulesRequest request) {

        return listRulesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListRulesResult> listRulesAsync(ListRulesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListRulesRequest, ListRulesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListServiceNetworkServiceAssociationsResult> listServiceNetworkServiceAssociationsAsync(
            ListServiceNetworkServiceAssociationsRequest request) {

        return listServiceNetworkServiceAssociationsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListServiceNetworkServiceAssociationsResult> listServiceNetworkServiceAssociationsAsync(
            ListServiceNetworkServiceAssociationsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListServiceNetworkServiceAssociationsRequest, ListServiceNetworkServiceAssociationsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListServiceNetworkVpcAssociationsResult> listServiceNetworkVpcAssociationsAsync(
            ListServiceNetworkVpcAssociationsRequest request) {

        return listServiceNetworkVpcAssociationsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListServiceNetworkVpcAssociationsResult> listServiceNetworkVpcAssociationsAsync(
            ListServiceNetworkVpcAssociationsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListServiceNetworkVpcAssociationsRequest, ListServiceNetworkVpcAssociationsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListServiceNetworksResult> listServiceNetworksAsync(ListServiceNetworksRequest request) {

        return listServiceNetworksAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListServiceNetworksResult> listServiceNetworksAsync(ListServiceNetworksRequest request,
            com.amazonaws.handlers.AsyncHandler<ListServiceNetworksRequest, ListServiceNetworksResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListServicesResult> listServicesAsync(ListServicesRequest request) {

        return listServicesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListServicesResult> listServicesAsync(ListServicesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListServicesRequest, ListServicesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {

        return listTagsForResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListTargetGroupsResult> listTargetGroupsAsync(ListTargetGroupsRequest request) {

        return listTargetGroupsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListTargetGroupsResult> listTargetGroupsAsync(ListTargetGroupsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListTargetGroupsRequest, ListTargetGroupsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListTargetsResult> listTargetsAsync(ListTargetsRequest request) {

        return listTargetsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListTargetsResult> listTargetsAsync(ListTargetsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListTargetsRequest, ListTargetsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<PutAuthPolicyResult> putAuthPolicyAsync(PutAuthPolicyRequest request) {

        return putAuthPolicyAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<PutAuthPolicyResult> putAuthPolicyAsync(PutAuthPolicyRequest request,
            com.amazonaws.handlers.AsyncHandler<PutAuthPolicyRequest, PutAuthPolicyResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<PutResourcePolicyResult> putResourcePolicyAsync(PutResourcePolicyRequest request) {

        return putResourcePolicyAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<PutResourcePolicyResult> putResourcePolicyAsync(PutResourcePolicyRequest request,
            com.amazonaws.handlers.AsyncHandler<PutResourcePolicyRequest, PutResourcePolicyResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<RegisterTargetsResult> registerTargetsAsync(RegisterTargetsRequest request) {

        return registerTargetsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<RegisterTargetsResult> registerTargetsAsync(RegisterTargetsRequest request,
            com.amazonaws.handlers.AsyncHandler<RegisterTargetsRequest, RegisterTargetsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {

        return tagResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<TagResourceResult> tagResourceAsync(TagResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {

        return untagResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateAccessLogSubscriptionResult> updateAccessLogSubscriptionAsync(UpdateAccessLogSubscriptionRequest request) {

        return updateAccessLogSubscriptionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateAccessLogSubscriptionResult> updateAccessLogSubscriptionAsync(UpdateAccessLogSubscriptionRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateAccessLogSubscriptionRequest, UpdateAccessLogSubscriptionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateListenerResult> updateListenerAsync(UpdateListenerRequest request) {

        return updateListenerAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateListenerResult> updateListenerAsync(UpdateListenerRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateListenerRequest, UpdateListenerResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateRuleResult> updateRuleAsync(UpdateRuleRequest request) {

        return updateRuleAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateRuleResult> updateRuleAsync(UpdateRuleRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateRuleRequest, UpdateRuleResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateServiceResult> updateServiceAsync(UpdateServiceRequest request) {

        return updateServiceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateServiceResult> updateServiceAsync(UpdateServiceRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateServiceRequest, UpdateServiceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateServiceNetworkResult> updateServiceNetworkAsync(UpdateServiceNetworkRequest request) {

        return updateServiceNetworkAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateServiceNetworkResult> updateServiceNetworkAsync(UpdateServiceNetworkRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateServiceNetworkRequest, UpdateServiceNetworkResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateServiceNetworkVpcAssociationResult> updateServiceNetworkVpcAssociationAsync(
            UpdateServiceNetworkVpcAssociationRequest request) {

        return updateServiceNetworkVpcAssociationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateServiceNetworkVpcAssociationResult> updateServiceNetworkVpcAssociationAsync(
            UpdateServiceNetworkVpcAssociationRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateServiceNetworkVpcAssociationRequest, UpdateServiceNetworkVpcAssociationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateTargetGroupResult> updateTargetGroupAsync(UpdateTargetGroupRequest request) {

        return updateTargetGroupAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateTargetGroupResult> updateTargetGroupAsync(UpdateTargetGroupRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateTargetGroupRequest, UpdateTargetGroupResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

}
