/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.verifiedpermissions.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.verifiedpermissions.model.transform.OpenIdConnectAccessTokenConfigurationItemMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class OpenIdConnectAccessTokenConfigurationItem
implements Serializable,
Cloneable,
StructuredPojo {
    private String principalIdClaim;
    private List<String> audiences;

    public void setPrincipalIdClaim(String principalIdClaim) {
        this.principalIdClaim = principalIdClaim;
    }

    public String getPrincipalIdClaim() {
        return this.principalIdClaim;
    }

    public OpenIdConnectAccessTokenConfigurationItem withPrincipalIdClaim(String principalIdClaim) {
        this.setPrincipalIdClaim(principalIdClaim);
        return this;
    }

    public List<String> getAudiences() {
        return this.audiences;
    }

    public void setAudiences(Collection<String> audiences) {
        if (audiences == null) {
            this.audiences = null;
            return;
        }
        this.audiences = new ArrayList<String>(audiences);
    }

    public OpenIdConnectAccessTokenConfigurationItem withAudiences(String ... audiences) {
        if (this.audiences == null) {
            this.setAudiences(new ArrayList<String>(audiences.length));
        }
        for (String ele : audiences) {
            this.audiences.add(ele);
        }
        return this;
    }

    public OpenIdConnectAccessTokenConfigurationItem withAudiences(Collection<String> audiences) {
        this.setAudiences(audiences);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPrincipalIdClaim() != null) {
            sb.append("PrincipalIdClaim: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getAudiences() != null) {
            sb.append("Audiences: ").append(this.getAudiences());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpenIdConnectAccessTokenConfigurationItem)) {
            return false;
        }
        OpenIdConnectAccessTokenConfigurationItem other = (OpenIdConnectAccessTokenConfigurationItem)obj;
        if (other.getPrincipalIdClaim() == null ^ this.getPrincipalIdClaim() == null) {
            return false;
        }
        if (other.getPrincipalIdClaim() != null && !other.getPrincipalIdClaim().equals(this.getPrincipalIdClaim())) {
            return false;
        }
        if (other.getAudiences() == null ^ this.getAudiences() == null) {
            return false;
        }
        return other.getAudiences() == null || other.getAudiences().equals(this.getAudiences());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPrincipalIdClaim() == null ? 0 : this.getPrincipalIdClaim().hashCode());
        hashCode = 31 * hashCode + (this.getAudiences() == null ? 0 : this.getAudiences().hashCode());
        return hashCode;
    }

    public OpenIdConnectAccessTokenConfigurationItem clone() {
        try {
            return (OpenIdConnectAccessTokenConfigurationItem)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OpenIdConnectAccessTokenConfigurationItemMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

