/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.verifiedpermissions.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.verifiedpermissions.model.EntityIdentifier;
import com.amazonaws.services.verifiedpermissions.model.transform.AttributeValueMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AttributeValue
implements Serializable,
Cloneable,
StructuredPojo {
    private Boolean booleanValue;
    private EntityIdentifier entityIdentifier;
    private Long longValue;
    private String string;
    private List<AttributeValue> set;
    private Map<String, AttributeValue> record;

    public void setBoolean(Boolean booleanValue) {
        this.booleanValue = booleanValue;
    }

    public Boolean getBoolean() {
        return this.booleanValue;
    }

    public AttributeValue withBoolean(Boolean booleanValue) {
        this.setBoolean(booleanValue);
        return this;
    }

    public Boolean isBoolean() {
        return this.booleanValue;
    }

    public void setEntityIdentifier(EntityIdentifier entityIdentifier) {
        this.entityIdentifier = entityIdentifier;
    }

    public EntityIdentifier getEntityIdentifier() {
        return this.entityIdentifier;
    }

    public AttributeValue withEntityIdentifier(EntityIdentifier entityIdentifier) {
        this.setEntityIdentifier(entityIdentifier);
        return this;
    }

    public void setLong(Long longValue) {
        this.longValue = longValue;
    }

    public Long getLong() {
        return this.longValue;
    }

    public AttributeValue withLong(Long longValue) {
        this.setLong(longValue);
        return this;
    }

    public void setString(String string) {
        this.string = string;
    }

    public String getString() {
        return this.string;
    }

    public AttributeValue withString(String string) {
        this.setString(string);
        return this;
    }

    public List<AttributeValue> getSet() {
        return this.set;
    }

    public void setSet(Collection<AttributeValue> set) {
        if (set == null) {
            this.set = null;
            return;
        }
        this.set = new ArrayList<AttributeValue>(set);
    }

    public AttributeValue withSet(AttributeValue ... set) {
        if (this.set == null) {
            this.setSet(new ArrayList<AttributeValue>(set.length));
        }
        for (AttributeValue ele : set) {
            this.set.add(ele);
        }
        return this;
    }

    public AttributeValue withSet(Collection<AttributeValue> set) {
        this.setSet(set);
        return this;
    }

    public Map<String, AttributeValue> getRecord() {
        return this.record;
    }

    public void setRecord(Map<String, AttributeValue> record) {
        this.record = record;
    }

    public AttributeValue withRecord(Map<String, AttributeValue> record) {
        this.setRecord(record);
        return this;
    }

    public AttributeValue addRecordEntry(String key, AttributeValue value) {
        if (null == this.record) {
            this.record = new HashMap<String, AttributeValue>();
        }
        if (this.record.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.record.put(key, value);
        return this;
    }

    public AttributeValue clearRecordEntries() {
        this.record = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBoolean() != null) {
            sb.append("Boolean: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getEntityIdentifier() != null) {
            sb.append("EntityIdentifier: ").append(this.getEntityIdentifier()).append(",");
        }
        if (this.getLong() != null) {
            sb.append("Long: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getString() != null) {
            sb.append("String: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getSet() != null) {
            sb.append("Set: ").append(this.getSet()).append(",");
        }
        if (this.getRecord() != null) {
            sb.append("Record: ").append(this.getRecord());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttributeValue)) {
            return false;
        }
        AttributeValue other = (AttributeValue)obj;
        if (other.getBoolean() == null ^ this.getBoolean() == null) {
            return false;
        }
        if (other.getBoolean() != null && !other.getBoolean().equals(this.getBoolean())) {
            return false;
        }
        if (other.getEntityIdentifier() == null ^ this.getEntityIdentifier() == null) {
            return false;
        }
        if (other.getEntityIdentifier() != null && !other.getEntityIdentifier().equals(this.getEntityIdentifier())) {
            return false;
        }
        if (other.getLong() == null ^ this.getLong() == null) {
            return false;
        }
        if (other.getLong() != null && !other.getLong().equals(this.getLong())) {
            return false;
        }
        if (other.getString() == null ^ this.getString() == null) {
            return false;
        }
        if (other.getString() != null && !other.getString().equals(this.getString())) {
            return false;
        }
        if (other.getSet() == null ^ this.getSet() == null) {
            return false;
        }
        if (other.getSet() != null && !other.getSet().equals(this.getSet())) {
            return false;
        }
        if (other.getRecord() == null ^ this.getRecord() == null) {
            return false;
        }
        return other.getRecord() == null || other.getRecord().equals(this.getRecord());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBoolean() == null ? 0 : this.getBoolean().hashCode());
        hashCode = 31 * hashCode + (this.getEntityIdentifier() == null ? 0 : this.getEntityIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getLong() == null ? 0 : this.getLong().hashCode());
        hashCode = 31 * hashCode + (this.getString() == null ? 0 : this.getString().hashCode());
        hashCode = 31 * hashCode + (this.getSet() == null ? 0 : this.getSet().hashCode());
        hashCode = 31 * hashCode + (this.getRecord() == null ? 0 : this.getRecord().hashCode());
        return hashCode;
    }

    public AttributeValue clone() {
        try {
            return (AttributeValue)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AttributeValueMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

