/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.transfer.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.transfer.model.Tag;
import com.amazonaws.services.transfer.model.WorkflowStep;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateWorkflowRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String description;
    private List<WorkflowStep> steps;
    private List<WorkflowStep> onExceptionSteps;
    private List<Tag> tags;

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateWorkflowRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<WorkflowStep> getSteps() {
        return this.steps;
    }

    public void setSteps(Collection<WorkflowStep> steps) {
        if (steps == null) {
            this.steps = null;
            return;
        }
        this.steps = new ArrayList<WorkflowStep>(steps);
    }

    public CreateWorkflowRequest withSteps(WorkflowStep ... steps) {
        if (this.steps == null) {
            this.setSteps(new ArrayList<WorkflowStep>(steps.length));
        }
        for (WorkflowStep ele : steps) {
            this.steps.add(ele);
        }
        return this;
    }

    public CreateWorkflowRequest withSteps(Collection<WorkflowStep> steps) {
        this.setSteps(steps);
        return this;
    }

    public List<WorkflowStep> getOnExceptionSteps() {
        return this.onExceptionSteps;
    }

    public void setOnExceptionSteps(Collection<WorkflowStep> onExceptionSteps) {
        if (onExceptionSteps == null) {
            this.onExceptionSteps = null;
            return;
        }
        this.onExceptionSteps = new ArrayList<WorkflowStep>(onExceptionSteps);
    }

    public CreateWorkflowRequest withOnExceptionSteps(WorkflowStep ... onExceptionSteps) {
        if (this.onExceptionSteps == null) {
            this.setOnExceptionSteps(new ArrayList<WorkflowStep>(onExceptionSteps.length));
        }
        for (WorkflowStep ele : onExceptionSteps) {
            this.onExceptionSteps.add(ele);
        }
        return this;
    }

    public CreateWorkflowRequest withOnExceptionSteps(Collection<WorkflowStep> onExceptionSteps) {
        this.setOnExceptionSteps(onExceptionSteps);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateWorkflowRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateWorkflowRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getSteps() != null) {
            sb.append("Steps: ").append(this.getSteps()).append(",");
        }
        if (this.getOnExceptionSteps() != null) {
            sb.append("OnExceptionSteps: ").append(this.getOnExceptionSteps()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorkflowRequest)) {
            return false;
        }
        CreateWorkflowRequest other = (CreateWorkflowRequest)obj;
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getSteps() == null ^ this.getSteps() == null) {
            return false;
        }
        if (other.getSteps() != null && !other.getSteps().equals(this.getSteps())) {
            return false;
        }
        if (other.getOnExceptionSteps() == null ^ this.getOnExceptionSteps() == null) {
            return false;
        }
        if (other.getOnExceptionSteps() != null && !other.getOnExceptionSteps().equals(this.getOnExceptionSteps())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getSteps() == null ? 0 : this.getSteps().hashCode());
        hashCode = 31 * hashCode + (this.getOnExceptionSteps() == null ? 0 : this.getOnExceptionSteps().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateWorkflowRequest clone() {
        return (CreateWorkflowRequest)super.clone();
    }
}

