/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.transcribe;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.transcribe.AmazonTranscribe;
import com.amazonaws.services.transcribe.AmazonTranscribeClientBuilder;
import com.amazonaws.services.transcribe.model.AmazonTranscribeException;
import com.amazonaws.services.transcribe.model.BadRequestException;
import com.amazonaws.services.transcribe.model.ConflictException;
import com.amazonaws.services.transcribe.model.CreateVocabularyRequest;
import com.amazonaws.services.transcribe.model.CreateVocabularyResult;
import com.amazonaws.services.transcribe.model.DeleteVocabularyRequest;
import com.amazonaws.services.transcribe.model.DeleteVocabularyResult;
import com.amazonaws.services.transcribe.model.GetTranscriptionJobRequest;
import com.amazonaws.services.transcribe.model.GetTranscriptionJobResult;
import com.amazonaws.services.transcribe.model.GetVocabularyRequest;
import com.amazonaws.services.transcribe.model.GetVocabularyResult;
import com.amazonaws.services.transcribe.model.InternalFailureException;
import com.amazonaws.services.transcribe.model.LimitExceededException;
import com.amazonaws.services.transcribe.model.ListTranscriptionJobsRequest;
import com.amazonaws.services.transcribe.model.ListTranscriptionJobsResult;
import com.amazonaws.services.transcribe.model.ListVocabulariesRequest;
import com.amazonaws.services.transcribe.model.ListVocabulariesResult;
import com.amazonaws.services.transcribe.model.NotFoundException;
import com.amazonaws.services.transcribe.model.StartTranscriptionJobRequest;
import com.amazonaws.services.transcribe.model.StartTranscriptionJobResult;
import com.amazonaws.services.transcribe.model.UpdateVocabularyRequest;
import com.amazonaws.services.transcribe.model.UpdateVocabularyResult;
import com.amazonaws.services.transcribe.model.transform.CreateVocabularyRequestProtocolMarshaller;
import com.amazonaws.services.transcribe.model.transform.CreateVocabularyResultJsonUnmarshaller;
import com.amazonaws.services.transcribe.model.transform.DeleteVocabularyRequestProtocolMarshaller;
import com.amazonaws.services.transcribe.model.transform.DeleteVocabularyResultJsonUnmarshaller;
import com.amazonaws.services.transcribe.model.transform.GetTranscriptionJobRequestProtocolMarshaller;
import com.amazonaws.services.transcribe.model.transform.GetTranscriptionJobResultJsonUnmarshaller;
import com.amazonaws.services.transcribe.model.transform.GetVocabularyRequestProtocolMarshaller;
import com.amazonaws.services.transcribe.model.transform.GetVocabularyResultJsonUnmarshaller;
import com.amazonaws.services.transcribe.model.transform.ListTranscriptionJobsRequestProtocolMarshaller;
import com.amazonaws.services.transcribe.model.transform.ListTranscriptionJobsResultJsonUnmarshaller;
import com.amazonaws.services.transcribe.model.transform.ListVocabulariesRequestProtocolMarshaller;
import com.amazonaws.services.transcribe.model.transform.ListVocabulariesResultJsonUnmarshaller;
import com.amazonaws.services.transcribe.model.transform.StartTranscriptionJobRequestProtocolMarshaller;
import com.amazonaws.services.transcribe.model.transform.StartTranscriptionJobResultJsonUnmarshaller;
import com.amazonaws.services.transcribe.model.transform.UpdateVocabularyRequestProtocolMarshaller;
import com.amazonaws.services.transcribe.model.transform.UpdateVocabularyResultJsonUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonTranscribeClient
extends AmazonWebServiceClient
implements AmazonTranscribe {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonTranscribe.class);
    private static final String DEFAULT_SIGNING_NAME = "transcribe";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withModeledClass(ConflictException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NotFoundException").withModeledClass(NotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalFailureException").withModeledClass(InternalFailureException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("BadRequestException").withModeledClass(BadRequestException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withModeledClass(LimitExceededException.class)).withBaseServiceExceptionClass(AmazonTranscribeException.class));

    public static AmazonTranscribeClientBuilder builder() {
        return AmazonTranscribeClientBuilder.standard();
    }

    AmazonTranscribeClient(AwsSyncClientParams clientParams) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.init();
    }

    AmazonTranscribeClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("transcribe.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/transcribe/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/transcribe/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CreateVocabularyResult createVocabulary(CreateVocabularyRequest request) {
        request = (CreateVocabularyRequest)this.beforeClientExecution(request);
        return this.executeCreateVocabulary(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateVocabularyResult executeCreateVocabulary(CreateVocabularyRequest createVocabularyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createVocabularyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateVocabularyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateVocabularyRequestProtocolMarshaller(protocolFactory).marshall((CreateVocabularyRequest)super.beforeMarshalling((AmazonWebServiceRequest)createVocabularyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Transcribe");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateVocabulary");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateVocabularyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateVocabularyResult createVocabularyResult = (CreateVocabularyResult)response.getAwsResponse();
            return createVocabularyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteVocabularyResult deleteVocabulary(DeleteVocabularyRequest request) {
        request = (DeleteVocabularyRequest)this.beforeClientExecution(request);
        return this.executeDeleteVocabulary(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteVocabularyResult executeDeleteVocabulary(DeleteVocabularyRequest deleteVocabularyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteVocabularyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteVocabularyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteVocabularyRequestProtocolMarshaller(protocolFactory).marshall((DeleteVocabularyRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteVocabularyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Transcribe");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteVocabulary");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteVocabularyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteVocabularyResult deleteVocabularyResult = (DeleteVocabularyResult)response.getAwsResponse();
            return deleteVocabularyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetTranscriptionJobResult getTranscriptionJob(GetTranscriptionJobRequest request) {
        request = (GetTranscriptionJobRequest)this.beforeClientExecution(request);
        return this.executeGetTranscriptionJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetTranscriptionJobResult executeGetTranscriptionJob(GetTranscriptionJobRequest getTranscriptionJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getTranscriptionJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetTranscriptionJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetTranscriptionJobRequestProtocolMarshaller(protocolFactory).marshall((GetTranscriptionJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)getTranscriptionJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Transcribe");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetTranscriptionJob");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetTranscriptionJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetTranscriptionJobResult getTranscriptionJobResult = (GetTranscriptionJobResult)response.getAwsResponse();
            return getTranscriptionJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetVocabularyResult getVocabulary(GetVocabularyRequest request) {
        request = (GetVocabularyRequest)this.beforeClientExecution(request);
        return this.executeGetVocabulary(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetVocabularyResult executeGetVocabulary(GetVocabularyRequest getVocabularyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getVocabularyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetVocabularyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetVocabularyRequestProtocolMarshaller(protocolFactory).marshall((GetVocabularyRequest)super.beforeMarshalling((AmazonWebServiceRequest)getVocabularyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Transcribe");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetVocabulary");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetVocabularyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetVocabularyResult getVocabularyResult = (GetVocabularyResult)response.getAwsResponse();
            return getVocabularyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTranscriptionJobsResult listTranscriptionJobs(ListTranscriptionJobsRequest request) {
        request = (ListTranscriptionJobsRequest)this.beforeClientExecution(request);
        return this.executeListTranscriptionJobs(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTranscriptionJobsResult executeListTranscriptionJobs(ListTranscriptionJobsRequest listTranscriptionJobsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTranscriptionJobsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTranscriptionJobsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTranscriptionJobsRequestProtocolMarshaller(protocolFactory).marshall((ListTranscriptionJobsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTranscriptionJobsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Transcribe");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTranscriptionJobs");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTranscriptionJobsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTranscriptionJobsResult listTranscriptionJobsResult = (ListTranscriptionJobsResult)response.getAwsResponse();
            return listTranscriptionJobsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListVocabulariesResult listVocabularies(ListVocabulariesRequest request) {
        request = (ListVocabulariesRequest)this.beforeClientExecution(request);
        return this.executeListVocabularies(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListVocabulariesResult executeListVocabularies(ListVocabulariesRequest listVocabulariesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listVocabulariesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListVocabulariesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListVocabulariesRequestProtocolMarshaller(protocolFactory).marshall((ListVocabulariesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listVocabulariesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Transcribe");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListVocabularies");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListVocabulariesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListVocabulariesResult listVocabulariesResult = (ListVocabulariesResult)response.getAwsResponse();
            return listVocabulariesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartTranscriptionJobResult startTranscriptionJob(StartTranscriptionJobRequest request) {
        request = (StartTranscriptionJobRequest)this.beforeClientExecution(request);
        return this.executeStartTranscriptionJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartTranscriptionJobResult executeStartTranscriptionJob(StartTranscriptionJobRequest startTranscriptionJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startTranscriptionJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartTranscriptionJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartTranscriptionJobRequestProtocolMarshaller(protocolFactory).marshall((StartTranscriptionJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)startTranscriptionJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Transcribe");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StartTranscriptionJob");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartTranscriptionJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartTranscriptionJobResult startTranscriptionJobResult = (StartTranscriptionJobResult)response.getAwsResponse();
            return startTranscriptionJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateVocabularyResult updateVocabulary(UpdateVocabularyRequest request) {
        request = (UpdateVocabularyRequest)this.beforeClientExecution(request);
        return this.executeUpdateVocabulary(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateVocabularyResult executeUpdateVocabulary(UpdateVocabularyRequest updateVocabularyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateVocabularyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateVocabularyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateVocabularyRequestProtocolMarshaller(protocolFactory).marshall((UpdateVocabularyRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateVocabularyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Transcribe");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateVocabulary");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateVocabularyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateVocabularyResult updateVocabularyResult = (UpdateVocabularyResult)response.getAwsResponse();
            return updateVocabularyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

