/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.timestreamquery.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.timestreamquery.model.S3ReportLocation;

@SdkInternalApi
public class S3ReportLocationMarshaller {
    private static final MarshallingInfo<String> BUCKETNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BucketName").build();
    private static final MarshallingInfo<String> OBJECTKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ObjectKey").build();
    private static final S3ReportLocationMarshaller instance = new S3ReportLocationMarshaller();

    public static S3ReportLocationMarshaller getInstance() {
        return instance;
    }

    public void marshall(S3ReportLocation s3ReportLocation, ProtocolMarshaller protocolMarshaller) {
        if (s3ReportLocation == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)s3ReportLocation.getBucketName(), BUCKETNAME_BINDING);
            protocolMarshaller.marshall((Object)s3ReportLocation.getObjectKey(), OBJECTKEY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

