/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.timestreaminfluxdb;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.timestreaminfluxdb.AWSTimestreamInfluxDBAsync;
import com.amazonaws.services.timestreaminfluxdb.AWSTimestreamInfluxDBAsyncClientBuilder;
import com.amazonaws.services.timestreaminfluxdb.AWSTimestreamInfluxDBClient;
import com.amazonaws.services.timestreaminfluxdb.model.CreateDbInstanceRequest;
import com.amazonaws.services.timestreaminfluxdb.model.CreateDbInstanceResult;
import com.amazonaws.services.timestreaminfluxdb.model.CreateDbParameterGroupRequest;
import com.amazonaws.services.timestreaminfluxdb.model.CreateDbParameterGroupResult;
import com.amazonaws.services.timestreaminfluxdb.model.DeleteDbInstanceRequest;
import com.amazonaws.services.timestreaminfluxdb.model.DeleteDbInstanceResult;
import com.amazonaws.services.timestreaminfluxdb.model.GetDbInstanceRequest;
import com.amazonaws.services.timestreaminfluxdb.model.GetDbInstanceResult;
import com.amazonaws.services.timestreaminfluxdb.model.GetDbParameterGroupRequest;
import com.amazonaws.services.timestreaminfluxdb.model.GetDbParameterGroupResult;
import com.amazonaws.services.timestreaminfluxdb.model.ListDbInstancesRequest;
import com.amazonaws.services.timestreaminfluxdb.model.ListDbInstancesResult;
import com.amazonaws.services.timestreaminfluxdb.model.ListDbParameterGroupsRequest;
import com.amazonaws.services.timestreaminfluxdb.model.ListDbParameterGroupsResult;
import com.amazonaws.services.timestreaminfluxdb.model.ListTagsForResourceRequest;
import com.amazonaws.services.timestreaminfluxdb.model.ListTagsForResourceResult;
import com.amazonaws.services.timestreaminfluxdb.model.TagResourceRequest;
import com.amazonaws.services.timestreaminfluxdb.model.TagResourceResult;
import com.amazonaws.services.timestreaminfluxdb.model.UntagResourceRequest;
import com.amazonaws.services.timestreaminfluxdb.model.UntagResourceResult;
import com.amazonaws.services.timestreaminfluxdb.model.UpdateDbInstanceRequest;
import com.amazonaws.services.timestreaminfluxdb.model.UpdateDbInstanceResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSTimestreamInfluxDBAsyncClient
extends AWSTimestreamInfluxDBClient
implements AWSTimestreamInfluxDBAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSTimestreamInfluxDBAsyncClientBuilder asyncBuilder() {
        return AWSTimestreamInfluxDBAsyncClientBuilder.standard();
    }

    AWSTimestreamInfluxDBAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSTimestreamInfluxDBAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateDbInstanceResult> createDbInstanceAsync(CreateDbInstanceRequest request) {
        return this.createDbInstanceAsync(request, null);
    }

    @Override
    public Future<CreateDbInstanceResult> createDbInstanceAsync(CreateDbInstanceRequest request, final AsyncHandler<CreateDbInstanceRequest, CreateDbInstanceResult> asyncHandler) {
        final CreateDbInstanceRequest finalRequest = (CreateDbInstanceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateDbInstanceResult>(){

            @Override
            public CreateDbInstanceResult call() throws Exception {
                CreateDbInstanceResult result = null;
                try {
                    result = AWSTimestreamInfluxDBAsyncClient.this.executeCreateDbInstance(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateDbParameterGroupResult> createDbParameterGroupAsync(CreateDbParameterGroupRequest request) {
        return this.createDbParameterGroupAsync(request, null);
    }

    @Override
    public Future<CreateDbParameterGroupResult> createDbParameterGroupAsync(CreateDbParameterGroupRequest request, final AsyncHandler<CreateDbParameterGroupRequest, CreateDbParameterGroupResult> asyncHandler) {
        final CreateDbParameterGroupRequest finalRequest = (CreateDbParameterGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateDbParameterGroupResult>(){

            @Override
            public CreateDbParameterGroupResult call() throws Exception {
                CreateDbParameterGroupResult result = null;
                try {
                    result = AWSTimestreamInfluxDBAsyncClient.this.executeCreateDbParameterGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteDbInstanceResult> deleteDbInstanceAsync(DeleteDbInstanceRequest request) {
        return this.deleteDbInstanceAsync(request, null);
    }

    @Override
    public Future<DeleteDbInstanceResult> deleteDbInstanceAsync(DeleteDbInstanceRequest request, final AsyncHandler<DeleteDbInstanceRequest, DeleteDbInstanceResult> asyncHandler) {
        final DeleteDbInstanceRequest finalRequest = (DeleteDbInstanceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteDbInstanceResult>(){

            @Override
            public DeleteDbInstanceResult call() throws Exception {
                DeleteDbInstanceResult result = null;
                try {
                    result = AWSTimestreamInfluxDBAsyncClient.this.executeDeleteDbInstance(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDbInstanceResult> getDbInstanceAsync(GetDbInstanceRequest request) {
        return this.getDbInstanceAsync(request, null);
    }

    @Override
    public Future<GetDbInstanceResult> getDbInstanceAsync(GetDbInstanceRequest request, final AsyncHandler<GetDbInstanceRequest, GetDbInstanceResult> asyncHandler) {
        final GetDbInstanceRequest finalRequest = (GetDbInstanceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetDbInstanceResult>(){

            @Override
            public GetDbInstanceResult call() throws Exception {
                GetDbInstanceResult result = null;
                try {
                    result = AWSTimestreamInfluxDBAsyncClient.this.executeGetDbInstance(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDbParameterGroupResult> getDbParameterGroupAsync(GetDbParameterGroupRequest request) {
        return this.getDbParameterGroupAsync(request, null);
    }

    @Override
    public Future<GetDbParameterGroupResult> getDbParameterGroupAsync(GetDbParameterGroupRequest request, final AsyncHandler<GetDbParameterGroupRequest, GetDbParameterGroupResult> asyncHandler) {
        final GetDbParameterGroupRequest finalRequest = (GetDbParameterGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetDbParameterGroupResult>(){

            @Override
            public GetDbParameterGroupResult call() throws Exception {
                GetDbParameterGroupResult result = null;
                try {
                    result = AWSTimestreamInfluxDBAsyncClient.this.executeGetDbParameterGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDbInstancesResult> listDbInstancesAsync(ListDbInstancesRequest request) {
        return this.listDbInstancesAsync(request, null);
    }

    @Override
    public Future<ListDbInstancesResult> listDbInstancesAsync(ListDbInstancesRequest request, final AsyncHandler<ListDbInstancesRequest, ListDbInstancesResult> asyncHandler) {
        final ListDbInstancesRequest finalRequest = (ListDbInstancesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListDbInstancesResult>(){

            @Override
            public ListDbInstancesResult call() throws Exception {
                ListDbInstancesResult result = null;
                try {
                    result = AWSTimestreamInfluxDBAsyncClient.this.executeListDbInstances(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDbParameterGroupsResult> listDbParameterGroupsAsync(ListDbParameterGroupsRequest request) {
        return this.listDbParameterGroupsAsync(request, null);
    }

    @Override
    public Future<ListDbParameterGroupsResult> listDbParameterGroupsAsync(ListDbParameterGroupsRequest request, final AsyncHandler<ListDbParameterGroupsRequest, ListDbParameterGroupsResult> asyncHandler) {
        final ListDbParameterGroupsRequest finalRequest = (ListDbParameterGroupsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListDbParameterGroupsResult>(){

            @Override
            public ListDbParameterGroupsResult call() throws Exception {
                ListDbParameterGroupsResult result = null;
                try {
                    result = AWSTimestreamInfluxDBAsyncClient.this.executeListDbParameterGroups(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSTimestreamInfluxDBAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSTimestreamInfluxDBAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSTimestreamInfluxDBAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateDbInstanceResult> updateDbInstanceAsync(UpdateDbInstanceRequest request) {
        return this.updateDbInstanceAsync(request, null);
    }

    @Override
    public Future<UpdateDbInstanceResult> updateDbInstanceAsync(UpdateDbInstanceRequest request, final AsyncHandler<UpdateDbInstanceRequest, UpdateDbInstanceResult> asyncHandler) {
        final UpdateDbInstanceRequest finalRequest = (UpdateDbInstanceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateDbInstanceResult>(){

            @Override
            public UpdateDbInstanceResult call() throws Exception {
                UpdateDbInstanceResult result = null;
                try {
                    result = AWSTimestreamInfluxDBAsyncClient.this.executeUpdateDbInstance(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

