/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.textract.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.textract.model.ExpenseCurrency;
import com.amazonaws.services.textract.model.ExpenseDetection;
import com.amazonaws.services.textract.model.ExpenseGroupProperty;
import com.amazonaws.services.textract.model.ExpenseType;
import com.amazonaws.services.textract.model.transform.ExpenseFieldMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ExpenseField
implements Serializable,
Cloneable,
StructuredPojo {
    private ExpenseType type;
    private ExpenseDetection labelDetection;
    private ExpenseDetection valueDetection;
    private Integer pageNumber;
    private ExpenseCurrency currency;
    private List<ExpenseGroupProperty> groupProperties;

    public void setType(ExpenseType type) {
        this.type = type;
    }

    public ExpenseType getType() {
        return this.type;
    }

    public ExpenseField withType(ExpenseType type) {
        this.setType(type);
        return this;
    }

    public void setLabelDetection(ExpenseDetection labelDetection) {
        this.labelDetection = labelDetection;
    }

    public ExpenseDetection getLabelDetection() {
        return this.labelDetection;
    }

    public ExpenseField withLabelDetection(ExpenseDetection labelDetection) {
        this.setLabelDetection(labelDetection);
        return this;
    }

    public void setValueDetection(ExpenseDetection valueDetection) {
        this.valueDetection = valueDetection;
    }

    public ExpenseDetection getValueDetection() {
        return this.valueDetection;
    }

    public ExpenseField withValueDetection(ExpenseDetection valueDetection) {
        this.setValueDetection(valueDetection);
        return this;
    }

    public void setPageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
    }

    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public ExpenseField withPageNumber(Integer pageNumber) {
        this.setPageNumber(pageNumber);
        return this;
    }

    public void setCurrency(ExpenseCurrency currency) {
        this.currency = currency;
    }

    public ExpenseCurrency getCurrency() {
        return this.currency;
    }

    public ExpenseField withCurrency(ExpenseCurrency currency) {
        this.setCurrency(currency);
        return this;
    }

    public List<ExpenseGroupProperty> getGroupProperties() {
        return this.groupProperties;
    }

    public void setGroupProperties(Collection<ExpenseGroupProperty> groupProperties) {
        if (groupProperties == null) {
            this.groupProperties = null;
            return;
        }
        this.groupProperties = new ArrayList<ExpenseGroupProperty>(groupProperties);
    }

    public ExpenseField withGroupProperties(ExpenseGroupProperty ... groupProperties) {
        if (this.groupProperties == null) {
            this.setGroupProperties(new ArrayList<ExpenseGroupProperty>(groupProperties.length));
        }
        for (ExpenseGroupProperty ele : groupProperties) {
            this.groupProperties.add(ele);
        }
        return this;
    }

    public ExpenseField withGroupProperties(Collection<ExpenseGroupProperty> groupProperties) {
        this.setGroupProperties(groupProperties);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getLabelDetection() != null) {
            sb.append("LabelDetection: ").append(this.getLabelDetection()).append(",");
        }
        if (this.getValueDetection() != null) {
            sb.append("ValueDetection: ").append(this.getValueDetection()).append(",");
        }
        if (this.getPageNumber() != null) {
            sb.append("PageNumber: ").append(this.getPageNumber()).append(",");
        }
        if (this.getCurrency() != null) {
            sb.append("Currency: ").append(this.getCurrency()).append(",");
        }
        if (this.getGroupProperties() != null) {
            sb.append("GroupProperties: ").append(this.getGroupProperties());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExpenseField)) {
            return false;
        }
        ExpenseField other = (ExpenseField)obj;
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getLabelDetection() == null ^ this.getLabelDetection() == null) {
            return false;
        }
        if (other.getLabelDetection() != null && !other.getLabelDetection().equals(this.getLabelDetection())) {
            return false;
        }
        if (other.getValueDetection() == null ^ this.getValueDetection() == null) {
            return false;
        }
        if (other.getValueDetection() != null && !other.getValueDetection().equals(this.getValueDetection())) {
            return false;
        }
        if (other.getPageNumber() == null ^ this.getPageNumber() == null) {
            return false;
        }
        if (other.getPageNumber() != null && !other.getPageNumber().equals(this.getPageNumber())) {
            return false;
        }
        if (other.getCurrency() == null ^ this.getCurrency() == null) {
            return false;
        }
        if (other.getCurrency() != null && !other.getCurrency().equals(this.getCurrency())) {
            return false;
        }
        if (other.getGroupProperties() == null ^ this.getGroupProperties() == null) {
            return false;
        }
        return other.getGroupProperties() == null || other.getGroupProperties().equals(this.getGroupProperties());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getLabelDetection() == null ? 0 : this.getLabelDetection().hashCode());
        hashCode = 31 * hashCode + (this.getValueDetection() == null ? 0 : this.getValueDetection().hashCode());
        hashCode = 31 * hashCode + (this.getPageNumber() == null ? 0 : this.getPageNumber().hashCode());
        hashCode = 31 * hashCode + (this.getCurrency() == null ? 0 : this.getCurrency().hashCode());
        hashCode = 31 * hashCode + (this.getGroupProperties() == null ? 0 : this.getGroupProperties().hashCode());
        return hashCode;
    }

    public ExpenseField clone() {
        try {
            return (ExpenseField)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ExpenseFieldMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

