/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.textract.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.textract.model.AutoUpdate;
import com.amazonaws.services.textract.model.FeatureType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GetAdapterResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String adapterId;
    private String adapterName;
    private Date creationTime;
    private String description;
    private List<String> featureTypes;
    private String autoUpdate;
    private Map<String, String> tags;

    public void setAdapterId(String adapterId) {
        this.adapterId = adapterId;
    }

    public String getAdapterId() {
        return this.adapterId;
    }

    public GetAdapterResult withAdapterId(String adapterId) {
        this.setAdapterId(adapterId);
        return this;
    }

    public void setAdapterName(String adapterName) {
        this.adapterName = adapterName;
    }

    public String getAdapterName() {
        return this.adapterName;
    }

    public GetAdapterResult withAdapterName(String adapterName) {
        this.setAdapterName(adapterName);
        return this;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public GetAdapterResult withCreationTime(Date creationTime) {
        this.setCreationTime(creationTime);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public GetAdapterResult withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<String> getFeatureTypes() {
        return this.featureTypes;
    }

    public void setFeatureTypes(Collection<String> featureTypes) {
        if (featureTypes == null) {
            this.featureTypes = null;
            return;
        }
        this.featureTypes = new ArrayList<String>(featureTypes);
    }

    public GetAdapterResult withFeatureTypes(String ... featureTypes) {
        if (this.featureTypes == null) {
            this.setFeatureTypes(new ArrayList<String>(featureTypes.length));
        }
        for (String ele : featureTypes) {
            this.featureTypes.add(ele);
        }
        return this;
    }

    public GetAdapterResult withFeatureTypes(Collection<String> featureTypes) {
        this.setFeatureTypes(featureTypes);
        return this;
    }

    public GetAdapterResult withFeatureTypes(FeatureType ... featureTypes) {
        ArrayList<String> featureTypesCopy = new ArrayList<String>(featureTypes.length);
        for (FeatureType value : featureTypes) {
            featureTypesCopy.add(value.toString());
        }
        if (this.getFeatureTypes() == null) {
            this.setFeatureTypes(featureTypesCopy);
        } else {
            this.getFeatureTypes().addAll(featureTypesCopy);
        }
        return this;
    }

    public void setAutoUpdate(String autoUpdate) {
        this.autoUpdate = autoUpdate;
    }

    public String getAutoUpdate() {
        return this.autoUpdate;
    }

    public GetAdapterResult withAutoUpdate(String autoUpdate) {
        this.setAutoUpdate(autoUpdate);
        return this;
    }

    public GetAdapterResult withAutoUpdate(AutoUpdate autoUpdate) {
        this.autoUpdate = autoUpdate.toString();
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public GetAdapterResult withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public GetAdapterResult addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public GetAdapterResult clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAdapterId() != null) {
            sb.append("AdapterId: ").append(this.getAdapterId()).append(",");
        }
        if (this.getAdapterName() != null) {
            sb.append("AdapterName: ").append(this.getAdapterName()).append(",");
        }
        if (this.getCreationTime() != null) {
            sb.append("CreationTime: ").append(this.getCreationTime()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getFeatureTypes() != null) {
            sb.append("FeatureTypes: ").append(this.getFeatureTypes()).append(",");
        }
        if (this.getAutoUpdate() != null) {
            sb.append("AutoUpdate: ").append(this.getAutoUpdate()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAdapterResult)) {
            return false;
        }
        GetAdapterResult other = (GetAdapterResult)obj;
        if (other.getAdapterId() == null ^ this.getAdapterId() == null) {
            return false;
        }
        if (other.getAdapterId() != null && !other.getAdapterId().equals(this.getAdapterId())) {
            return false;
        }
        if (other.getAdapterName() == null ^ this.getAdapterName() == null) {
            return false;
        }
        if (other.getAdapterName() != null && !other.getAdapterName().equals(this.getAdapterName())) {
            return false;
        }
        if (other.getCreationTime() == null ^ this.getCreationTime() == null) {
            return false;
        }
        if (other.getCreationTime() != null && !other.getCreationTime().equals(this.getCreationTime())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getFeatureTypes() == null ^ this.getFeatureTypes() == null) {
            return false;
        }
        if (other.getFeatureTypes() != null && !other.getFeatureTypes().equals(this.getFeatureTypes())) {
            return false;
        }
        if (other.getAutoUpdate() == null ^ this.getAutoUpdate() == null) {
            return false;
        }
        if (other.getAutoUpdate() != null && !other.getAutoUpdate().equals(this.getAutoUpdate())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAdapterId() == null ? 0 : this.getAdapterId().hashCode());
        hashCode = 31 * hashCode + (this.getAdapterName() == null ? 0 : this.getAdapterName().hashCode());
        hashCode = 31 * hashCode + (this.getCreationTime() == null ? 0 : this.getCreationTime().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getFeatureTypes() == null ? 0 : this.getFeatureTypes().hashCode());
        hashCode = 31 * hashCode + (this.getAutoUpdate() == null ? 0 : this.getAutoUpdate().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public GetAdapterResult clone() {
        try {
            return (GetAdapterResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

