/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.textract.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.textract.model.AutoUpdate;
import com.amazonaws.services.textract.model.FeatureType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateAdapterRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String adapterName;
    private String clientRequestToken;
    private String description;
    private List<String> featureTypes;
    private String autoUpdate;
    private Map<String, String> tags;

    public void setAdapterName(String adapterName) {
        this.adapterName = adapterName;
    }

    public String getAdapterName() {
        return this.adapterName;
    }

    public CreateAdapterRequest withAdapterName(String adapterName) {
        this.setAdapterName(adapterName);
        return this;
    }

    public void setClientRequestToken(String clientRequestToken) {
        this.clientRequestToken = clientRequestToken;
    }

    public String getClientRequestToken() {
        return this.clientRequestToken;
    }

    public CreateAdapterRequest withClientRequestToken(String clientRequestToken) {
        this.setClientRequestToken(clientRequestToken);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateAdapterRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<String> getFeatureTypes() {
        return this.featureTypes;
    }

    public void setFeatureTypes(Collection<String> featureTypes) {
        if (featureTypes == null) {
            this.featureTypes = null;
            return;
        }
        this.featureTypes = new ArrayList<String>(featureTypes);
    }

    public CreateAdapterRequest withFeatureTypes(String ... featureTypes) {
        if (this.featureTypes == null) {
            this.setFeatureTypes(new ArrayList<String>(featureTypes.length));
        }
        for (String ele : featureTypes) {
            this.featureTypes.add(ele);
        }
        return this;
    }

    public CreateAdapterRequest withFeatureTypes(Collection<String> featureTypes) {
        this.setFeatureTypes(featureTypes);
        return this;
    }

    public CreateAdapterRequest withFeatureTypes(FeatureType ... featureTypes) {
        ArrayList<String> featureTypesCopy = new ArrayList<String>(featureTypes.length);
        for (FeatureType value : featureTypes) {
            featureTypesCopy.add(value.toString());
        }
        if (this.getFeatureTypes() == null) {
            this.setFeatureTypes(featureTypesCopy);
        } else {
            this.getFeatureTypes().addAll(featureTypesCopy);
        }
        return this;
    }

    public void setAutoUpdate(String autoUpdate) {
        this.autoUpdate = autoUpdate;
    }

    public String getAutoUpdate() {
        return this.autoUpdate;
    }

    public CreateAdapterRequest withAutoUpdate(String autoUpdate) {
        this.setAutoUpdate(autoUpdate);
        return this;
    }

    public CreateAdapterRequest withAutoUpdate(AutoUpdate autoUpdate) {
        this.autoUpdate = autoUpdate.toString();
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreateAdapterRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CreateAdapterRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CreateAdapterRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAdapterName() != null) {
            sb.append("AdapterName: ").append(this.getAdapterName()).append(",");
        }
        if (this.getClientRequestToken() != null) {
            sb.append("ClientRequestToken: ").append(this.getClientRequestToken()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getFeatureTypes() != null) {
            sb.append("FeatureTypes: ").append(this.getFeatureTypes()).append(",");
        }
        if (this.getAutoUpdate() != null) {
            sb.append("AutoUpdate: ").append(this.getAutoUpdate()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAdapterRequest)) {
            return false;
        }
        CreateAdapterRequest other = (CreateAdapterRequest)obj;
        if (other.getAdapterName() == null ^ this.getAdapterName() == null) {
            return false;
        }
        if (other.getAdapterName() != null && !other.getAdapterName().equals(this.getAdapterName())) {
            return false;
        }
        if (other.getClientRequestToken() == null ^ this.getClientRequestToken() == null) {
            return false;
        }
        if (other.getClientRequestToken() != null && !other.getClientRequestToken().equals(this.getClientRequestToken())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getFeatureTypes() == null ^ this.getFeatureTypes() == null) {
            return false;
        }
        if (other.getFeatureTypes() != null && !other.getFeatureTypes().equals(this.getFeatureTypes())) {
            return false;
        }
        if (other.getAutoUpdate() == null ^ this.getAutoUpdate() == null) {
            return false;
        }
        if (other.getAutoUpdate() != null && !other.getAutoUpdate().equals(this.getAutoUpdate())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAdapterName() == null ? 0 : this.getAdapterName().hashCode());
        hashCode = 31 * hashCode + (this.getClientRequestToken() == null ? 0 : this.getClientRequestToken().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getFeatureTypes() == null ? 0 : this.getFeatureTypes().hashCode());
        hashCode = 31 * hashCode + (this.getAutoUpdate() == null ? 0 : this.getAutoUpdate().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateAdapterRequest clone() {
        return (CreateAdapterRequest)super.clone();
    }
}

