/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.textract.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.textract.model.transform.QueryMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Query
implements Serializable,
Cloneable,
StructuredPojo {
    private String text;
    private String alias;
    private List<String> pages;

    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public Query withText(String text) {
        this.setText(text);
        return this;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getAlias() {
        return this.alias;
    }

    public Query withAlias(String alias) {
        this.setAlias(alias);
        return this;
    }

    public List<String> getPages() {
        return this.pages;
    }

    public void setPages(Collection<String> pages) {
        if (pages == null) {
            this.pages = null;
            return;
        }
        this.pages = new ArrayList<String>(pages);
    }

    public Query withPages(String ... pages) {
        if (this.pages == null) {
            this.setPages(new ArrayList<String>(pages.length));
        }
        for (String ele : pages) {
            this.pages.add(ele);
        }
        return this;
    }

    public Query withPages(Collection<String> pages) {
        this.setPages(pages);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getText() != null) {
            sb.append("Text: ").append(this.getText()).append(",");
        }
        if (this.getAlias() != null) {
            sb.append("Alias: ").append(this.getAlias()).append(",");
        }
        if (this.getPages() != null) {
            sb.append("Pages: ").append(this.getPages());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Query)) {
            return false;
        }
        Query other = (Query)obj;
        if (other.getText() == null ^ this.getText() == null) {
            return false;
        }
        if (other.getText() != null && !other.getText().equals(this.getText())) {
            return false;
        }
        if (other.getAlias() == null ^ this.getAlias() == null) {
            return false;
        }
        if (other.getAlias() != null && !other.getAlias().equals(this.getAlias())) {
            return false;
        }
        if (other.getPages() == null ^ this.getPages() == null) {
            return false;
        }
        return other.getPages() == null || other.getPages().equals(this.getPages());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getText() == null ? 0 : this.getText().hashCode());
        hashCode = 31 * hashCode + (this.getAlias() == null ? 0 : this.getAlias().hashCode());
        hashCode = 31 * hashCode + (this.getPages() == null ? 0 : this.getPages().hashCode());
        return hashCode;
    }

    public Query clone() {
        try {
            return (Query)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        QueryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

