/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.smoketest;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import org.apache.commons.logging.LogFactory;

public final class ReflectionUtils {
    private static final Random RANDOM = new Random();

    public static <T> Class<T> loadClass(Class<?> base, String name) {
        return ReflectionUtils.loadClass(base.getClassLoader(), name);
    }

    public static <T> Class<T> loadClass(ClassLoader classloader, String name) {
        try {
            Class<?> loaded = classloader.loadClass(name);
            return loaded;
        }
        catch (ClassNotFoundException exception) {
            throw new IllegalStateException("Cannot find class " + name, exception);
        }
    }

    public static <T> T newInstance(Class<T> clazz, Object ... params) {
        Constructor<T> constructor = ReflectionUtils.findConstructor(clazz, params);
        try {
            return constructor.newInstance(params);
        }
        catch (InstantiationException ex) {
            throw new IllegalStateException("Could not invoke " + constructor.toGenericString(), ex);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("Could not invoke " + constructor.toGenericString(), ex);
        }
        catch (InvocationTargetException ex) {
            if (ex.getCause() instanceof RuntimeException) {
                throw (RuntimeException)ex.getCause();
            }
            throw new IllegalStateException("Unexpected checked exception thrown from " + constructor.toGenericString(), ex);
        }
    }

    private static <T> Constructor<T> findConstructor(Class<T> clazz, Object[] params) {
        for (Constructor<?> constructor : clazz.getConstructors()) {
            Class<?>[] paramTypes = constructor.getParameterTypes();
            if (!ReflectionUtils.matches(paramTypes, params)) continue;
            Constructor<?> rval = constructor;
            return rval;
        }
        throw new IllegalStateException("No appropriate constructor found for " + clazz.getCanonicalName());
    }

    private static boolean matches(Class<?>[] paramTypes, Object[] params) {
        if (paramTypes.length != params.length) {
            return false;
        }
        for (int i = 0; i < params.length; ++i) {
            if (paramTypes[i].isAssignableFrom(params[i].getClass())) continue;
            return false;
        }
        return true;
    }

    public static Object getByPath(Object target, List<String> path) {
        Object obj = target;
        for (String field : path) {
            if (obj == null) {
                return null;
            }
            obj = ReflectionUtils.evaluate(obj, ReflectionUtils.trimType(field));
        }
        return obj;
    }

    public static List<Object> getAllByPath(Object target, List<String> path) {
        LinkedList<Object> results = new LinkedList<Object>();
        ReflectionUtils.getAllByPath(target, path, 0, results);
        return results;
    }

    private static void getAllByPath(Object target, List<String> path, int depth, List<Object> results) {
        if (target == null) {
            return;
        }
        if (depth == path.size()) {
            results.add(target);
            return;
        }
        String field = ReflectionUtils.trimType(path.get(depth));
        if (field.equals("*")) {
            if (!(target instanceof Iterable)) {
                throw new IllegalStateException("Cannot evaluate '*' on object " + target);
            }
            Iterable collection = (Iterable)target;
            for (Object obj : collection) {
                ReflectionUtils.getAllByPath(obj, path, depth + 1, results);
            }
        } else {
            Object obj = ReflectionUtils.evaluate(target, field);
            ReflectionUtils.getAllByPath(obj, path, depth + 1, results);
        }
    }

    private static String trimType(String field) {
        int index = field.indexOf(58);
        if (index == -1) {
            return field;
        }
        return field.substring(0, index);
    }

    private static Object evaluate(Object target, String expression) {
        try {
            if (target instanceof List) {
                List list = (List)target;
                int index = Integer.parseInt(expression);
                if (index < 0) {
                    index += list.size();
                }
                return list.get(index);
            }
            Method getter = ReflectionUtils.findAccessor(target, expression);
            if (getter == null) {
                return null;
            }
            return getter.invoke(target, new Object[0]);
        }
        catch (IllegalAccessException exception) {
            throw new IllegalStateException("BOOM", exception);
        }
        catch (InvocationTargetException exception) {
            if (exception.getCause() instanceof RuntimeException) {
                throw (RuntimeException)exception.getCause();
            }
            throw new RuntimeException("BOOM", exception);
        }
    }

    public static void setByPath(Object target, Object value, List<String> path) {
        Object obj = target;
        Iterator<String> iter = path.iterator();
        while (iter.hasNext()) {
            String field = iter.next();
            if (iter.hasNext()) {
                obj = ReflectionUtils.digIn(obj, field);
                continue;
            }
            ReflectionUtils.setValue(obj, ReflectionUtils.trimType(field), value);
        }
    }

    private static Object digIn(Object target, String field) {
        if (target instanceof List) {
            List list = (List)target;
            return ReflectionUtils.digInList(list, field);
        }
        if (target instanceof Map) {
            Map map = (Map)target;
            return ReflectionUtils.digInMap(map, field);
        }
        return ReflectionUtils.digInObject(target, field);
    }

    private static Object digInList(List<Object> target, String field) {
        int index = field.indexOf(58);
        if (index == -1) {
            throw new IllegalStateException("Invalid path expression: cannot evaluate '" + field + "' on a List");
        }
        String offset = field.substring(0, index);
        String type = field.substring(index + 1);
        if (offset.equals("*")) {
            throw new UnsupportedOperationException("What does this even mean?");
        }
        int intOffset = Integer.parseInt(offset);
        if (intOffset < 0 && (intOffset += target.size()) < 0) {
            throw new IndexOutOfBoundsException(Integer.toString(intOffset));
        }
        if (intOffset < target.size()) {
            return target.get(intOffset);
        }
        while (intOffset > target.size()) {
            target.add(ReflectionUtils.createDefaultInstance(type));
        }
        Object result = ReflectionUtils.createDefaultInstance(type);
        target.add(result);
        return result;
    }

    private static Object digInMap(Map<String, Object> target, String field) {
        int index = field.indexOf(58);
        if (index == -1) {
            throw new IllegalStateException("Invalid path expression: cannot evaluate '" + field + "' on a List");
        }
        String member = field.substring(0, index);
        String type = field.substring(index + 1);
        Object result = target.get(member);
        if (result != null) {
            return result;
        }
        result = ReflectionUtils.createDefaultInstance(type);
        target.put(member, result);
        return result;
    }

    public static Object createDefaultInstance(String type) {
        try {
            return ReflectionUtils.class.getClassLoader().loadClass(type).newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException("BOOM", e);
        }
    }

    private static Object digInObject(Object target, String field) {
        Method getter = ReflectionUtils.findAccessor(target, field);
        if (getter == null) {
            throw new IllegalStateException("No accessor found for '" + field + "' found in class " + target.getClass().getName());
        }
        try {
            Object obj = getter.invoke(target, new Object[0]);
            if (obj == null) {
                obj = getter.getReturnType().newInstance();
                Method setter = ReflectionUtils.findMethod(target, "set" + field, obj.getClass());
                setter.invoke(target, obj);
            }
            return obj;
        }
        catch (InstantiationException exception) {
            throw new IllegalStateException("Unable to create a new instance", exception);
        }
        catch (IllegalAccessException exception) {
            throw new IllegalStateException("Unable to access getter, setter, or constructor", exception);
        }
        catch (InvocationTargetException exception) {
            if (exception.getCause() instanceof RuntimeException) {
                throw (RuntimeException)exception.getCause();
            }
            throw new IllegalStateException("Checked exception thrown from getter or setter method", exception);
        }
    }

    private static void setValue(Object target, String field, Object value) {
        if ("0".equals(field)) {
            if (!(target instanceof Collection)) {
                throw new IllegalArgumentException("Cannot evaluate '0' on object " + target);
            }
            Collection collection = (Collection)target;
            collection.add(value);
        } else {
            Method setter = ReflectionUtils.findMethod(target, "set" + field, value.getClass());
            try {
                setter.invoke(target, value);
            }
            catch (IllegalAccessException exception) {
                throw new IllegalStateException("Unable to access setter method", exception);
            }
            catch (InvocationTargetException exception) {
                if (exception.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)exception.getCause();
                }
                throw new IllegalStateException("Checked exception thrown from setter method", exception);
            }
        }
    }

    public static Method findAccessor(Object target, String propertyName) {
        propertyName = propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        try {
            return target.getClass().getMethod("get" + propertyName, new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                return target.getClass().getMethod("is" + propertyName, new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                LogFactory.getLog(ReflectionUtils.class).warn((Object)("No accessor for property '" + propertyName + "' found in class " + target.getClass().getName()));
                return null;
            }
        }
    }

    public static Method findMethod(Object target, String name, Class<?> parameterType) {
        for (Method method : target.getClass().getMethods()) {
            Class<?>[] parameters;
            if (!method.getName().equals(name) || (parameters = method.getParameterTypes()).length != 1 || !parameters[0].isAssignableFrom(parameterType)) continue;
            return method;
        }
        throw new IllegalStateException("No method '" + name + "(" + parameterType + ") on type " + target.getClass());
    }

    public static Class<?> getParameterTypes(Object target, List<String> path) {
        Object obj = target;
        Iterator<String> iter = path.iterator();
        while (iter.hasNext()) {
            String field = iter.next();
            if (iter.hasNext()) {
                obj = ReflectionUtils.digIn(obj, field);
                continue;
            }
            return ReflectionUtils.findAccessor(obj, field).getReturnType();
        }
        return null;
    }

    public static void setField(Object instance, Field field, Object arg) {
        try {
            field.set(instance, arg);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> Object getField(T instance, Field field) {
        try {
            return field.get(instance);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T newInstanceWithAllFieldsSet(Class<T> clz) {
        ArrayList emptyRandomSuppliers = new ArrayList();
        return ReflectionUtils.newInstanceWithAllFieldsSet(clz, emptyRandomSuppliers);
    }

    public static <T> T newInstanceWithAllFieldsSet(Class<T> clz, RandomSupplier<?> ... suppliers) {
        return ReflectionUtils.newInstanceWithAllFieldsSet(clz, Arrays.asList(suppliers));
    }

    public static <T> T newInstanceWithAllFieldsSet(Class<T> clz, List<RandomSupplier<?>> suppliers) {
        T instance = ReflectionUtils.newInstance(clz, new Object[0]);
        for (Field field : clz.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            Class<Object> type = field.getType();
            field.setAccessible(true);
            RandomSupplier<?> supplier = ReflectionUtils.findSupplier(suppliers, type);
            if (supplier != null) {
                ReflectionUtils.setField(instance, field, supplier.getNext());
                continue;
            }
            if (type.isAssignableFrom(Integer.TYPE) || type.isAssignableFrom(Integer.class)) {
                ReflectionUtils.setField(instance, field, Math.abs(RANDOM.nextInt()));
                continue;
            }
            if (type.isAssignableFrom(Long.TYPE) || type.isAssignableFrom(Long.class)) {
                ReflectionUtils.setField(instance, field, Math.abs(RANDOM.nextLong()));
                continue;
            }
            if (type.isAssignableFrom(Boolean.class) || type.isAssignableFrom(Boolean.TYPE)) {
                Object bool = ReflectionUtils.getField(instance, field);
                if (bool == null) {
                    ReflectionUtils.setField(instance, field, RANDOM.nextBoolean());
                    continue;
                }
                ReflectionUtils.setField(instance, field, Boolean.valueOf(bool.toString()) == false);
                continue;
            }
            if (type.isAssignableFrom(String.class)) {
                ReflectionUtils.setField(instance, field, UUID.randomUUID().toString());
                continue;
            }
            throw new RuntimeException(String.format("Could not set value for type %s no supplier available.", type));
        }
        return instance;
    }

    private static RandomSupplier<?> findSupplier(List<RandomSupplier<?>> suppliers, Class<?> type) {
        for (RandomSupplier<?> supplier : suppliers) {
            if (!type.isAssignableFrom(supplier.targetClass())) continue;
            return supplier;
        }
        return null;
    }

    private ReflectionUtils() {
    }

    public static interface RandomSupplier<T> {
        public T getNext();

        public Class<? super T> targetClass();
    }
}

