/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.worker;

import com.amazonaws.services.simpleworkflow.flow.LambdaFunctionFailedException;
import com.amazonaws.services.simpleworkflow.flow.LambdaFunctionTimedOutException;
import com.amazonaws.services.simpleworkflow.flow.ScheduleLambdaFunctionFailedException;
import com.amazonaws.services.simpleworkflow.flow.StartLambdaFunctionFailedException;
import com.amazonaws.services.simpleworkflow.flow.common.FlowHelpers;
import com.amazonaws.services.simpleworkflow.flow.core.ExternalTask;
import com.amazonaws.services.simpleworkflow.flow.core.ExternalTaskCancellationHandler;
import com.amazonaws.services.simpleworkflow.flow.core.ExternalTaskCompletionHandle;
import com.amazonaws.services.simpleworkflow.flow.core.Promise;
import com.amazonaws.services.simpleworkflow.flow.core.Settable;
import com.amazonaws.services.simpleworkflow.flow.core.Task;
import com.amazonaws.services.simpleworkflow.flow.worker.DecisionsHelper;
import com.amazonaws.services.simpleworkflow.flow.worker.LambdaFunctionClient;
import com.amazonaws.services.simpleworkflow.flow.worker.OpenRequestInfo;
import java.util.HashMap;
import java.util.Map;
import software.amazon.awssdk.services.swf.model.HistoryEvent;
import software.amazon.awssdk.services.swf.model.LambdaFunctionCompletedEventAttributes;
import software.amazon.awssdk.services.swf.model.LambdaFunctionFailedEventAttributes;
import software.amazon.awssdk.services.swf.model.LambdaFunctionStartedEventAttributes;
import software.amazon.awssdk.services.swf.model.LambdaFunctionTimedOutEventAttributes;
import software.amazon.awssdk.services.swf.model.ScheduleLambdaFunctionDecisionAttributes;
import software.amazon.awssdk.services.swf.model.ScheduleLambdaFunctionFailedEventAttributes;
import software.amazon.awssdk.services.swf.model.StartLambdaFunctionFailedEventAttributes;

public class LambdaFunctionClientImpl
implements LambdaFunctionClient {
    private final DecisionsHelper decisions;
    private final Map<String, OpenRequestInfo<String, String>> scheduledLambdas = new HashMap<String, OpenRequestInfo<String, String>>();

    public LambdaFunctionClientImpl(DecisionsHelper decisions) {
        this.decisions = decisions;
    }

    @Override
    public Promise<String> scheduleLambdaFunction(String name, String input) {
        return this.scheduleLambdaFunction(name, input, 0L);
    }

    @Override
    public Promise<String> scheduleLambdaFunction(String name, Promise<String> input) {
        return this.scheduleLambdaFunction(name, input, 0L);
    }

    @Override
    public Promise<String> scheduleLambdaFunction(final String name, final Promise<String> input, final long timeoutSeconds) {
        final Settable<String> result = new Settable<String>();
        new Task(new Promise[]{input}){

            @Override
            protected void doExecute() throws Throwable {
                result.chain(LambdaFunctionClientImpl.this.scheduleLambdaFunction(name, (String)input.get(), timeoutSeconds));
            }
        };
        return result;
    }

    @Override
    public Promise<String> scheduleLambdaFunction(String name, String input, long timeoutSeconds) {
        String functionId = this.decisions.getNextId();
        return this.scheduleLambdaFunction(name, input, timeoutSeconds, functionId);
    }

    @Override
    public Promise<String> scheduleLambdaFunction(String name, String input, long timeoutSeconds, final String functionId) {
        if (timeoutSeconds < 0L) {
            throw new IllegalArgumentException("Negative timeoutSeconds: " + timeoutSeconds);
        }
        final OpenRequestInfo context = new OpenRequestInfo(name);
        ScheduleLambdaFunctionDecisionAttributes.Builder attributesBuilder = ScheduleLambdaFunctionDecisionAttributes.builder().name(name).input(input).id(functionId);
        if (timeoutSeconds == 0L) {
            attributesBuilder.startToCloseTimeout(FlowHelpers.secondsToDuration(300L));
        } else {
            attributesBuilder.startToCloseTimeout(FlowHelpers.secondsToDuration(timeoutSeconds));
        }
        final ScheduleLambdaFunctionDecisionAttributes attributes = (ScheduleLambdaFunctionDecisionAttributes)attributesBuilder.build();
        String taskName = "functionId=" + attributes.id() + ", timeouts=" + attributes.startToCloseTimeout();
        new ExternalTask(new Promise[0]){

            @Override
            protected ExternalTaskCancellationHandler doExecute(ExternalTaskCompletionHandle handle) throws Throwable {
                LambdaFunctionClientImpl.this.decisions.scheduleLambdaFunction(attributes);
                context.setCompletionHandle(handle);
                LambdaFunctionClientImpl.this.scheduledLambdas.put(functionId, context);
                return new LambdaFunctionCancellationHandler(functionId);
            }
        }.setName(taskName);
        context.setResultDescription("createTimer " + taskName);
        return context.getResult();
    }

    void handleLambdaFunctionStarted(LambdaFunctionStartedEventAttributes attributes) {
    }

    void handleStartLambdaFunctionFailed(HistoryEvent event) {
        StartLambdaFunctionFailedEventAttributes startLambdaFunctionFailedAttributes = event.startLambdaFunctionFailedEventAttributes();
        String functionId = this.decisions.getFunctionId(startLambdaFunctionFailedAttributes);
        OpenRequestInfo<String, String> scheduled = this.scheduledLambdas.remove(functionId);
        if (this.decisions.handleStartLambdaFunctionFailed(event)) {
            String cause = startLambdaFunctionFailedAttributes.causeAsString();
            StartLambdaFunctionFailedException failure = new StartLambdaFunctionFailedException(event.eventId(), scheduled.getUserContext(), functionId, cause);
            ExternalTaskCompletionHandle completionHandle = scheduled.getCompletionHandle();
            completionHandle.fail(failure);
        }
    }

    void handleScheduleLambdaFunctionFailed(HistoryEvent event) {
        ScheduleLambdaFunctionFailedEventAttributes attributes = event.scheduleLambdaFunctionFailedEventAttributes();
        String functionId = attributes.id();
        OpenRequestInfo<String, String> scheduled = this.scheduledLambdas.remove(functionId);
        if (this.decisions.handleScheduleLambdaFunctionFailed(event)) {
            String cause = attributes.causeAsString();
            ScheduleLambdaFunctionFailedException failure = new ScheduleLambdaFunctionFailedException(event.eventId(), attributes.name(), functionId, cause);
            ExternalTaskCompletionHandle completionHandle = scheduled.getCompletionHandle();
            completionHandle.fail(failure);
        }
    }

    void handleLambdaFunctionCompleted(HistoryEvent event) {
        OpenRequestInfo<String, String> scheduled;
        LambdaFunctionCompletedEventAttributes attributes = event.lambdaFunctionCompletedEventAttributes();
        String lambdaId = this.decisions.getFunctionId(attributes);
        if (this.decisions.handleLambdaFunctionClosed(lambdaId) && (scheduled = this.scheduledLambdas.remove(lambdaId)) != null) {
            String result = attributes.result();
            scheduled.getResult().set(result);
            ExternalTaskCompletionHandle completionHandle = scheduled.getCompletionHandle();
            completionHandle.complete();
        }
    }

    void handleLambdaFunctionFailed(HistoryEvent event) {
        OpenRequestInfo<String, String> scheduled;
        LambdaFunctionFailedEventAttributes attributes = event.lambdaFunctionFailedEventAttributes();
        String functionId = this.decisions.getFunctionId(attributes);
        if (this.decisions.handleLambdaFunctionClosed(functionId) && (scheduled = this.scheduledLambdas.remove(functionId)) != null) {
            String detail = attributes.details();
            LambdaFunctionFailedException failure = new LambdaFunctionFailedException(event.eventId(), scheduled.getUserContext(), functionId, detail);
            ExternalTaskCompletionHandle completionHandle = scheduled.getCompletionHandle();
            completionHandle.fail(failure);
        }
    }

    void handleLambdaFunctionTimedOut(HistoryEvent event) {
        OpenRequestInfo<String, String> scheduled;
        LambdaFunctionTimedOutEventAttributes attributes = event.lambdaFunctionTimedOutEventAttributes();
        String functionId = this.decisions.getFunctionId(attributes);
        if (this.decisions.handleLambdaFunctionClosed(functionId) && (scheduled = this.scheduledLambdas.remove(functionId)) != null) {
            String timeoutType = attributes.timeoutTypeAsString();
            LambdaFunctionTimedOutException failure = new LambdaFunctionTimedOutException(event.eventId(), scheduled.getUserContext(), functionId, timeoutType);
            ExternalTaskCompletionHandle completionHandle = scheduled.getCompletionHandle();
            completionHandle.fail(failure);
        }
    }

    private final class LambdaFunctionCancellationHandler
    implements ExternalTaskCancellationHandler {
        private final String lambdaId;

        private LambdaFunctionCancellationHandler(String lambdaId) {
            this.lambdaId = lambdaId;
        }

        @Override
        public void handleCancellation(Throwable cause) {
        }
    }
}

