/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.worker;

import com.amazonaws.services.simpleworkflow.flow.ActivityTaskFailedException;
import com.amazonaws.services.simpleworkflow.flow.ActivityTaskTimedOutException;
import com.amazonaws.services.simpleworkflow.flow.ScheduleActivityTaskFailedException;
import com.amazonaws.services.simpleworkflow.flow.common.FlowHelpers;
import com.amazonaws.services.simpleworkflow.flow.core.ExternalTask;
import com.amazonaws.services.simpleworkflow.flow.core.ExternalTaskCancellationHandler;
import com.amazonaws.services.simpleworkflow.flow.core.ExternalTaskCompletionHandle;
import com.amazonaws.services.simpleworkflow.flow.core.Promise;
import com.amazonaws.services.simpleworkflow.flow.core.Settable;
import com.amazonaws.services.simpleworkflow.flow.core.Task;
import com.amazonaws.services.simpleworkflow.flow.generic.ExecuteActivityParameters;
import com.amazonaws.services.simpleworkflow.flow.generic.GenericActivityClient;
import com.amazonaws.services.simpleworkflow.flow.model.ActivityType;
import com.amazonaws.services.simpleworkflow.flow.worker.DecisionsHelper;
import com.amazonaws.services.simpleworkflow.flow.worker.OpenRequestInfo;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import software.amazon.awssdk.services.swf.model.ActivityTaskCanceledEventAttributes;
import software.amazon.awssdk.services.swf.model.ActivityTaskCompletedEventAttributes;
import software.amazon.awssdk.services.swf.model.ActivityTaskFailedEventAttributes;
import software.amazon.awssdk.services.swf.model.ActivityTaskStartedEventAttributes;
import software.amazon.awssdk.services.swf.model.ActivityTaskTimedOutEventAttributes;
import software.amazon.awssdk.services.swf.model.HistoryEvent;
import software.amazon.awssdk.services.swf.model.ScheduleActivityTaskDecisionAttributes;
import software.amazon.awssdk.services.swf.model.ScheduleActivityTaskFailedEventAttributes;
import software.amazon.awssdk.services.swf.model.TaskList;

class GenericActivityClientImpl
implements GenericActivityClient {
    private final DecisionsHelper decisions;
    private final Map<String, OpenRequestInfo<String, ActivityType>> scheduledActivities = new HashMap<String, OpenRequestInfo<String, ActivityType>>();

    public GenericActivityClientImpl(DecisionsHelper decisions) {
        this.decisions = decisions;
    }

    @Override
    public Promise<String> scheduleActivityTask(ExecuteActivityParameters parameters) {
        final OpenRequestInfo context = new OpenRequestInfo(parameters.getActivityType());
        ScheduleActivityTaskDecisionAttributes.Builder attributeBuilder = ScheduleActivityTaskDecisionAttributes.builder().activityType(parameters.getActivityType().toSdkType()).input(parameters.getInput()).heartbeatTimeout(FlowHelpers.secondsToDuration(parameters.getHeartbeatTimeoutSeconds())).scheduleToCloseTimeout(FlowHelpers.secondsToDuration(parameters.getScheduleToCloseTimeoutSeconds())).scheduleToStartTimeout(FlowHelpers.secondsToDuration(parameters.getScheduleToStartTimeoutSeconds())).startToCloseTimeout(FlowHelpers.secondsToDuration(parameters.getStartToCloseTimeoutSeconds())).taskPriority(FlowHelpers.taskPriorityToString(parameters.getTaskPriority())).control(parameters.getControl());
        String activityId = parameters.getActivityId();
        if (activityId == null) {
            activityId = String.valueOf(this.decisions.getNextId());
        }
        attributeBuilder.activityId(activityId);
        String taskList = parameters.getTaskList();
        if (taskList != null && !taskList.isEmpty()) {
            attributeBuilder.taskList((TaskList)TaskList.builder().name(taskList).build());
        }
        final ScheduleActivityTaskDecisionAttributes attributes = (ScheduleActivityTaskDecisionAttributes)attributeBuilder.build();
        String taskName = "activityId=" + activityId + ", activityType=" + attributes.activityType();
        new ExternalTask(new Promise[0]){

            @Override
            protected ExternalTaskCancellationHandler doExecute(ExternalTaskCompletionHandle handle) throws Throwable {
                GenericActivityClientImpl.this.decisions.scheduleActivityTask(attributes);
                context.setCompletionHandle(handle);
                GenericActivityClientImpl.this.scheduledActivities.put(attributes.activityId(), context);
                return new ActivityCancellationHandler(attributes.activityId(), handle);
            }
        }.setName(taskName);
        context.setResultDescription("scheduleActivityTask " + taskName);
        return context.getResult();
    }

    @Override
    public Promise<String> scheduleActivityTask(final String activity, final String version, final Promise<String> input) {
        final Settable<String> result = new Settable<String>();
        new Task(new Promise[]{input}){

            @Override
            protected void doExecute() throws Throwable {
                result.chain(GenericActivityClientImpl.this.scheduleActivityTask(activity, version, (String)input.get()));
            }
        };
        return result;
    }

    @Override
    public Promise<String> scheduleActivityTask(String activity, String version, String input) {
        ExecuteActivityParameters parameters = new ExecuteActivityParameters();
        parameters.setActivityType(ActivityType.builder().name(activity).version(version).build());
        parameters.setInput(input);
        return this.scheduleActivityTask(parameters);
    }

    void handleActivityTaskStarted(ActivityTaskStartedEventAttributes attributes) {
    }

    void handleActivityTaskCanceled(HistoryEvent event) {
        ActivityTaskCanceledEventAttributes attributes = event.activityTaskCanceledEventAttributes();
        String activityId = this.decisions.getActivityId(attributes);
        if (this.decisions.handleActivityTaskCanceled(event)) {
            CancellationException e = new CancellationException();
            OpenRequestInfo<String, ActivityType> scheduled = this.scheduledActivities.remove(activityId);
            if (scheduled != null) {
                ExternalTaskCompletionHandle completionHandle = scheduled.getCompletionHandle();
                completionHandle.fail(e);
            }
        }
    }

    void handleScheduleActivityTaskFailed(HistoryEvent event) {
        ScheduleActivityTaskFailedEventAttributes attributes = event.scheduleActivityTaskFailedEventAttributes();
        String activityId = attributes.activityId();
        OpenRequestInfo<String, ActivityType> scheduled = this.scheduledActivities.remove(activityId);
        if (this.decisions.handleScheduleActivityTaskFailed(event)) {
            String cause = attributes.causeAsString();
            ScheduleActivityTaskFailedException failure = new ScheduleActivityTaskFailedException(event.eventId(), ActivityType.fromSdkType(attributes.activityType()), activityId, cause);
            ExternalTaskCompletionHandle completionHandle = scheduled.getCompletionHandle();
            completionHandle.fail(failure);
        }
    }

    void handleActivityTaskCompleted(HistoryEvent event) {
        OpenRequestInfo<String, ActivityType> scheduled;
        ActivityTaskCompletedEventAttributes attributes = event.activityTaskCompletedEventAttributes();
        String activityId = this.decisions.getActivityId(attributes);
        if (this.decisions.handleActivityTaskClosed(activityId) && (scheduled = this.scheduledActivities.remove(activityId)) != null) {
            String result = attributes.result();
            scheduled.getResult().set(result);
            ExternalTaskCompletionHandle completionHandle = scheduled.getCompletionHandle();
            completionHandle.complete();
        }
    }

    void handleActivityTaskFailed(HistoryEvent event) {
        OpenRequestInfo<String, ActivityType> scheduled;
        ActivityTaskFailedEventAttributes attributes = event.activityTaskFailedEventAttributes();
        String activityId = this.decisions.getActivityId(attributes);
        if (this.decisions.handleActivityTaskClosed(activityId) && (scheduled = this.scheduledActivities.remove(activityId)) != null) {
            String reason = attributes.reason();
            String details = attributes.details();
            ActivityTaskFailedException failure = new ActivityTaskFailedException(event.eventId(), scheduled.getUserContext(), activityId, reason, details);
            ExternalTaskCompletionHandle completionHandle = scheduled.getCompletionHandle();
            completionHandle.fail(failure);
        }
    }

    void handleActivityTaskTimedOut(HistoryEvent event) {
        OpenRequestInfo<String, ActivityType> scheduled;
        ActivityTaskTimedOutEventAttributes attributes = event.activityTaskTimedOutEventAttributes();
        String activityId = this.decisions.getActivityId(attributes);
        if (this.decisions.handleActivityTaskClosed(activityId) && (scheduled = this.scheduledActivities.remove(activityId)) != null) {
            String timeoutType = attributes.timeoutTypeAsString();
            String details = attributes.details();
            ActivityTaskTimedOutException failure = new ActivityTaskTimedOutException(event.eventId(), scheduled.getUserContext(), activityId, timeoutType, details);
            ExternalTaskCompletionHandle completionHandle = scheduled.getCompletionHandle();
            completionHandle.fail(failure);
        }
    }

    private final class ActivityCancellationHandler
    implements ExternalTaskCancellationHandler {
        private final String activityId;
        private final ExternalTaskCompletionHandle handle;

        private ActivityCancellationHandler(String activityId, ExternalTaskCompletionHandle handle) {
            this.activityId = activityId;
            this.handle = handle;
        }

        @Override
        public void handleCancellation(Throwable cause) {
            GenericActivityClientImpl.this.decisions.requestCancelActivityTask(this.activityId, new Runnable(){

                @Override
                public void run() {
                    OpenRequestInfo scheduled = (OpenRequestInfo)GenericActivityClientImpl.this.scheduledActivities.remove(ActivityCancellationHandler.this.activityId);
                    if (scheduled == null) {
                        throw new IllegalArgumentException("Activity \"" + ActivityCancellationHandler.this.activityId + "\" wasn't scheduled");
                    }
                    ActivityCancellationHandler.this.handle.complete();
                }
            });
        }
    }
}

