/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.worker;

import com.amazonaws.services.simpleworkflow.flow.ChildWorkflowIdHandler;
import com.amazonaws.services.simpleworkflow.flow.WorkflowException;
import com.amazonaws.services.simpleworkflow.flow.common.FlowHelpers;
import com.amazonaws.services.simpleworkflow.flow.common.WorkflowExecutionUtils;
import com.amazonaws.services.simpleworkflow.flow.config.SimpleWorkflowClientConfig;
import com.amazonaws.services.simpleworkflow.flow.generic.ContinueAsNewWorkflowExecutionParameters;
import com.amazonaws.services.simpleworkflow.flow.monitoring.MetricName;
import com.amazonaws.services.simpleworkflow.flow.monitoring.ThreadLocalMetrics;
import com.amazonaws.services.simpleworkflow.flow.worker.ActivityDecisionStateMachine;
import com.amazonaws.services.simpleworkflow.flow.worker.ChildWorkflowDecisionStateMachine;
import com.amazonaws.services.simpleworkflow.flow.worker.CompleteWorkflowStateMachine;
import com.amazonaws.services.simpleworkflow.flow.worker.DecisionId;
import com.amazonaws.services.simpleworkflow.flow.worker.DecisionStateMachine;
import com.amazonaws.services.simpleworkflow.flow.worker.DecisionTarget;
import com.amazonaws.services.simpleworkflow.flow.worker.IncompatibleWorkflowDefinition;
import com.amazonaws.services.simpleworkflow.flow.worker.LambdaFunctionDecisionStateMachine;
import com.amazonaws.services.simpleworkflow.flow.worker.SignalDecisionStateMachine;
import com.amazonaws.services.simpleworkflow.flow.worker.TimerDecisionStateMachine;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.services.swf.model.ActivityTaskCancelRequestedEventAttributes;
import software.amazon.awssdk.services.swf.model.ActivityTaskCanceledEventAttributes;
import software.amazon.awssdk.services.swf.model.ActivityTaskCompletedEventAttributes;
import software.amazon.awssdk.services.swf.model.ActivityTaskFailedEventAttributes;
import software.amazon.awssdk.services.swf.model.ActivityTaskScheduledEventAttributes;
import software.amazon.awssdk.services.swf.model.ActivityTaskTimedOutEventAttributes;
import software.amazon.awssdk.services.swf.model.CancelTimerFailedEventAttributes;
import software.amazon.awssdk.services.swf.model.CancelWorkflowExecutionDecisionAttributes;
import software.amazon.awssdk.services.swf.model.ChildPolicy;
import software.amazon.awssdk.services.swf.model.ChildWorkflowExecutionStartedEventAttributes;
import software.amazon.awssdk.services.swf.model.CompleteWorkflowExecutionDecisionAttributes;
import software.amazon.awssdk.services.swf.model.ContinueAsNewWorkflowExecutionDecisionAttributes;
import software.amazon.awssdk.services.swf.model.Decision;
import software.amazon.awssdk.services.swf.model.DecisionTaskCompletedEventAttributes;
import software.amazon.awssdk.services.swf.model.DecisionType;
import software.amazon.awssdk.services.swf.model.FailWorkflowExecutionDecisionAttributes;
import software.amazon.awssdk.services.swf.model.HistoryEvent;
import software.amazon.awssdk.services.swf.model.LambdaFunctionCompletedEventAttributes;
import software.amazon.awssdk.services.swf.model.LambdaFunctionFailedEventAttributes;
import software.amazon.awssdk.services.swf.model.LambdaFunctionScheduledEventAttributes;
import software.amazon.awssdk.services.swf.model.LambdaFunctionTimedOutEventAttributes;
import software.amazon.awssdk.services.swf.model.PollForDecisionTaskResponse;
import software.amazon.awssdk.services.swf.model.RequestCancelActivityTaskFailedEventAttributes;
import software.amazon.awssdk.services.swf.model.RequestCancelExternalWorkflowExecutionDecisionAttributes;
import software.amazon.awssdk.services.swf.model.RequestCancelExternalWorkflowExecutionFailedEventAttributes;
import software.amazon.awssdk.services.swf.model.RequestCancelExternalWorkflowExecutionInitiatedEventAttributes;
import software.amazon.awssdk.services.swf.model.ScheduleActivityTaskDecisionAttributes;
import software.amazon.awssdk.services.swf.model.ScheduleActivityTaskFailedEventAttributes;
import software.amazon.awssdk.services.swf.model.ScheduleLambdaFunctionDecisionAttributes;
import software.amazon.awssdk.services.swf.model.ScheduleLambdaFunctionFailedEventAttributes;
import software.amazon.awssdk.services.swf.model.SignalExternalWorkflowExecutionDecisionAttributes;
import software.amazon.awssdk.services.swf.model.SignalExternalWorkflowExecutionInitiatedEventAttributes;
import software.amazon.awssdk.services.swf.model.StartChildWorkflowExecutionDecisionAttributes;
import software.amazon.awssdk.services.swf.model.StartChildWorkflowExecutionFailedEventAttributes;
import software.amazon.awssdk.services.swf.model.StartChildWorkflowExecutionInitiatedEventAttributes;
import software.amazon.awssdk.services.swf.model.StartLambdaFunctionFailedEventAttributes;
import software.amazon.awssdk.services.swf.model.StartTimerDecisionAttributes;
import software.amazon.awssdk.services.swf.model.StartTimerFailedEventAttributes;
import software.amazon.awssdk.services.swf.model.TaskList;
import software.amazon.awssdk.services.swf.model.TimerCanceledEventAttributes;
import software.amazon.awssdk.services.swf.model.TimerStartedEventAttributes;

class DecisionsHelper {
    static final int MAXIMUM_DECISIONS_PER_COMPLETION = 100;
    static final String FORCE_IMMEDIATE_DECISION_TIMER = "FORCE_IMMEDIATE_DECISION";
    private final PollForDecisionTaskResponse task;
    private final ChildWorkflowIdHandler childWorkflowIdHandler;
    private long idCounter;
    private final Map<Long, String> activitySchedulingEventIdToActivityId = new HashMap<Long, String>();
    private final Map<Long, String> signalInitiatedEventIdToSignalId = new HashMap<Long, String>();
    private final Map<Long, String> lambdaSchedulingEventIdToLambdaId = new HashMap<Long, String>();
    private final Map<String, String> childWorkflowRequestedToActualWorkflowId = new HashMap<String, String>();
    private final Map<DecisionId, DecisionStateMachine> decisions = new LinkedHashMap<DecisionId, DecisionStateMachine>(100, 0.75f, true);
    private Throwable workflowFailureCause;
    private String workflowContextData;
    private String workflowContextFromLastDecisionCompletion;
    private SimpleWorkflowClientConfig clientConfig;

    DecisionsHelper(PollForDecisionTaskResponse task, ChildWorkflowIdHandler childWorkflowIdHandler, SimpleWorkflowClientConfig clientConfig) {
        this.task = task;
        this.childWorkflowIdHandler = childWorkflowIdHandler;
        this.clientConfig = clientConfig;
    }

    void scheduleLambdaFunction(ScheduleLambdaFunctionDecisionAttributes schedule) {
        DecisionId decisionId = new DecisionId(DecisionTarget.LAMBDA_FUNCTION, schedule.id());
        this.addDecision(decisionId, new LambdaFunctionDecisionStateMachine(decisionId, schedule));
    }

    boolean requestCancelLambdaFunction(String lambdaId, Runnable immediateCancellationCallback) {
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.LAMBDA_FUNCTION, lambdaId));
        decision.cancel(immediateCancellationCallback);
        return decision.isDone();
    }

    boolean handleLambdaFunctionClosed(String lambdaId) {
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.LAMBDA_FUNCTION, lambdaId));
        decision.handleCompletionEvent();
        return decision.isDone();
    }

    boolean handleLambdaFunctionScheduled(HistoryEvent event) {
        LambdaFunctionScheduledEventAttributes attributes = event.lambdaFunctionScheduledEventAttributes();
        String functionId = attributes.id();
        this.lambdaSchedulingEventIdToLambdaId.put(event.eventId(), functionId);
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.LAMBDA_FUNCTION, functionId), event);
        decision.handleInitiatedEvent(event);
        return decision.isDone();
    }

    public boolean handleScheduleLambdaFunctionFailed(HistoryEvent event) {
        ScheduleLambdaFunctionFailedEventAttributes attributes = event.scheduleLambdaFunctionFailedEventAttributes();
        String functionId = attributes.id();
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.LAMBDA_FUNCTION, functionId), event);
        decision.handleInitiationFailedEvent(event);
        return decision.isDone();
    }

    public boolean handleStartLambdaFunctionFailed(HistoryEvent event) {
        StartLambdaFunctionFailedEventAttributes attributes = event.startLambdaFunctionFailedEventAttributes();
        String functionId = this.getFunctionId(attributes);
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.LAMBDA_FUNCTION, functionId), event);
        decision.handleInitiationFailedEvent(event);
        return decision.isDone();
    }

    void scheduleActivityTask(ScheduleActivityTaskDecisionAttributes schedule) {
        DecisionId decisionId = new DecisionId(DecisionTarget.ACTIVITY, schedule.activityId());
        this.addDecision(decisionId, new ActivityDecisionStateMachine(decisionId, schedule));
    }

    boolean requestCancelActivityTask(String activityId, Runnable immediateCancellationCallback) {
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.ACTIVITY, activityId));
        decision.cancel(immediateCancellationCallback);
        return decision.isDone();
    }

    boolean handleActivityTaskClosed(String activityId) {
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.ACTIVITY, activityId));
        decision.handleCompletionEvent();
        return decision.isDone();
    }

    boolean handleActivityTaskScheduled(HistoryEvent event) {
        ActivityTaskScheduledEventAttributes attributes = event.activityTaskScheduledEventAttributes();
        String activityId = attributes.activityId();
        this.activitySchedulingEventIdToActivityId.put(event.eventId(), activityId);
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.ACTIVITY, activityId), event);
        decision.handleInitiatedEvent(event);
        return decision.isDone();
    }

    public boolean handleScheduleActivityTaskFailed(HistoryEvent event) {
        ScheduleActivityTaskFailedEventAttributes attributes = event.scheduleActivityTaskFailedEventAttributes();
        String activityId = attributes.activityId();
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.ACTIVITY, activityId), event);
        decision.handleInitiationFailedEvent(event);
        return decision.isDone();
    }

    boolean handleActivityTaskCancelRequested(HistoryEvent event) {
        ActivityTaskCancelRequestedEventAttributes attributes = event.activityTaskCancelRequestedEventAttributes();
        String activityId = attributes.activityId();
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.ACTIVITY, activityId), event);
        decision.handleCancellationInitiatedEvent();
        return decision.isDone();
    }

    public boolean handleActivityTaskCanceled(HistoryEvent event) {
        ActivityTaskCanceledEventAttributes attributes = event.activityTaskCanceledEventAttributes();
        String activityId = this.getActivityId(attributes);
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.ACTIVITY, activityId), event);
        decision.handleCancellationEvent();
        return decision.isDone();
    }

    boolean handleRequestCancelActivityTaskFailed(HistoryEvent event) {
        RequestCancelActivityTaskFailedEventAttributes attributes = event.requestCancelActivityTaskFailedEventAttributes();
        String activityId = attributes.activityId();
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.ACTIVITY, activityId), event);
        decision.handleCancellationFailureEvent(event);
        return decision.isDone();
    }

    void startChildWorkflowExecution(StartChildWorkflowExecutionDecisionAttributes schedule) {
        DecisionId decisionId = new DecisionId(DecisionTarget.EXTERNAL_WORKFLOW, schedule.workflowId());
        this.addDecision(decisionId, new ChildWorkflowDecisionStateMachine(decisionId, schedule, this.clientConfig));
    }

    void handleStartChildWorkflowExecutionInitiated(HistoryEvent event) {
        StartChildWorkflowExecutionInitiatedEventAttributes attributes = event.startChildWorkflowExecutionInitiatedEventAttributes();
        String actualWorkflowId = attributes.workflowId();
        String requestedWorkflowId = this.childWorkflowIdHandler.extractRequestedWorkflowId(actualWorkflowId);
        DecisionId originalDecisionId = new DecisionId(DecisionTarget.EXTERNAL_WORKFLOW, requestedWorkflowId);
        DecisionStateMachine decision = this.getDecision(originalDecisionId, event);
        if (!actualWorkflowId.equals(requestedWorkflowId)) {
            this.childWorkflowRequestedToActualWorkflowId.put(requestedWorkflowId, actualWorkflowId);
            this.decisions.remove(originalDecisionId);
            this.addDecision(new DecisionId(DecisionTarget.EXTERNAL_WORKFLOW, actualWorkflowId), decision);
        }
        decision.handleInitiatedEvent(event);
    }

    public boolean handleStartChildWorkflowExecutionFailed(HistoryEvent event) {
        DecisionStateMachine decision;
        String requestedWorkflowId;
        StartChildWorkflowExecutionFailedEventAttributes attributes = event.startChildWorkflowExecutionFailedEventAttributes();
        String actualWorkflowId = attributes.workflowId();
        if (!actualWorkflowId.equals(requestedWorkflowId = this.childWorkflowIdHandler.extractRequestedWorkflowId(actualWorkflowId))) {
            this.childWorkflowRequestedToActualWorkflowId.put(requestedWorkflowId, actualWorkflowId);
            DecisionId originalDecisionId = new DecisionId(DecisionTarget.EXTERNAL_WORKFLOW, requestedWorkflowId);
            if (this.decisions.containsKey(originalDecisionId)) {
                decision = this.decisions.remove(originalDecisionId);
                this.addDecision(new DecisionId(DecisionTarget.EXTERNAL_WORKFLOW, actualWorkflowId), decision);
            } else {
                decision = this.getDecision(new DecisionId(DecisionTarget.EXTERNAL_WORKFLOW, actualWorkflowId), event);
            }
        } else {
            decision = this.getDecision(new DecisionId(DecisionTarget.EXTERNAL_WORKFLOW, actualWorkflowId), event);
        }
        decision.handleInitiationFailedEvent(event);
        return decision.isDone();
    }

    public void handleChildWorkflowExecutionStarted(HistoryEvent event) {
        ChildWorkflowExecutionStartedEventAttributes attributes = event.childWorkflowExecutionStartedEventAttributes();
        String workflowId = attributes.workflowExecution().workflowId();
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.EXTERNAL_WORKFLOW, workflowId), event);
        decision.handleStartedEvent(event);
    }

    boolean handleChildWorkflowExecutionClosed(String workflowId) {
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.EXTERNAL_WORKFLOW, workflowId));
        decision.handleCompletionEvent();
        return decision.isDone();
    }

    public void handleChildWorkflowExecutionCancelRequested(HistoryEvent event) {
    }

    public boolean handleChildWorkflowExecutionCanceled(String workflowId) {
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.EXTERNAL_WORKFLOW, workflowId));
        decision.handleCancellationEvent();
        return decision.isDone();
    }

    boolean requestCancelExternalWorkflowExecution(RequestCancelExternalWorkflowExecutionDecisionAttributes request, Runnable immediateCancellationCallback) {
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.EXTERNAL_WORKFLOW, request.workflowId()));
        decision.cancel(immediateCancellationCallback);
        return decision.isDone();
    }

    void handleRequestCancelExternalWorkflowExecutionInitiated(HistoryEvent event) {
        RequestCancelExternalWorkflowExecutionInitiatedEventAttributes attributes = event.requestCancelExternalWorkflowExecutionInitiatedEventAttributes();
        String workflowId = attributes.workflowId();
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.EXTERNAL_WORKFLOW, workflowId), event);
        decision.handleCancellationInitiatedEvent();
    }

    void handleRequestCancelExternalWorkflowExecutionFailed(HistoryEvent event) {
        RequestCancelExternalWorkflowExecutionFailedEventAttributes attributes = event.requestCancelExternalWorkflowExecutionFailedEventAttributes();
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.EXTERNAL_WORKFLOW, attributes.workflowId()), event);
        decision.handleCancellationFailureEvent(event);
    }

    void signalExternalWorkflowExecution(SignalExternalWorkflowExecutionDecisionAttributes signal) {
        DecisionId decisionId = new DecisionId(DecisionTarget.SIGNAL, signal.control());
        this.addDecision(decisionId, new SignalDecisionStateMachine(decisionId, signal));
    }

    void cancelSignalExternalWorkflowExecution(String signalId, Runnable immediateCancellationCallback) {
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.SIGNAL, signalId));
        decision.cancel(immediateCancellationCallback);
    }

    void handleSignalExternalWorkflowExecutionInitiated(HistoryEvent event) {
        SignalExternalWorkflowExecutionInitiatedEventAttributes attributes = event.signalExternalWorkflowExecutionInitiatedEventAttributes();
        String signalId = attributes.control();
        this.signalInitiatedEventIdToSignalId.put(event.eventId(), signalId);
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.SIGNAL, signalId), event);
        decision.handleInitiatedEvent(event);
    }

    public boolean handleSignalExternalWorkflowExecutionFailed(String signalId) {
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.SIGNAL, signalId));
        decision.handleCompletionEvent();
        return decision.isDone();
    }

    public boolean handleExternalWorkflowExecutionSignaled(String signalId) {
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.SIGNAL, signalId));
        decision.handleCompletionEvent();
        return decision.isDone();
    }

    void startTimer(StartTimerDecisionAttributes request, Object createTimerUserContext) {
        String timerId = request.timerId();
        DecisionId decisionId = new DecisionId(DecisionTarget.TIMER, timerId);
        this.addDecision(decisionId, new TimerDecisionStateMachine(decisionId, request));
    }

    boolean cancelTimer(String timerId, Runnable immediateCancellationCallback) {
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.TIMER, timerId));
        decision.cancel(immediateCancellationCallback);
        return decision.isDone();
    }

    boolean handleTimerClosed(String timerId) {
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.TIMER, timerId));
        decision.handleCompletionEvent();
        return decision.isDone();
    }

    boolean handleTimerStarted(HistoryEvent event) {
        TimerStartedEventAttributes attributes = event.timerStartedEventAttributes();
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.TIMER, attributes.timerId()), event);
        decision.handleInitiatedEvent(event);
        return decision.isDone();
    }

    public boolean handleStartTimerFailed(HistoryEvent event) {
        StartTimerFailedEventAttributes attributes = event.startTimerFailedEventAttributes();
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.TIMER, attributes.timerId()), event);
        decision.handleInitiationFailedEvent(event);
        return decision.isDone();
    }

    boolean handleTimerCanceled(HistoryEvent event) {
        TimerCanceledEventAttributes attributes = event.timerCanceledEventAttributes();
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.TIMER, attributes.timerId()), event);
        decision.handleCancellationEvent();
        return decision.isDone();
    }

    boolean handleCancelTimerFailed(HistoryEvent event) {
        CancelTimerFailedEventAttributes attributes = event.cancelTimerFailedEventAttributes();
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.TIMER, attributes.timerId()), event);
        decision.handleCancellationFailureEvent(event);
        return decision.isDone();
    }

    void completeWorkflowExecution(String output) {
        Decision.Builder decisionBuilder = Decision.builder();
        decisionBuilder.decisionType(DecisionType.COMPLETE_WORKFLOW_EXECUTION);
        CompleteWorkflowExecutionDecisionAttributes complete = (CompleteWorkflowExecutionDecisionAttributes)CompleteWorkflowExecutionDecisionAttributes.builder().result(output).build();
        decisionBuilder.completeWorkflowExecutionDecisionAttributes(complete);
        Decision decision = (Decision)decisionBuilder.build();
        DecisionId decisionId = new DecisionId(DecisionTarget.SELF, null);
        this.addDecision(decisionId, new CompleteWorkflowStateMachine(decisionId, decision));
    }

    void continueAsNewWorkflowExecution(ContinueAsNewWorkflowExecutionParameters continueParameters) {
        String taskList;
        ContinueAsNewWorkflowExecutionDecisionAttributes.Builder attributeBuilder = ContinueAsNewWorkflowExecutionDecisionAttributes.builder();
        attributeBuilder.workflowTypeVersion(continueParameters.getWorkflowTypeVersion());
        ChildPolicy childPolicy = continueParameters.getChildPolicy();
        if (childPolicy != null) {
            attributeBuilder.childPolicy(childPolicy);
        }
        attributeBuilder.input(continueParameters.getInput());
        attributeBuilder.executionStartToCloseTimeout(FlowHelpers.secondsToDuration(continueParameters.getExecutionStartToCloseTimeoutSeconds()));
        attributeBuilder.taskStartToCloseTimeout(FlowHelpers.secondsToDuration(continueParameters.getTaskStartToCloseTimeoutSeconds()));
        attributeBuilder.taskPriority(FlowHelpers.taskPriorityToString(continueParameters.getTaskPriority()));
        List<String> tagList = continueParameters.getTagList();
        if (tagList != null) {
            attributeBuilder.tagList(tagList);
        }
        if ((taskList = continueParameters.getTaskList()) != null && !taskList.isEmpty()) {
            attributeBuilder.taskList((TaskList)TaskList.builder().name(taskList).build());
        }
        attributeBuilder.lambdaRole(continueParameters.getLambdaRole());
        Decision decision = (Decision)Decision.builder().decisionType(DecisionType.CONTINUE_AS_NEW_WORKFLOW_EXECUTION).continueAsNewWorkflowExecutionDecisionAttributes((ContinueAsNewWorkflowExecutionDecisionAttributes)attributeBuilder.build()).build();
        DecisionId decisionId = new DecisionId(DecisionTarget.SELF, null);
        this.addDecision(decisionId, new CompleteWorkflowStateMachine(decisionId, decision));
    }

    void failWorkflowExecution(Throwable e) {
        FailWorkflowExecutionDecisionAttributes fail = this.createFailWorkflowInstanceAttributes(e);
        Decision decision = (Decision)Decision.builder().failWorkflowExecutionDecisionAttributes(fail).decisionType(DecisionType.FAIL_WORKFLOW_EXECUTION).build();
        DecisionId decisionId = new DecisionId(DecisionTarget.SELF, null);
        this.addDecision(decisionId, new CompleteWorkflowStateMachine(decisionId, decision));
        this.workflowFailureCause = e;
    }

    void failWorkflowDueToUnexpectedError(Throwable e) {
        this.decisions.clear();
        this.failWorkflowExecution(e);
        ThreadLocalMetrics.getMetrics().recordCount(MetricName.FAIL_WORKFLOW_UNEXPECTED_ERROR.getName(), 1.0);
    }

    void handleCompleteWorkflowExecutionFailed(HistoryEvent event) {
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.SELF, null), event);
        decision.handleInitiationFailedEvent(event);
    }

    void handleFailWorkflowExecutionFailed(HistoryEvent event) {
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.SELF, null), event);
        decision.handleInitiationFailedEvent(event);
    }

    void handleCancelWorkflowExecutionFailed(HistoryEvent event) {
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.SELF, null), event);
        decision.handleInitiationFailedEvent(event);
    }

    void handleContinueAsNewWorkflowExecutionFailed(HistoryEvent event) {
        DecisionStateMachine decision = this.getDecision(new DecisionId(DecisionTarget.SELF, null), event);
        decision.handleInitiationFailedEvent(event);
    }

    void cancelWorkflowExecution() {
        CancelWorkflowExecutionDecisionAttributes cancel = (CancelWorkflowExecutionDecisionAttributes)CancelWorkflowExecutionDecisionAttributes.builder().details(null).build();
        Decision decision = (Decision)Decision.builder().cancelWorkflowExecutionDecisionAttributes(cancel).decisionType(DecisionType.CANCEL_WORKFLOW_EXECUTION).build();
        DecisionId decisionId = new DecisionId(DecisionTarget.SELF, null);
        this.addDecision(decisionId, new CompleteWorkflowStateMachine(decisionId, decision));
    }

    List<Decision> getDecisions() {
        List<Object> result = new ArrayList<Decision>(101);
        for (DecisionStateMachine decisionStateMachine : this.decisions.values()) {
            Decision decision = decisionStateMachine.getDecision();
            if (decision == null) continue;
            result.add(decision);
            decisionStateMachine.throttleDecision();
        }
        int size = result.size();
        if (size > 100 && !this.isCompletionEvent((Decision)result.get(98))) {
            ThreadLocalMetrics.getMetrics().recordCount(MetricName.DECISION_LIST_TRUNCATED.getName(), 1.0);
            result = result.subList(0, 99);
            StartTimerDecisionAttributes attributes = (StartTimerDecisionAttributes)StartTimerDecisionAttributes.builder().startToFireTimeout("0").timerId(FORCE_IMMEDIATE_DECISION_TIMER).build();
            Decision d = (Decision)Decision.builder().startTimerDecisionAttributes(attributes).decisionType(DecisionType.START_TIMER).build();
            result.add(d);
        }
        return result;
    }

    private boolean isCompletionEvent(Decision decision) {
        DecisionType type = DecisionType.fromValue((String)decision.decisionTypeAsString());
        switch (type) {
            case CANCEL_WORKFLOW_EXECUTION: 
            case COMPLETE_WORKFLOW_EXECUTION: 
            case FAIL_WORKFLOW_EXECUTION: 
            case CONTINUE_AS_NEW_WORKFLOW_EXECUTION: {
                return true;
            }
        }
        return false;
    }

    public void handleDecisionTaskStartedEvent() {
        int count = 0;
        Iterator<DecisionStateMachine> iterator = this.decisions.values().iterator();
        DecisionStateMachine next = null;
        DecisionStateMachine decisionStateMachine = this.getNextDecision(iterator);
        while (decisionStateMachine != null) {
            next = this.getNextDecision(iterator);
            if (++count == 100 && next != null && !this.isCompletionEvent(next.getDecision())) break;
            decisionStateMachine.handleDecisionTaskStartedEvent();
            decisionStateMachine = next;
        }
        if (next != null && count < 100) {
            next.handleDecisionTaskStartedEvent();
        }
    }

    private DecisionStateMachine getNextDecision(Iterator<DecisionStateMachine> iterator) {
        DecisionStateMachine result = null;
        while (result == null && iterator.hasNext()) {
            result = iterator.next();
            if (result.getDecision() != null) continue;
            result = null;
        }
        return result;
    }

    public String toString() {
        return WorkflowExecutionUtils.prettyPrintDecisions(this.getDecisions());
    }

    boolean isWorkflowFailed() {
        return this.workflowFailureCause != null;
    }

    public Throwable getWorkflowFailureCause() {
        return this.workflowFailureCause;
    }

    String getWorkflowContextData() {
        return this.workflowContextData;
    }

    void setWorkflowContextData(String workflowState) {
        this.workflowContextData = workflowState;
    }

    String getWorkflowContextDataToReturn() {
        if (this.workflowContextFromLastDecisionCompletion == null || !this.workflowContextFromLastDecisionCompletion.equals(this.workflowContextData)) {
            return this.workflowContextData;
        }
        return null;
    }

    void handleDecisionCompletion(DecisionTaskCompletedEventAttributes decisionTaskCompletedEventAttributes) {
        this.workflowContextFromLastDecisionCompletion = decisionTaskCompletedEventAttributes.executionContext();
    }

    PollForDecisionTaskResponse getTask() {
        return this.task;
    }

    String getActualChildWorkflowId(String requestedWorkflowId) {
        String result = this.childWorkflowRequestedToActualWorkflowId.get(requestedWorkflowId);
        return result == null ? requestedWorkflowId : result;
    }

    String getActivityId(ActivityTaskCanceledEventAttributes attributes) {
        Long sourceId = attributes.scheduledEventId();
        return this.activitySchedulingEventIdToActivityId.get(sourceId);
    }

    String getActivityId(ActivityTaskCompletedEventAttributes attributes) {
        Long sourceId = attributes.scheduledEventId();
        return this.activitySchedulingEventIdToActivityId.get(sourceId);
    }

    String getActivityId(ActivityTaskFailedEventAttributes attributes) {
        Long sourceId = attributes.scheduledEventId();
        return this.activitySchedulingEventIdToActivityId.get(sourceId);
    }

    String getActivityId(ActivityTaskTimedOutEventAttributes attributes) {
        Long sourceId = attributes.scheduledEventId();
        return this.activitySchedulingEventIdToActivityId.get(sourceId);
    }

    String getFunctionId(LambdaFunctionCompletedEventAttributes attributes) {
        Long sourceId = attributes.scheduledEventId();
        return this.lambdaSchedulingEventIdToLambdaId.get(sourceId);
    }

    String getFunctionId(LambdaFunctionFailedEventAttributes attributes) {
        Long sourceId = attributes.scheduledEventId();
        return this.lambdaSchedulingEventIdToLambdaId.get(sourceId);
    }

    String getFunctionId(LambdaFunctionTimedOutEventAttributes attributes) {
        Long sourceId = attributes.scheduledEventId();
        return this.lambdaSchedulingEventIdToLambdaId.get(sourceId);
    }

    String getFunctionId(StartLambdaFunctionFailedEventAttributes attributes) {
        Long sourceId = attributes.scheduledEventId();
        return this.lambdaSchedulingEventIdToLambdaId.get(sourceId);
    }

    String getSignalIdFromExternalWorkflowExecutionSignaled(long initiatedEventId) {
        return this.signalInitiatedEventIdToSignalId.get(initiatedEventId);
    }

    private FailWorkflowExecutionDecisionAttributes createFailWorkflowInstanceAttributes(Throwable failure) {
        String details;
        String reason;
        if (failure instanceof WorkflowException) {
            WorkflowException f = (WorkflowException)failure;
            reason = f.getReason();
            details = f.getDetails();
        } else {
            reason = failure.getMessage();
            StringWriter sw = new StringWriter();
            failure.printStackTrace(new PrintWriter(sw));
            details = sw.toString();
        }
        return (FailWorkflowExecutionDecisionAttributes)FailWorkflowExecutionDecisionAttributes.builder().reason(WorkflowExecutionUtils.truncateReason(reason)).details(WorkflowExecutionUtils.truncateDetails(details)).build();
    }

    void addDecision(DecisionId decisionId, DecisionStateMachine decision) {
        this.decisions.put(decisionId, decision);
    }

    private DecisionStateMachine getDecision(DecisionId decisionId) {
        return this.getDecision(decisionId, null);
    }

    private DecisionStateMachine getDecision(DecisionId decisionId, HistoryEvent event) {
        DecisionStateMachine result = this.decisions.get(decisionId);
        if (result == null) {
            throw new IncompatibleWorkflowDefinition("Unknown " + decisionId + ". The possible causes are nondeterministic workflow definition code or incompatible change in the workflow definition. " + (event != null ? "HistoryEvent: " + event.toString() + ". " : "") + "Keys in the decisions map: " + this.decisions.keySet());
        }
        return result;
    }

    public ChildWorkflowIdHandler getChildWorkflowIdHandler() {
        return this.childWorkflowIdHandler;
    }

    public String getNextId() {
        return String.valueOf(++this.idCounter);
    }
}

