/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.worker;

import com.amazonaws.services.simpleworkflow.flow.common.RequestTimeoutHelper;
import com.amazonaws.services.simpleworkflow.flow.common.WorkflowExecutionUtils;
import com.amazonaws.services.simpleworkflow.flow.config.SimpleWorkflowClientConfig;
import com.amazonaws.services.simpleworkflow.flow.model.WorkflowExecution;
import com.amazonaws.services.simpleworkflow.flow.model.WorkflowExecutionMetadata;
import com.amazonaws.services.simpleworkflow.flow.model.WorkflowType;
import com.amazonaws.services.simpleworkflow.flow.monitoring.MetricHelper;
import com.amazonaws.services.simpleworkflow.flow.monitoring.MetricName;
import com.amazonaws.services.simpleworkflow.flow.monitoring.Metrics;
import com.amazonaws.services.simpleworkflow.flow.monitoring.MetricsRegistry;
import com.amazonaws.services.simpleworkflow.flow.monitoring.NullMetricsRegistry;
import com.amazonaws.services.simpleworkflow.flow.monitoring.ThreadLocalMetrics;
import com.amazonaws.services.simpleworkflow.flow.worker.AsyncDecider;
import com.amazonaws.services.simpleworkflow.flow.worker.DecisionTaskHandler;
import com.amazonaws.services.simpleworkflow.flow.worker.HandleDecisionTaskResults;
import com.amazonaws.services.simpleworkflow.flow.worker.SuspendableSemaphore;
import com.amazonaws.services.simpleworkflow.flow.worker.TaskPoller;
import com.amazonaws.services.simpleworkflow.flow.worker.WorkflowHistoryDecisionTaskIterator;
import java.lang.management.ManagementFactory;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.services.swf.SwfClient;
import software.amazon.awssdk.services.swf.model.EventType;
import software.amazon.awssdk.services.swf.model.HistoryEvent;
import software.amazon.awssdk.services.swf.model.PollForDecisionTaskRequest;
import software.amazon.awssdk.services.swf.model.PollForDecisionTaskResponse;
import software.amazon.awssdk.services.swf.model.RespondDecisionTaskCompletedRequest;
import software.amazon.awssdk.services.swf.model.TaskList;

public class DecisionTaskPoller
implements TaskPoller<DecisionTaskIterator> {
    private static final Log log = LogFactory.getLog(DecisionTaskPoller.class);
    private static final Log decisionsLog = LogFactory.getLog((String)(DecisionTaskPoller.class.getName() + ".decisions"));
    private SwfClient service;
    private String domain;
    private String taskListToPoll;
    private String identity;
    private boolean validated;
    private DecisionTaskHandler decisionTaskHandler;
    private boolean suspended;
    private boolean shutdownRequested;
    private final Lock lock = new ReentrantLock();
    private final Condition suspentionCondition = this.lock.newCondition();
    private SimpleWorkflowClientConfig config;
    private MetricsRegistry metricsRegistry;

    public DecisionTaskPoller() {
        this.identity = ManagementFactory.getRuntimeMXBean().getName();
        this.metricsRegistry = new NullMetricsRegistry();
    }

    public DecisionTaskPoller(SwfClient service, String domain, String taskListToPoll, DecisionTaskHandler decisionTaskHandler) {
        this(service, domain, taskListToPoll, decisionTaskHandler, null);
    }

    public DecisionTaskPoller(SwfClient service, String domain, String taskListToPoll, DecisionTaskHandler decisionTaskHandler, SimpleWorkflowClientConfig config) {
        this();
        this.service = service;
        this.domain = domain;
        this.taskListToPoll = taskListToPoll;
        this.decisionTaskHandler = decisionTaskHandler;
        this.config = config;
    }

    public void setIdentity(String identity) {
        this.validated = false;
        this.identity = identity;
    }

    public void setDecisionTaskHandler(DecisionTaskHandler decisionTaskHandler) {
        this.validated = false;
        this.decisionTaskHandler = decisionTaskHandler;
    }

    public void setService(SwfClient service) {
        this.validated = false;
        this.service = service;
    }

    private PollForDecisionTaskResponse poll(String nextResultToken) {
        this.validate();
        PollForDecisionTaskRequest.Builder pollRequestBuilder = PollForDecisionTaskRequest.builder().domain(this.domain).identity(this.identity).nextPageToken(nextResultToken);
        pollRequestBuilder.taskList((TaskList)TaskList.builder().name(this.taskListToPoll).build());
        if (this.decisionTaskHandler.getAffinityHelper() != null) {
            pollRequestBuilder.startAtPreviousStartedEvent(Boolean.valueOf(this.decisionTaskHandler.getAffinityHelper().isAffinityWorker()));
        }
        PollForDecisionTaskRequest pollRequest = (PollForDecisionTaskRequest)pollRequestBuilder.build();
        if (log.isDebugEnabled()) {
            log.debug((Object)("poll request begin: " + pollRequest));
        }
        pollRequest = RequestTimeoutHelper.overridePollRequestTimeout(pollRequest, this.config);
        PollForDecisionTaskResponse result = this.service.pollForDecisionTask(pollRequest);
        if (log.isDebugEnabled() && result != null) {
            log.debug((Object)("poll request returned decision task: workflowType=" + result.workflowType() + ", workflowExecution=" + result.workflowExecution() + ", startedEventId=" + result.startedEventId() + ", previousStartedEventId=" + result.previousStartedEventId()));
        }
        if (result == null || result.taskToken() == null) {
            result = null;
        }
        return result;
    }

    @Override
    public DecisionTaskIterator poll() throws InterruptedException {
        this.waitIfSuspended();
        DecisionTaskIterator tasks = new DecisionTaskIterator(this.metricsRegistry.newMetrics(MetricName.Operation.DECISION_TASK_POLL.getName()));
        if (!tasks.hasNext()) {
            return null;
        }
        return tasks;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void execute(DecisionTaskIterator tasks) throws Exception {
        boolean decisionSubmitted;
        PollForDecisionTaskResponse firstTask;
        Metrics metrics;
        RespondDecisionTaskCompletedRequest taskCompletedRequest;
        block18: {
            taskCompletedRequest = null;
            metrics = this.metricsRegistry.newMetrics(MetricName.Operation.EXECUTE_DECISION_TASK.getName());
            firstTask = tasks.getFirstDecisionTask();
            ThreadLocalMetrics.setCurrent(metrics);
            MetricHelper.recordMetrics(firstTask, metrics);
            decisionSubmitted = false;
            boolean establishAffinity = this.shouldEstablishAffinity(firstTask);
            try {
                HandleDecisionTaskResults handleDecisionTaskResults = this.decisionTaskHandler.handleDecisionTask(tasks);
                taskCompletedRequest = handleDecisionTaskResults.getRespondDecisionTaskCompletedRequest();
                if (decisionsLog.isTraceEnabled()) {
                    decisionsLog.trace((Object)WorkflowExecutionUtils.prettyPrintDecisions(taskCompletedRequest.decisions()));
                }
                taskCompletedRequest = RequestTimeoutHelper.overrideDataPlaneRequestTimeout(taskCompletedRequest, this.config);
                RespondDecisionTaskCompletedRequest.Builder taskCompletedRequestBuilder = taskCompletedRequest.toBuilder();
                if (establishAffinity) {
                    if (!this.shutdownRequested) {
                        taskCompletedRequestBuilder.taskList((TaskList)TaskList.builder().name(this.decisionTaskHandler.getAffinityHelper().getAffinityTaskList()).build());
                        taskCompletedRequestBuilder.taskListScheduleToStartTimeout(String.valueOf(this.config.getDeciderAffinityConfig().getAffinityTaskListScheduleToStartTimeout().getSeconds()));
                        AsyncDecider decider = handleDecisionTaskResults.getAsyncDecider();
                        if (decider.hasCompletedWithoutUnhandledDecision()) {
                            this.config.getDeciderAffinityConfig().getDeciderCache().remove((Object)WorkflowExecution.fromSdkType(firstTask.workflowExecution()));
                        } else {
                            decider.getHistoryHelper().clearHistoryEvents();
                            this.config.getDeciderAffinityConfig().getDeciderCache().put((Object)WorkflowExecution.fromSdkType(firstTask.workflowExecution()), (Object)decider);
                        }
                    } else {
                        taskCompletedRequestBuilder.taskList((TaskList)TaskList.builder().name(handleDecisionTaskResults.getAsyncDecider().getOriginalTaskList()).build());
                    }
                }
                RespondDecisionTaskCompletedRequest request = taskCompletedRequest = (RespondDecisionTaskCompletedRequest)taskCompletedRequestBuilder.build();
                metrics.recordRunnable(() -> this.service.respondDecisionTaskCompleted(request), MetricName.Operation.RESPOND_DECISION_TASK_COMPLETED.getName(), TimeUnit.MILLISECONDS);
                decisionSubmitted = true;
                this.forceFetchFullHistoryIfNeeded(establishAffinity, firstTask, metrics);
                if (!establishAffinity || decisionSubmitted) break block18;
            }
            catch (Error e) {
                try {
                    if (!log.isWarnEnabled()) throw e;
                    log.warn((Object)("DecisionTask failure: taskId= " + firstTask.startedEventId() + ", workflowExecution=" + firstTask.workflowExecution()), (Throwable)e);
                    throw e;
                    catch (Exception e2) {
                        if (log.isWarnEnabled()) {
                            log.warn((Object)("DecisionTask failure: taskId= " + firstTask.startedEventId() + ", workflowExecution=" + firstTask.workflowExecution()), (Throwable)e2);
                        }
                        if (log.isDebugEnabled() && firstTask.events() != null) {
                            log.debug((Object)("Failed taskId=" + firstTask.startedEventId() + " history: " + WorkflowExecutionUtils.prettyPrintHistory(firstTask.events(), true)));
                        }
                        if (taskCompletedRequest != null && decisionsLog.isWarnEnabled()) {
                            decisionsLog.warn((Object)("Failed taskId=" + firstTask.startedEventId() + " decisions=" + WorkflowExecutionUtils.prettyPrintDecisions(taskCompletedRequest.decisions())));
                        }
                        if (!(e2 instanceof SdkClientException)) throw e2;
                        if (!RequestTimeoutHelper.BROKEN_PIPE_ERROR_PREDICATE.test((SdkClientException)((Object)e2))) throw e2;
                        log.error((Object)"Unable to submit Decisions because request may have exceeded allowed maximum request size");
                        metrics.recordCount(MetricName.REQUEST_SIZE_MAY_BE_EXCEEDED.getName(), 1.0);
                        throw e2;
                    }
                }
                catch (Throwable throwable) {
                    if (establishAffinity && !decisionSubmitted) {
                        this.config.getDeciderAffinityConfig().getDeciderCache().remove((Object)WorkflowExecution.fromSdkType(firstTask.workflowExecution()));
                    }
                    if (taskCompletedRequest != null && taskCompletedRequest.decisions() != null) {
                        ThreadLocalMetrics.getMetrics().recordCount(MetricName.DECISION_COUNT.getName(), taskCompletedRequest.decisions().size(), MetricName.getResultDimension(decisionSubmitted));
                    }
                    metrics.recordCount(MetricName.DROPPED_TASK.getName(), !decisionSubmitted, MetricName.getWorkflowTypeDimension(WorkflowType.fromSdkType(firstTask.workflowType())));
                    metrics.close();
                    ThreadLocalMetrics.clearCurrent();
                    throw throwable;
                }
            }
            this.config.getDeciderAffinityConfig().getDeciderCache().remove((Object)WorkflowExecution.fromSdkType(firstTask.workflowExecution()));
        }
        if (taskCompletedRequest != null && taskCompletedRequest.decisions() != null) {
            ThreadLocalMetrics.getMetrics().recordCount(MetricName.DECISION_COUNT.getName(), taskCompletedRequest.decisions().size(), MetricName.getResultDimension(decisionSubmitted));
        }
        metrics.recordCount(MetricName.DROPPED_TASK.getName(), !decisionSubmitted, MetricName.getWorkflowTypeDimension(WorkflowType.fromSdkType(firstTask.workflowType())));
        metrics.close();
        ThreadLocalMetrics.clearCurrent();
    }

    private boolean shouldEstablishAffinity(PollForDecisionTaskResponse decisionTask) {
        boolean deciderAffinityEnabled;
        boolean bl = deciderAffinityEnabled = this.config != null && this.config.getDeciderAffinityConfig() != null && this.decisionTaskHandler.getAffinityHelper().getAffinityTaskList() != null;
        if (!deciderAffinityEnabled) {
            return false;
        }
        boolean establishAffinityPredicateResult = true;
        HistoryEvent firstEvent = (HistoryEvent)decisionTask.events().get(0);
        if (EventType.WORKFLOW_EXECUTION_STARTED.equals((Object)EventType.fromValue((String)firstEvent.eventTypeAsString()))) {
            establishAffinityPredicateResult = this.config.getDeciderAffinityConfig().getEstablishAffinityPredicate().test(WorkflowExecutionMetadata.fromSdkType(firstEvent.workflowExecutionStartedEventAttributes()));
        }
        return establishAffinityPredicateResult;
    }

    private void forceFetchFullHistoryIfNeeded(boolean isAffinityEstablished, PollForDecisionTaskResponse decisionTask, Metrics metrics) {
        if (isAffinityEstablished) {
            boolean fullHistoryForceFetched = false;
            boolean fullHistoryForceFetchFailure = false;
            try {
                if (this.decisionTaskHandler.getAffinityHelper().shouldForceFetchFullHistory(decisionTask)) {
                    WorkflowHistoryDecisionTaskIterator historyIterator = this.decisionTaskHandler.getAffinityHelper().getHistoryIterator(decisionTask);
                    while (historyIterator.hasNext()) {
                        historyIterator.next();
                    }
                    fullHistoryForceFetched = true;
                }
            }
            catch (Throwable throwable) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("Fetching full history failure: taskId= " + decisionTask.startedEventId() + ", workflowExecution=" + decisionTask.workflowExecution()), throwable);
                }
                fullHistoryForceFetchFailure = true;
            }
            metrics.recordCount(MetricName.AFFINITY_FULL_HISTORY_FORCE_FETCHED.getName(), (double)fullHistoryForceFetched, MetricName.getWorkflowTypeDimension(WorkflowType.fromSdkType(decisionTask.workflowType())));
            metrics.recordCount(MetricName.AFFINITY_FULL_HISTORY_FORCE_FETCH_FAILURE.getName(), (double)fullHistoryForceFetchFailure, MetricName.getWorkflowTypeDimension(WorkflowType.fromSdkType(decisionTask.workflowType())));
        }
    }

    private void waitIfSuspended() throws InterruptedException {
        this.lock.lock();
        try {
            while (this.suspended) {
                this.suspentionCondition.await();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void validate() throws IllegalStateException {
        if (this.validated) {
            return;
        }
        this.checkFieldSet("decisionTaskHandler", this.decisionTaskHandler);
        this.checkFieldSet("service", this.service);
        this.checkFieldSet("identity", this.identity);
        this.validated = true;
    }

    private void checkFieldSet(String fieldName, Object fieldValue) throws IllegalStateException {
        if (fieldValue == null) {
            throw new IllegalStateException("Required field " + fieldName + " is not set");
        }
    }

    @Override
    public void suspend() {
        this.lock.lock();
        try {
            this.suspended = true;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void resume() {
        this.lock.lock();
        try {
            this.suspended = false;
            this.suspentionCondition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isSuspended() {
        this.lock.lock();
        try {
            boolean bl = this.suspended;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void shutdown() {
        this.shutdownRequested = true;
    }

    @Override
    public SuspendableSemaphore getPollingSemaphore() {
        return null;
    }

    public SwfClient getService() {
        return this.service;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getTaskListToPoll() {
        return this.taskListToPoll;
    }

    public void setTaskListToPoll(String taskListToPoll) {
        this.taskListToPoll = taskListToPoll;
    }

    public String getIdentity() {
        return this.identity;
    }

    public DecisionTaskHandler getDecisionTaskHandler() {
        return this.decisionTaskHandler;
    }

    public void setShutdownRequested(boolean shutdownRequested) {
        this.shutdownRequested = shutdownRequested;
    }

    public SimpleWorkflowClientConfig getConfig() {
        return this.config;
    }

    public void setConfig(SimpleWorkflowClientConfig config) {
        this.config = config;
    }

    public MetricsRegistry getMetricsRegistry() {
        return this.metricsRegistry;
    }

    public void setMetricsRegistry(MetricsRegistry metricsRegistry) {
        this.metricsRegistry = metricsRegistry;
    }

    protected class DecisionTaskIterator
    implements Iterator<PollForDecisionTaskResponse> {
        private PollForDecisionTaskResponse firstDecisionTask;
        private PollForDecisionTaskResponse next;
        private final MetricsContext metricsContext;

        public DecisionTaskIterator(Metrics metrics) {
            this.metricsContext = new MetricsContext(metrics);
            this.next = this.firstDecisionTask = metrics.recordSupplier(() -> this.pollInternal(null), MetricName.Operation.POLL_FOR_DECISION_TASK.getName(), TimeUnit.MILLISECONDS);
            if (this.hasNext()) {
                this.metricsContext.incrementPageCount();
                this.metricsContext.setMaxEventId(this.next.startedEventId(), WorkflowType.fromSdkType(this.next.workflowType()));
                MetricHelper.recordMetrics(this.next, metrics);
            }
        }

        @Override
        public boolean hasNext() {
            boolean hasNext;
            boolean bl = hasNext = this.next != null;
            if (!hasNext) {
                this.metricsContext.close();
            }
            return hasNext;
        }

        @Override
        public PollForDecisionTaskResponse next() {
            if (!this.hasNext()) {
                throw new IllegalStateException("hasNext() == false");
            }
            PollForDecisionTaskResponse result = this.next;
            if (this.next.nextPageToken() == null) {
                this.next = null;
            } else {
                try {
                    this.next = this.metricsContext.getMetrics().recordSupplier(() -> this.pollInternal(this.next.nextPageToken()), MetricName.Operation.POLL_FOR_DECISION_TASK.getName(), TimeUnit.MILLISECONDS);
                }
                catch (Exception e) {
                    throw new Error("Failure getting next page of history events.", e);
                }
                if (this.next != null) {
                    this.metricsContext.incrementPageCount();
                }
                if (this.firstDecisionTask != result) {
                    this.firstDecisionTask = (PollForDecisionTaskResponse)this.firstDecisionTask.toBuilder().events(new HistoryEvent[]{null}).build();
                }
            }
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private PollForDecisionTaskResponse pollInternal(String nextToken) {
            try {
                return DecisionTaskPoller.this.poll(nextToken);
            }
            catch (Exception e) {
                this.metricsContext.close();
                throw e;
            }
        }

        public PollForDecisionTaskResponse getFirstDecisionTask() {
            return this.firstDecisionTask;
        }

        private class MetricsContext {
            private final Metrics metrics;
            private final AtomicBoolean isClosed = new AtomicBoolean(false);
            private int pages;
            private long maxEventId;
            private WorkflowType workflowType;

            public MetricsContext(Metrics metrics) {
                this.metrics = metrics;
                this.pages = 0;
                this.maxEventId = 0L;
                this.metrics.addProperty(MetricName.Property.TASK_LIST.getName(), DecisionTaskPoller.this.taskListToPoll);
                this.metrics.addProperty(MetricName.Property.DOMAIN.getName(), DecisionTaskPoller.this.domain);
            }

            public void incrementPageCount() {
                if (!this.isClosed.get()) {
                    ++this.pages;
                }
            }

            public void setMaxEventId(long maxEventId, WorkflowType workflowType) {
                if (!this.isClosed.get()) {
                    this.maxEventId = maxEventId;
                    this.workflowType = workflowType;
                }
            }

            public void close() {
                if (this.isClosed.compareAndSet(false, true)) {
                    if (this.pages > 0) {
                        DecisionTaskIterator.this.metricsContext.getMetrics().recordCount(MetricName.PAGE_COUNT.getName(), this.getPages(), MetricName.getOperationDimension(MetricName.Operation.POLL_FOR_DECISION_TASK.getName()));
                    }
                    DecisionTaskIterator.this.metricsContext.getMetrics().recordCount(MetricName.EMPTY_POLL_COUNT.getName(), this.getPages() == 0, MetricName.getOperationDimension(MetricName.Operation.POLL_FOR_DECISION_TASK.getName()));
                    if (this.maxEventId > 0L) {
                        DecisionTaskIterator.this.metricsContext.getMetrics().recordCount(MetricName.MAXIMUM_HISTORY_EVENT_ID.getName(), this.maxEventId, MetricName.getWorkflowTypeDimension(this.workflowType));
                    }
                    this.metrics.close();
                }
            }

            public Metrics getMetrics() {
                return this.metrics;
            }

            public AtomicBoolean getIsClosed() {
                return this.isClosed;
            }

            public int getPages() {
                return this.pages;
            }

            public long getMaxEventId() {
                return this.maxEventId;
            }

            public WorkflowType getWorkflowType() {
                return this.workflowType;
            }
        }
    }
}

