/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.worker;

import com.amazonaws.services.simpleworkflow.flow.generic.WorkflowTypeComponentImplementationVersion;
import com.amazonaws.services.simpleworkflow.flow.worker.ComponentVersion;
import com.amazonaws.services.simpleworkflow.flow.worker.IncompatibleWorkflowDefinition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

class ComponentVersions {
    private final Map<String, ComponentVersion> versions = new HashMap<String, ComponentVersion>();

    ComponentVersions() {
    }

    void setVersionFromHistory(String component, int version) {
        ComponentVersion cv = this.getComponentVersion(component);
        cv.setVersionFromHistory(version);
    }

    public Map<String, Integer> getVersionsToSave() {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (Map.Entry<String, ComponentVersion> pair : this.versions.entrySet()) {
            ComponentVersion version = pair.getValue();
            int currentVersion = version.getCurrentVersion();
            if (currentVersion <= 0) continue;
            result.put(pair.getKey(), currentVersion);
        }
        return result;
    }

    private ComponentVersion getComponentVersion(String component) {
        ComponentVersion cv = this.versions.get(component);
        if (cv == null) {
            cv = new ComponentVersion(component);
            this.versions.put(component, cv);
        }
        return cv;
    }

    public boolean isVersion(String component, int version, boolean replaying) {
        if (component.contains("\t")) {
            throw new IncompatibleWorkflowDefinition("component name cannot contain character with code=" + Pattern.quote("\t"));
        }
        ComponentVersion cv = this.versions.get(component);
        if (cv == null) {
            cv = new ComponentVersion(component);
            this.versions.put(component, cv);
            return cv.isVersion(version, replaying);
        }
        return cv.isVersion(version, replaying);
    }

    public Integer getCurrentVersion(String component) {
        ComponentVersion cv = this.versions.get(component);
        if (cv == null) {
            return null;
        }
        return cv.getCurrentVersion();
    }

    public void setWorkflowImplementationComponentVersions(List<WorkflowTypeComponentImplementationVersion> versions) {
        for (WorkflowTypeComponentImplementationVersion version : versions) {
            String componentName = version.getComponentName();
            ComponentVersion componentVersion = this.getComponentVersion(componentName);
            componentVersion.setMaximumAllowedImplementationVersion(version.getMaximumAllowed());
            componentVersion.setMaximumSupportedImplementationVersion(version.getMaximumSupported());
            componentVersion.setMinimumSupportedImplementationVersion(version.getMinimumSupported());
        }
    }

    public List<WorkflowTypeComponentImplementationVersion> getWorkflowImplementationComponentVersions() {
        ArrayList<WorkflowTypeComponentImplementationVersion> result = new ArrayList<WorkflowTypeComponentImplementationVersion>();
        for (ComponentVersion version : this.versions.values()) {
            String componentName = version.getComponentName();
            int minimumSupportedImplementationVersion = version.getMaximumSupportedImplementationVersion();
            int maximumSupportedImplementationVersion = version.getMaximumSupportedImplementationVersion();
            int maximumAllowedImplementationVersion = version.getMaximumAllowedImplementationVersion();
            WorkflowTypeComponentImplementationVersion iv = new WorkflowTypeComponentImplementationVersion(componentName, minimumSupportedImplementationVersion, maximumSupportedImplementationVersion, maximumAllowedImplementationVersion);
            result.add(iv);
        }
        return result;
    }
}

