/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.pojo;

import com.amazonaws.services.simpleworkflow.flow.ActivityExecutionContext;
import com.amazonaws.services.simpleworkflow.flow.ActivityFailureException;
import com.amazonaws.services.simpleworkflow.flow.DataConverter;
import com.amazonaws.services.simpleworkflow.flow.DataConverterException;
import com.amazonaws.services.simpleworkflow.flow.common.FlowHelpers;
import com.amazonaws.services.simpleworkflow.flow.common.FlowValueConstraint;
import com.amazonaws.services.simpleworkflow.flow.common.WorkflowExecutionUtils;
import com.amazonaws.services.simpleworkflow.flow.generic.ActivityImplementationBase;
import com.amazonaws.services.simpleworkflow.flow.monitoring.MetricName;
import com.amazonaws.services.simpleworkflow.flow.monitoring.ThreadLocalMetrics;
import com.amazonaws.services.simpleworkflow.flow.worker.ActivityTypeExecutionOptions;
import com.amazonaws.services.simpleworkflow.flow.worker.ActivityTypeRegistrationOptions;
import com.amazonaws.services.simpleworkflow.flow.worker.CurrentActivityExecutionContext;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class POJOActivityImplementation
extends ActivityImplementationBase {
    private static final Log log = LogFactory.getLog(POJOActivityImplementation.class);
    private final Method activity;
    private final Object activitiesImplementationObject;
    private final ActivityTypeExecutionOptions executionOptions;
    private final DataConverter converter;
    private final ActivityTypeRegistrationOptions registrationOptions;

    public POJOActivityImplementation(Object activitiesImplementationObject, Method activity, ActivityTypeRegistrationOptions registrationOptions, ActivityTypeExecutionOptions executionOptions, DataConverter converter) {
        this.activitiesImplementationObject = activitiesImplementationObject;
        this.activity = activity;
        this.registrationOptions = registrationOptions;
        this.executionOptions = executionOptions;
        this.converter = converter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String execute(String input, ActivityExecutionContext context) throws ActivityFailureException, CancellationException {
        Object[] inputParameters = ThreadLocalMetrics.getMetrics().recordSupplier(() -> this.converter.fromData(input, Object[].class), this.converter.getClass().getSimpleName() + "@" + MetricName.Operation.DATA_CONVERTER_DESERIALIZE.getName(), TimeUnit.MILLISECONDS);
        CurrentActivityExecutionContext.set(context);
        Object result = null;
        try {
            inputParameters = FlowHelpers.getInputParameters(this.activity.getParameterTypes(), inputParameters);
            result = this.activity.invoke(this.activitiesImplementationObject, inputParameters);
        }
        catch (InvocationTargetException invocationException) {
            this.throwActivityFailureException(invocationException.getTargetException() != null ? invocationException.getTargetException() : invocationException);
        }
        catch (IllegalAccessException | IllegalArgumentException illegalArgumentException) {
            this.throwActivityFailureException(illegalArgumentException);
        }
        finally {
            CurrentActivityExecutionContext.unset();
        }
        Object finalResult = result;
        return ThreadLocalMetrics.getMetrics().recordSupplier(() -> this.converter.toData(finalResult), this.converter.getClass().getSimpleName() + "@" + MetricName.Operation.DATA_CONVERTER_SERIALIZE.getName(), TimeUnit.MILLISECONDS);
    }

    @Override
    public ActivityTypeRegistrationOptions getRegistrationOptions() {
        return this.registrationOptions;
    }

    @Override
    public ActivityTypeExecutionOptions getExecutionOptions() {
        return this.executionOptions;
    }

    void throwActivityFailureException(Throwable exception) throws ActivityFailureException, CancellationException {
        if (exception instanceof CancellationException) {
            throw (CancellationException)exception;
        }
        String reason = exception.getMessage();
        String details = null;
        try {
            details = ThreadLocalMetrics.getMetrics().recordSupplier(() -> this.converter.toData(exception), this.converter.getClass().getSimpleName() + "@" + MetricName.Operation.DATA_CONVERTER_SERIALIZE.getName(), TimeUnit.MILLISECONDS);
        }
        catch (DataConverterException dataConverterException) {
            if (dataConverterException.getCause() == null) {
                dataConverterException.initCause(exception);
            }
            throw dataConverterException;
        }
        if (details.length() > FlowValueConstraint.FAILURE_DETAILS.getMaxSize()) {
            log.warn((Object)("Length of details is over maximum input length of 32768. Actual details: " + details));
            Throwable truncatedException = WorkflowExecutionUtils.truncateStackTrace(exception);
            ThreadLocalMetrics.getMetrics().recordCount(MetricName.RESPONSE_TRUNCATED.getName(), 1.0, MetricName.getActivityTypeDimension(CurrentActivityExecutionContext.get().getTask().getActivityType()));
            details = ThreadLocalMetrics.getMetrics().recordSupplier(() -> this.converter.toData(truncatedException), this.converter.getClass().getSimpleName() + "@" + MetricName.Operation.DATA_CONVERTER_SERIALIZE.getName(), TimeUnit.MILLISECONDS);
        }
        throw new ActivityFailureException(reason, details);
    }

    public Method getMethod() {
        return this.activity;
    }

    public Object getActivitiesImplementation() {
        return this.activitiesImplementationObject;
    }
}

