/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.interceptors;

import com.amazonaws.services.simpleworkflow.flow.DecisionContextProviderImpl;
import com.amazonaws.services.simpleworkflow.flow.WorkflowClock;
import com.amazonaws.services.simpleworkflow.flow.core.AndPromise;
import com.amazonaws.services.simpleworkflow.flow.core.Promise;
import com.amazonaws.services.simpleworkflow.flow.core.Settable;
import com.amazonaws.services.simpleworkflow.flow.core.Task;
import com.amazonaws.services.simpleworkflow.flow.interceptors.AsyncRetryingExecutor;
import com.amazonaws.services.simpleworkflow.flow.interceptors.AsyncRunnable;
import com.amazonaws.services.simpleworkflow.flow.interceptors.Decorator;
import com.amazonaws.services.simpleworkflow.flow.interceptors.RetryPolicy;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;

public class RetryDecorator
implements Decorator {
    private final RetryPolicy retryPolicy;
    private final WorkflowClock clock;

    public RetryDecorator(RetryPolicy retryPolicy, WorkflowClock clock) {
        this.retryPolicy = retryPolicy;
        this.clock = clock;
    }

    public RetryDecorator(RetryPolicy retryPolicy) {
        this(retryPolicy, new DecisionContextProviderImpl().getDecisionContext().getWorkflowClock());
    }

    @Override
    public final <V> V decorate(Class<V> interfaces, V object) {
        Class[] interfazes = new Class[]{interfaces};
        return (V)Proxy.newProxyInstance(object.getClass().getClassLoader(), interfazes, (InvocationHandler)new DecoratorInvocationHandler(object));
    }

    @Override
    public final <V> V decorate(Class<?>[] interfaces, V object) {
        return (V)Proxy.newProxyInstance(object.getClass().getClassLoader(), interfaces, (InvocationHandler)new DecoratorInvocationHandler(object));
    }

    protected boolean isDecorated(Method method, Object[] args) {
        return !method.getDeclaringClass().equals(Object.class);
    }

    private final class DecoratorInvocationHandler
    implements InvocationHandler {
        private final Object object;

        public DecoratorInvocationHandler(Object object) {
            this.object = object;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                if (!RetryDecorator.this.isDecorated(method, args)) {
                    return method.invoke(this.object, args);
                }
            }
            catch (InvocationTargetException ite) {
                throw ite.getTargetException();
            }
            AtomicLong firstAttemptTime = new AtomicLong(0L);
            RetriedRunnable command = new RetriedRunnable(args, method, firstAttemptTime);
            AsyncRetryingExecutor executor = new AsyncRetryingExecutor(RetryDecorator.this.retryPolicy, RetryDecorator.this.clock, firstAttemptTime);
            executor.execute(command);
            return command.getResult();
        }

        private final class RetriedRunnable
        implements AsyncRunnable {
            private final Object[] args;
            private final Method method;
            private final AtomicLong firstAttemptTime;
            private Settable result;

            private RetriedRunnable(Object[] args, Method method, AtomicLong firstAttemptTime) {
                this.args = args;
                Class<?> returnType = method.getReturnType();
                boolean voidReturnType = Void.TYPE.equals(returnType);
                if (!voidReturnType) {
                    if (!Promise.class.isAssignableFrom(returnType)) {
                        throw new IllegalArgumentException("Cannot decorate " + method.getName() + " as its return type is not void or Promise");
                    }
                    this.result = new Settable();
                }
                this.method = method;
                this.firstAttemptTime = firstAttemptTime;
            }

            @Override
            public void run() throws Throwable {
                ArrayList<Promise> waitFors = new ArrayList<Promise>();
                if (this.args != null) {
                    for (Object arg : this.args) {
                        if (arg instanceof Promise) {
                            waitFors.add((Promise)arg);
                        }
                        if (!(arg instanceof Promise[])) continue;
                        waitFors.addAll(Arrays.asList((Promise[])arg));
                    }
                }
                AndPromise waitFor = new AndPromise(waitFors);
                new Task(new Promise[]{waitFor}){

                    @Override
                    protected void doExecute() throws Throwable {
                        RetriedRunnable.this.firstAttemptTime.compareAndSet(0L, new DecisionContextProviderImpl().getDecisionContext().getWorkflowClock().currentTimeMillis());
                    }
                };
                if (this.result == null) {
                    this.method.invoke(DecoratorInvocationHandler.this.object, this.args);
                } else {
                    this.result.unchain();
                    this.result.chain((Promise)this.method.invoke(DecoratorInvocationHandler.this.object, this.args));
                }
            }

            public Promise getResult() {
                return this.result;
            }
        }
    }
}

