/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.aspectj;

import com.amazonaws.services.simpleworkflow.flow.DecisionContext;
import com.amazonaws.services.simpleworkflow.flow.DecisionContextProvider;
import com.amazonaws.services.simpleworkflow.flow.DecisionContextProviderImpl;
import com.amazonaws.services.simpleworkflow.flow.WorkflowClock;
import com.amazonaws.services.simpleworkflow.flow.WorkflowContext;
import com.amazonaws.services.simpleworkflow.flow.annotations.ExponentialRetry;
import com.amazonaws.services.simpleworkflow.flow.annotations.ExponentialRetryUpdate;
import com.amazonaws.services.simpleworkflow.flow.annotations.ExponentialRetryVersion;
import com.amazonaws.services.simpleworkflow.flow.core.AndPromise;
import com.amazonaws.services.simpleworkflow.flow.core.Promise;
import com.amazonaws.services.simpleworkflow.flow.core.Settable;
import com.amazonaws.services.simpleworkflow.flow.core.Task;
import com.amazonaws.services.simpleworkflow.flow.interceptors.AsyncRetryingExecutor;
import com.amazonaws.services.simpleworkflow.flow.interceptors.AsyncRunnable;
import com.amazonaws.services.simpleworkflow.flow.interceptors.ExponentialRetryPolicy;
import com.amazonaws.services.simpleworkflow.flow.worker.IncompatibleWorkflowDefinition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public class ExponentialRetryAspect {
    private final DecisionContextProvider decisionContextProviderImpl = new DecisionContextProviderImpl();
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static final /* synthetic */ ExponentialRetryAspect ajc$perSingletonInstance;

    @Around(value="execution(@com.amazonaws.services.simpleworkflow.flow.annotations.ExponentialRetryUpdate * *(..)) && @annotation(retryUpdateAnnotation)")
    public Object retry(ProceedingJoinPoint pjp, ExponentialRetryUpdate retryUpdateAnnotation) throws Throwable {
        int internalVersion;
        ExponentialRetryVersion[] versions = retryUpdateAnnotation.versions();
        TreeMap<Integer, ExponentialRetry> retriesByVersion = new TreeMap<Integer, ExponentialRetry>();
        for (ExponentialRetryVersion retryVersion : versions) {
            internalVersion = retryVersion.implementationVersion();
            ExponentialRetry previous = retriesByVersion.put(internalVersion, retryVersion.retry());
            if (previous == null) continue;
            throw new IncompatibleWorkflowDefinition("More then one @ExponentialRetry annotation found for version " + internalVersion);
        }
        DecisionContext decisionContext = this.decisionContextProviderImpl.getDecisionContext();
        WorkflowContext workflowContext = decisionContext.getWorkflowContext();
        String component = retryUpdateAnnotation.component();
        Iterator iterator = retriesByVersion.descendingKeySet().iterator();
        while (iterator.hasNext()) {
            internalVersion = (Integer)iterator.next();
            ExponentialRetry retryAnnotation = (ExponentialRetry)retriesByVersion.get(internalVersion);
            if (!workflowContext.isImplementationVersion(component, internalVersion)) continue;
            return this.retry(pjp, retryAnnotation);
        }
        throw new IncompatibleWorkflowDefinition("@ExponentialRetryUpdate doesn't include implementationVersion compatible with the workflow execution");
    }

    @Around(value="execution(@com.amazonaws.services.simpleworkflow.flow.annotations.ExponentialRetry * *(..)) && @annotation(retryAnnotation)")
    public Object retry(ProceedingJoinPoint pjp, ExponentialRetry retryAnnotation) throws Throwable {
        ExponentialRetryPolicy retryPolicy = this.createExponentialRetryPolicy(retryAnnotation);
        WorkflowClock clock = this.decisionContextProviderImpl.getDecisionContext().getWorkflowClock();
        AtomicLong firstAttemptTime = new AtomicLong(0L);
        AsyncRetryingExecutor executor = new AsyncRetryingExecutor(retryPolicy, clock, firstAttemptTime);
        Settable result = this.isVoidReturnType(pjp) ? null : new Settable();
        DecoratorInvocationHandler handler = new DecoratorInvocationHandler(pjp, firstAttemptTime, result);
        executor.execute(handler);
        return result;
    }

    private boolean isVoidReturnType(ProceedingJoinPoint pjp) {
        boolean isVoidReturnType = false;
        Signature signature = pjp.getStaticPart().getSignature();
        if (signature instanceof MethodSignature) {
            MethodSignature methodSignature = (MethodSignature)signature;
            isVoidReturnType = methodSignature != null ? Void.TYPE.equals(methodSignature.getReturnType()) : false;
        }
        return isVoidReturnType;
    }

    private ExponentialRetryPolicy createExponentialRetryPolicy(ExponentialRetry retryAnnotation) {
        ExponentialRetryPolicy retryPolicy = ((ExponentialRetryPolicy)((ExponentialRetryPolicy)new ExponentialRetryPolicy(retryAnnotation.initialRetryIntervalSeconds()).withExceptionsToRetry(Arrays.asList(retryAnnotation.exceptionsToRetry()))).withExceptionsToExclude(Arrays.asList(retryAnnotation.excludeExceptions()))).withBackoffCoefficient(retryAnnotation.backoffCoefficient()).withMaximumRetryIntervalSeconds(retryAnnotation.maximumRetryIntervalSeconds()).withRetryExpirationIntervalSeconds(retryAnnotation.retryExpirationSeconds()).withMaximumAttempts(retryAnnotation.maximumAttempts());
        retryPolicy.validate();
        return retryPolicy;
    }

    public static ExponentialRetryAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("com.amazonaws.services.simpleworkflow.flow.aspectj.ExponentialRetryAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }

    static {
        try {
            ExponentialRetryAspect.ajc$perSingletonInstance = new ExponentialRetryAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    private final class DecoratorInvocationHandler
    implements AsyncRunnable {
        private final ProceedingJoinPoint pjp;
        private final Settable result;
        private AtomicLong firstAttemptTime;

        public DecoratorInvocationHandler(ProceedingJoinPoint pjp, AtomicLong firstAttemptTime, Settable result) {
            this.pjp = pjp;
            this.firstAttemptTime = firstAttemptTime;
            this.result = result;
        }

        @Override
        public void run() throws Throwable {
            ArrayList<Promise> waitFors = new ArrayList<Promise>();
            if (this.pjp.getArgs() != null) {
                for (Object arg : this.pjp.getArgs()) {
                    if (arg instanceof Promise) {
                        waitFors.add((Promise)arg);
                    }
                    if (!(arg instanceof Promise[])) continue;
                    waitFors.addAll(Arrays.asList((Promise[])arg));
                }
            }
            AndPromise waitFor = new AndPromise(waitFors);
            new Task(new Promise[]{waitFor}){

                @Override
                protected void doExecute() throws Throwable {
                    DecoratorInvocationHandler.this.firstAttemptTime.compareAndSet(0L, ExponentialRetryAspect.this.decisionContextProviderImpl.getDecisionContext().getWorkflowClock().currentTimeMillis());
                }
            };
            if (this.result != null) {
                this.result.unchain();
                this.result.chain((Promise)this.pjp.proceed());
            } else {
                this.pjp.proceed();
            }
        }
    }
}

