/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow;

import com.amazonaws.services.simpleworkflow.flow.ChildWorkflowIdHandler;
import com.amazonaws.services.simpleworkflow.flow.DecisionContext;
import com.amazonaws.services.simpleworkflow.flow.common.WorkflowExecutionUtils;
import com.amazonaws.services.simpleworkflow.flow.config.SimpleWorkflowClientConfig;
import com.amazonaws.services.simpleworkflow.flow.core.AsyncTaskInfo;
import com.amazonaws.services.simpleworkflow.flow.generic.WorkflowDefinitionFactoryFactory;
import com.amazonaws.services.simpleworkflow.flow.model.WorkflowExecution;
import com.amazonaws.services.simpleworkflow.flow.model.WorkflowType;
import com.amazonaws.services.simpleworkflow.flow.pojo.POJOWorkflowDefinition;
import com.amazonaws.services.simpleworkflow.flow.pojo.POJOWorkflowDefinitionFactoryFactory;
import com.amazonaws.services.simpleworkflow.flow.pojo.POJOWorkflowImplementationFactory;
import com.amazonaws.services.simpleworkflow.flow.replaydeserializer.TimeStampMixin;
import com.amazonaws.services.simpleworkflow.flow.worker.AsyncDecisionTaskHandler;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import software.amazon.awssdk.services.swf.SwfClient;
import software.amazon.awssdk.services.swf.model.EventType;
import software.amazon.awssdk.services.swf.model.GetWorkflowExecutionHistoryResponse;
import software.amazon.awssdk.services.swf.model.HistoryEvent;
import software.amazon.awssdk.services.swf.model.PollForDecisionTaskResponse;
import software.amazon.awssdk.services.swf.model.RespondDecisionTaskCompletedRequest;
import software.amazon.awssdk.services.swf.model.WorkflowExecutionInfo;
import software.amazon.awssdk.services.swf.model.WorkflowExecutionStartedEventAttributes;

public class WorkflowReplayer<T> {
    private final Iterator<PollForDecisionTaskResponse> taskIterator;
    private final AsyncDecisionTaskHandler taskHandler;
    private int replayUpToEventId;
    private final AtomicBoolean replayed = new AtomicBoolean();

    public WorkflowReplayer(SwfClient service, String domain, WorkflowExecution workflowExecution, Class<T> workflowImplementationType) throws InstantiationException, IllegalAccessException {
        this(service, domain, workflowExecution, workflowImplementationType, (SimpleWorkflowClientConfig)null);
    }

    public WorkflowReplayer(SwfClient service, String domain, WorkflowExecution workflowExecution, Class<T> workflowImplementationType, SimpleWorkflowClientConfig config) throws InstantiationException, IllegalAccessException {
        this(service, domain, workflowExecution, workflowImplementationType, config, (ChildWorkflowIdHandler)null);
    }

    public WorkflowReplayer(SwfClient service, String domain, WorkflowExecution workflowExecution, Class<T> workflowImplementationType, SimpleWorkflowClientConfig config, ChildWorkflowIdHandler childWorkflowIdHandler) throws InstantiationException, IllegalAccessException {
        POJOWorkflowDefinitionFactoryFactory ff = new POJOWorkflowDefinitionFactoryFactory();
        ff.addWorkflowImplementationType(workflowImplementationType);
        this.taskIterator = new ServiceDecisionTaskIterator(service, domain, workflowExecution, config);
        this.taskHandler = new AsyncDecisionTaskHandler((WorkflowDefinitionFactoryFactory)ff, childWorkflowIdHandler);
    }

    public WorkflowReplayer(SwfClient service, String domain, WorkflowExecution workflowExecution, T workflowImplementation) throws InstantiationException, IllegalAccessException {
        this(service, domain, workflowExecution, workflowImplementation, null);
    }

    public WorkflowReplayer(SwfClient service, String domain, WorkflowExecution workflowExecution, T workflowImplementation, SimpleWorkflowClientConfig config) throws InstantiationException, IllegalAccessException {
        this(service, domain, workflowExecution, workflowImplementation, null, null);
    }

    public WorkflowReplayer(SwfClient service, String domain, WorkflowExecution workflowExecution, T workflowImplementation, SimpleWorkflowClientConfig config, ChildWorkflowIdHandler childWorkflowIdHandler) throws InstantiationException, IllegalAccessException {
        WorkflowReplayerPOJOFactoryFactory ff = new WorkflowReplayerPOJOFactoryFactory(workflowImplementation);
        this.taskIterator = new ServiceDecisionTaskIterator(service, domain, workflowExecution, config);
        this.taskHandler = new AsyncDecisionTaskHandler((WorkflowDefinitionFactoryFactory)ff, childWorkflowIdHandler);
    }

    public WorkflowReplayer(SwfClient service, String domain, WorkflowExecution workflowExecution, WorkflowDefinitionFactoryFactory workflowDefinitionFactoryFactory) throws InstantiationException, IllegalAccessException {
        this(service, domain, workflowExecution, workflowDefinitionFactoryFactory, (SimpleWorkflowClientConfig)null);
    }

    public WorkflowReplayer(SwfClient service, String domain, WorkflowExecution workflowExecution, WorkflowDefinitionFactoryFactory workflowDefinitionFactoryFactory, SimpleWorkflowClientConfig config) throws InstantiationException, IllegalAccessException {
        this(service, domain, workflowExecution, workflowDefinitionFactoryFactory, config, (ChildWorkflowIdHandler)null);
    }

    public WorkflowReplayer(SwfClient service, String domain, WorkflowExecution workflowExecution, WorkflowDefinitionFactoryFactory workflowDefinitionFactoryFactory, SimpleWorkflowClientConfig config, ChildWorkflowIdHandler childWorkflowIdHandler) throws InstantiationException, IllegalAccessException {
        this.taskIterator = new ServiceDecisionTaskIterator(service, domain, workflowExecution, config);
        this.taskHandler = new AsyncDecisionTaskHandler(workflowDefinitionFactoryFactory, childWorkflowIdHandler);
    }

    public WorkflowReplayer(Iterable<HistoryEvent> history, WorkflowExecution workflowExecution, Class<T> workflowImplementationType) throws InstantiationException, IllegalAccessException {
        this(history, workflowExecution, workflowImplementationType, false);
    }

    public WorkflowReplayer(Iterable<HistoryEvent> history, WorkflowExecution workflowExecution, Class<T> workflowImplementationType, boolean skipFailedCheck) throws InstantiationException, IllegalAccessException {
        this(history, workflowExecution, workflowImplementationType, skipFailedCheck, null);
    }

    public WorkflowReplayer(Iterable<HistoryEvent> history, WorkflowExecution workflowExecution, Class<T> workflowImplementationType, boolean skipFailedCheck, ChildWorkflowIdHandler childWorkflowIdHandler) throws InstantiationException, IllegalAccessException {
        POJOWorkflowDefinitionFactoryFactory ff = new POJOWorkflowDefinitionFactoryFactory();
        ff.addWorkflowImplementationType(workflowImplementationType);
        this.taskIterator = new HistoryIterableDecisionTaskIterator(workflowExecution, history);
        this.taskHandler = new AsyncDecisionTaskHandler((WorkflowDefinitionFactoryFactory)ff, skipFailedCheck, childWorkflowIdHandler);
    }

    public WorkflowReplayer(Iterable<HistoryEvent> history, WorkflowExecution workflowExecution, T workflowImplementation) throws InstantiationException, IllegalAccessException {
        this(history, workflowExecution, workflowImplementation, null);
    }

    public WorkflowReplayer(Iterable<HistoryEvent> history, WorkflowExecution workflowExecution, T workflowImplementation, ChildWorkflowIdHandler childWorkflowIdHandler) throws InstantiationException, IllegalAccessException {
        WorkflowReplayerPOJOFactoryFactory ff = new WorkflowReplayerPOJOFactoryFactory(workflowImplementation);
        this.taskIterator = new HistoryIterableDecisionTaskIterator(workflowExecution, history);
        this.taskHandler = new AsyncDecisionTaskHandler((WorkflowDefinitionFactoryFactory)ff, childWorkflowIdHandler);
    }

    public WorkflowReplayer(Iterable<HistoryEvent> history, WorkflowExecution workflowExecution, WorkflowDefinitionFactoryFactory workflowDefinitionFactoryFactory) throws InstantiationException, IllegalAccessException {
        this(history, workflowExecution, workflowDefinitionFactoryFactory, (ChildWorkflowIdHandler)null);
    }

    public WorkflowReplayer(Iterable<HistoryEvent> history, WorkflowExecution workflowExecution, WorkflowDefinitionFactoryFactory workflowDefinitionFactoryFactory, ChildWorkflowIdHandler childWorkflowIdHandler) throws InstantiationException, IllegalAccessException {
        this.taskIterator = new HistoryIterableDecisionTaskIterator(workflowExecution, history);
        this.taskHandler = new AsyncDecisionTaskHandler(workflowDefinitionFactoryFactory, childWorkflowIdHandler);
    }

    public WorkflowReplayer(String historyEvents, WorkflowExecution workflowExecution, Class<T> workflowImplementationType) throws InstantiationException, IllegalAccessException, IOException {
        this(historyEvents, workflowExecution, workflowImplementationType, false);
    }

    public WorkflowReplayer(String historyEvents, WorkflowExecution workflowExecution, Class<T> workflowImplementationType, boolean skipFailedCheck) throws InstantiationException, IllegalAccessException, IOException {
        this(historyEvents, workflowExecution, workflowImplementationType, skipFailedCheck, null);
    }

    public WorkflowReplayer(String historyEvents, WorkflowExecution workflowExecution, Class<T> workflowImplementationType, boolean skipFailedCheck, ChildWorkflowIdHandler childWorkflowIdHandler) throws InstantiationException, IllegalAccessException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.addMixIn(HistoryEvent.class, TimeStampMixin.class);
        ObjectReader reader = mapper.readerFor((TypeReference)new TypeReference<List<HistoryEvent>>(){}).withRootName("events");
        List history = (List)reader.readValue(historyEvents);
        POJOWorkflowDefinitionFactoryFactory ff = new POJOWorkflowDefinitionFactoryFactory();
        ff.addWorkflowImplementationType(workflowImplementationType);
        this.taskIterator = new HistoryIterableDecisionTaskIterator(workflowExecution, history);
        this.taskHandler = new AsyncDecisionTaskHandler((WorkflowDefinitionFactoryFactory)ff, skipFailedCheck, childWorkflowIdHandler);
    }

    public WorkflowReplayer(String historyEvents, WorkflowExecution workflowExecution, T workflowImplementation) throws InstantiationException, IllegalAccessException, IOException {
        this(historyEvents, workflowExecution, workflowImplementation, null);
    }

    public WorkflowReplayer(String historyEvents, WorkflowExecution workflowExecution, T workflowImplementation, ChildWorkflowIdHandler childWorkflowIdHandler) throws InstantiationException, IllegalAccessException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.addMixIn(HistoryEvent.class, TimeStampMixin.class);
        ObjectReader reader = mapper.readerFor((TypeReference)new TypeReference<List<HistoryEvent>>(){}).withRootName("events");
        List history = (List)reader.readValue(historyEvents);
        WorkflowReplayerPOJOFactoryFactory ff = new WorkflowReplayerPOJOFactoryFactory(workflowImplementation);
        this.taskIterator = new HistoryIterableDecisionTaskIterator(workflowExecution, history);
        this.taskHandler = new AsyncDecisionTaskHandler((WorkflowDefinitionFactoryFactory)ff, childWorkflowIdHandler);
    }

    public WorkflowReplayer(String historyEvents, WorkflowExecution workflowExecution, WorkflowDefinitionFactoryFactory workflowDefinitionFactoryFactory) throws IOException {
        this(historyEvents, workflowExecution, workflowDefinitionFactoryFactory, (ChildWorkflowIdHandler)null);
    }

    public WorkflowReplayer(String historyEvents, WorkflowExecution workflowExecution, WorkflowDefinitionFactoryFactory workflowDefinitionFactoryFactory, ChildWorkflowIdHandler childWorkflowIdHandler) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.addMixIn(HistoryEvent.class, TimeStampMixin.class);
        ObjectReader reader = mapper.readerFor((TypeReference)new TypeReference<List<HistoryEvent>>(){}).withRootName("events");
        List history = (List)reader.readValue(historyEvents);
        this.taskIterator = new HistoryIterableDecisionTaskIterator(workflowExecution, history);
        this.taskHandler = new AsyncDecisionTaskHandler(workflowDefinitionFactoryFactory, childWorkflowIdHandler);
    }

    public WorkflowReplayer(Iterator<PollForDecisionTaskResponse> decisionTasks, Class<T> workflowImplementationType) throws InstantiationException, IllegalAccessException {
        this(decisionTasks, workflowImplementationType, (ChildWorkflowIdHandler)null);
    }

    public WorkflowReplayer(Iterator<PollForDecisionTaskResponse> decisionTasks, Class<T> workflowImplementationType, ChildWorkflowIdHandler childWorkflowIdHandler) throws InstantiationException, IllegalAccessException {
        POJOWorkflowDefinitionFactoryFactory ff = new POJOWorkflowDefinitionFactoryFactory();
        ff.addWorkflowImplementationType(workflowImplementationType);
        this.taskIterator = decisionTasks;
        this.taskHandler = new AsyncDecisionTaskHandler((WorkflowDefinitionFactoryFactory)ff, childWorkflowIdHandler);
    }

    public WorkflowReplayer(Iterator<PollForDecisionTaskResponse> decisionTasks, T workflowImplementation) throws InstantiationException, IllegalAccessException {
        this(decisionTasks, workflowImplementation, null);
    }

    public WorkflowReplayer(Iterator<PollForDecisionTaskResponse> decisionTasks, T workflowImplementation, ChildWorkflowIdHandler childWorkflowIdHandler) throws InstantiationException, IllegalAccessException {
        WorkflowReplayerPOJOFactoryFactory ff = new WorkflowReplayerPOJOFactoryFactory(workflowImplementation);
        this.taskIterator = decisionTasks;
        this.taskHandler = new AsyncDecisionTaskHandler((WorkflowDefinitionFactoryFactory)ff, childWorkflowIdHandler);
    }

    public WorkflowReplayer(Iterator<PollForDecisionTaskResponse> decisionTasks, WorkflowDefinitionFactoryFactory workflowDefinitionFactoryFactory) throws InstantiationException, IllegalAccessException {
        this(decisionTasks, workflowDefinitionFactoryFactory, (ChildWorkflowIdHandler)null);
    }

    public WorkflowReplayer(Iterator<PollForDecisionTaskResponse> decisionTasks, WorkflowDefinitionFactoryFactory workflowDefinitionFactoryFactory, ChildWorkflowIdHandler childWorkflowIdHandler) throws InstantiationException, IllegalAccessException {
        this.taskIterator = decisionTasks;
        this.taskHandler = new AsyncDecisionTaskHandler(workflowDefinitionFactoryFactory, childWorkflowIdHandler);
    }

    public int getReplayUpToEventId() {
        return this.replayUpToEventId;
    }

    public void setReplayUpToEventId(int replayUpToEventId) {
        this.replayUpToEventId = replayUpToEventId;
    }

    public RespondDecisionTaskCompletedRequest replay() throws Exception {
        this.checkReplayed();
        return this.taskHandler.handleDecisionTask(this.taskIterator).getRespondDecisionTaskCompletedRequest();
    }

    public T loadWorkflow() throws Exception {
        this.checkReplayed();
        Object definition = this.taskHandler.loadWorkflowThroughReplay((Iterator)this.taskIterator);
        POJOWorkflowDefinition pojoDefinition = (POJOWorkflowDefinition)definition;
        return (T)pojoDefinition.getImplementationInstance();
    }

    public List<AsyncTaskInfo> getAsynchronousThreadDump() throws Exception {
        this.checkReplayed();
        return this.taskHandler.getAsynchronousThreadDump(this.taskIterator);
    }

    public String getAsynchronousThreadDumpAsString() throws Exception {
        this.checkReplayed();
        return this.taskHandler.getAsynchronousThreadDumpAsString(this.taskIterator);
    }

    private void checkReplayed() {
        if (!this.replayed.compareAndSet(false, true)) {
            throw new IllegalStateException("WorkflowReplayer instance can be used only once.");
        }
    }

    private class HistoryIterableDecisionTaskIterator
    extends DecisionTaskIterator {
        private final WorkflowExecution workflowExecution;
        private final Iterable<HistoryEvent> history;

        public HistoryIterableDecisionTaskIterator(WorkflowExecution workflowExecution, Iterable<HistoryEvent> history) {
            this.workflowExecution = workflowExecution;
            this.history = history;
        }

        @Override
        protected PollForDecisionTaskResponse getNextHistoryTask(String nextPageToken) {
            Iterator<HistoryEvent> iterator = this.history.iterator();
            if (!iterator.hasNext()) {
                throw new IllegalStateException("empty history");
            }
            HistoryEvent startEvent = iterator.next();
            WorkflowExecutionStartedEventAttributes startedAttributes = startEvent.workflowExecutionStartedEventAttributes();
            if (startedAttributes == null) {
                throw new IllegalStateException("first event is not WorkflowExecutionStarted: " + startEvent);
            }
            List<Object> events = new ArrayList<HistoryEvent>();
            events.add(startEvent);
            EventType eventType = null;
            int lastStartedIndex = 0;
            int index = 1;
            long previousStartedEventId = 0L;
            long startedEventId = 0L;
            while (iterator.hasNext()) {
                HistoryEvent event = iterator.next();
                eventType = EventType.fromValue((String)event.eventTypeAsString());
                events.add(event);
                if (eventType == EventType.DECISION_TASK_STARTED) {
                    previousStartedEventId = startedEventId;
                    startedEventId = event.eventId();
                    lastStartedIndex = index;
                }
                ++index;
            }
            if (events.size() > lastStartedIndex + 1) {
                events = events.subList(0, lastStartedIndex + 1);
            }
            return (PollForDecisionTaskResponse)PollForDecisionTaskResponse.builder().events(events).previousStartedEventId(Long.valueOf(previousStartedEventId)).startedEventId(Long.valueOf(startedEventId)).workflowExecution(this.workflowExecution.toSdkType()).workflowType(startedAttributes.workflowType()).build();
        }
    }

    private class ServiceDecisionTaskIterator
    extends DecisionTaskIterator {
        private final SwfClient service;
        private final String domain;
        private final WorkflowExecution workflowExecution;
        private final SimpleWorkflowClientConfig config;

        public ServiceDecisionTaskIterator(SwfClient service, String domain, WorkflowExecution workflowExecution) {
            this(service, domain, workflowExecution, null);
        }

        public ServiceDecisionTaskIterator(SwfClient service, String domain, WorkflowExecution workflowExecution, SimpleWorkflowClientConfig config) {
            this.service = service;
            this.domain = domain;
            this.workflowExecution = workflowExecution;
            this.config = config;
        }

        @Override
        protected PollForDecisionTaskResponse getNextHistoryTask(String nextPageToken) {
            WorkflowExecutionInfo executionInfo = WorkflowExecutionUtils.describeWorkflowInstance(this.service, this.domain, this.workflowExecution, this.config);
            GetWorkflowExecutionHistoryResponse history = WorkflowExecutionUtils.getHistoryPage(nextPageToken, this.service, this.domain, this.workflowExecution, this.config);
            List<HistoryEvent> events = history.events();
            if ((events = this.truncateHistory(events)) == null) {
                return null;
            }
            return (PollForDecisionTaskResponse)PollForDecisionTaskResponse.builder().events(events).workflowExecution(this.workflowExecution.toSdkType()).workflowType(executionInfo.workflowType()).nextPageToken(history.nextPageToken()).build();
        }
    }

    private abstract class DecisionTaskIterator
    implements Iterator<PollForDecisionTaskResponse> {
        private PollForDecisionTaskResponse next;
        private boolean initialized;

        private DecisionTaskIterator() {
        }

        protected void initNext() {
            this.initialized = true;
            this.next = this.getNextHistoryTask(null);
        }

        @Override
        public boolean hasNext() {
            if (!this.initialized) {
                this.initNext();
            }
            if (this.next == null) {
                return false;
            }
            List events = this.next.events();
            if (events.size() == 0) {
                return false;
            }
            if (WorkflowReplayer.this.replayUpToEventId == 0) {
                return true;
            }
            HistoryEvent firstEvent = (HistoryEvent)this.next.events().get(0);
            return firstEvent.eventId() <= (long)WorkflowReplayer.this.replayUpToEventId;
        }

        @Override
        public PollForDecisionTaskResponse next() {
            if (!this.hasNext()) {
                throw new IllegalStateException("hasNext() == false");
            }
            PollForDecisionTaskResponse result = this.next;
            this.next = this.next.nextPageToken() == null ? null : this.getNextHistoryTask(this.next.nextPageToken());
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        protected List<HistoryEvent> truncateHistory(List<HistoryEvent> events) {
            if (events.size() == 0) {
                return null;
            }
            if (WorkflowReplayer.this.replayUpToEventId == 0) {
                return events;
            }
            HistoryEvent lastEvent = events.get(events.size() - 1);
            if (lastEvent.eventId() <= (long)WorkflowReplayer.this.replayUpToEventId) {
                return events;
            }
            ArrayList<HistoryEvent> truncated = new ArrayList<HistoryEvent>();
            for (HistoryEvent event : events) {
                if (event.eventId() > (long)WorkflowReplayer.this.replayUpToEventId) break;
                truncated.add(event);
            }
            if (truncated.size() == 0) {
                return null;
            }
            return truncated;
        }

        protected abstract PollForDecisionTaskResponse getNextHistoryTask(String var1);
    }

    private final class WorkflowReplayerPOJOFactoryFactory
    extends POJOWorkflowDefinitionFactoryFactory {
        private final T workflowImplementation;

        private WorkflowReplayerPOJOFactoryFactory(T workflowImplementation) throws InstantiationException, IllegalAccessException {
            this.workflowImplementation = workflowImplementation;
            super.addWorkflowImplementationType(workflowImplementation.getClass());
        }

        @Override
        protected POJOWorkflowImplementationFactory getImplementationFactory(Class<?> workflowImplementationType, Class<?> workflowInteface, WorkflowType workflowType) {
            return new POJOWorkflowImplementationFactory(){

                @Override
                public Object newInstance(DecisionContext decisionContext) throws Exception {
                    return WorkflowReplayerPOJOFactoryFactory.this.workflowImplementation;
                }

                @Override
                public Object newInstance(DecisionContext decisionContext, Object[] constructorArgs) throws Exception {
                    return WorkflowReplayerPOJOFactoryFactory.this.workflowImplementation;
                }

                @Override
                public void deleteInstance(Object instance) {
                }
            };
        }
    }
}

