/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow;

import com.amazonaws.services.simpleworkflow.flow.DataConverter;
import com.amazonaws.services.simpleworkflow.flow.ManualActivityCompletionClient;
import com.amazonaws.services.simpleworkflow.flow.common.RequestTimeoutHelper;
import com.amazonaws.services.simpleworkflow.flow.common.WorkflowExecutionUtils;
import com.amazonaws.services.simpleworkflow.flow.config.SimpleWorkflowClientConfig;
import com.amazonaws.services.simpleworkflow.flow.monitoring.MetricName;
import com.amazonaws.services.simpleworkflow.flow.monitoring.ThreadLocalMetrics;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import software.amazon.awssdk.services.swf.SwfClient;
import software.amazon.awssdk.services.swf.model.RecordActivityTaskHeartbeatRequest;
import software.amazon.awssdk.services.swf.model.RecordActivityTaskHeartbeatResponse;
import software.amazon.awssdk.services.swf.model.RespondActivityTaskCanceledRequest;
import software.amazon.awssdk.services.swf.model.RespondActivityTaskCompletedRequest;
import software.amazon.awssdk.services.swf.model.RespondActivityTaskFailedRequest;

class ManualActivityCompletionClientImpl
extends ManualActivityCompletionClient {
    private final SwfClient service;
    private final String taskToken;
    private final DataConverter dataConverter;
    private SimpleWorkflowClientConfig config;

    public ManualActivityCompletionClientImpl(SwfClient service, String taskToken, DataConverter dataConverter) {
        this(service, taskToken, dataConverter, null);
    }

    public ManualActivityCompletionClientImpl(SwfClient service, String taskToken, DataConverter dataConverter, SimpleWorkflowClientConfig config) {
        this.service = service;
        this.taskToken = taskToken;
        this.dataConverter = dataConverter;
        this.config = config;
    }

    @Override
    public void complete(Object result) {
        String convertedResult = ThreadLocalMetrics.getMetrics().recordSupplier(() -> this.dataConverter.toData(result), this.dataConverter.getClass().getSimpleName() + "@" + MetricName.Operation.DATA_CONVERTER_SERIALIZE.getName(), TimeUnit.MILLISECONDS);
        RespondActivityTaskCompletedRequest request = (RespondActivityTaskCompletedRequest)RespondActivityTaskCompletedRequest.builder().taskToken(this.taskToken).result(convertedResult).build();
        request = RequestTimeoutHelper.overrideDataPlaneRequestTimeout(request, this.config);
        this.service.respondActivityTaskCompleted(request);
    }

    @Override
    public void fail(Throwable failure) {
        String convertedFailure = ThreadLocalMetrics.getMetrics().recordSupplier(() -> this.dataConverter.toData(failure), this.dataConverter.getClass().getSimpleName() + "@" + MetricName.Operation.DATA_CONVERTER_SERIALIZE.getName(), TimeUnit.MILLISECONDS);
        RespondActivityTaskFailedRequest request = (RespondActivityTaskFailedRequest)RespondActivityTaskFailedRequest.builder().reason(WorkflowExecutionUtils.truncateReason(failure.getMessage())).details(convertedFailure).taskToken(this.taskToken).build();
        request = RequestTimeoutHelper.overrideDataPlaneRequestTimeout(request, this.config);
        this.service.respondActivityTaskFailed(request);
    }

    @Override
    public void recordHeartbeat(String details) throws CancellationException {
        RecordActivityTaskHeartbeatRequest request = (RecordActivityTaskHeartbeatRequest)RecordActivityTaskHeartbeatRequest.builder().details(details).taskToken(this.taskToken).build();
        RecordActivityTaskHeartbeatResponse status = this.service.recordActivityTaskHeartbeat(request = RequestTimeoutHelper.overrideDataPlaneRequestTimeout(request, this.config));
        if (status.cancelRequested().booleanValue()) {
            throw new CancellationException();
        }
    }

    @Override
    public void reportCancellation(String details) {
        RespondActivityTaskCanceledRequest request = (RespondActivityTaskCanceledRequest)RespondActivityTaskCanceledRequest.builder().details(details).taskToken(this.taskToken).build();
        request = RequestTimeoutHelper.overrideDataPlaneRequestTimeout(request, this.config);
        this.service.respondActivityTaskCanceled(request);
    }
}

