/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow;

import com.amazonaws.services.simpleworkflow.flow.ChildWorkflowFailedException;
import com.amazonaws.services.simpleworkflow.flow.DataConverter;
import com.amazonaws.services.simpleworkflow.flow.DataConverterException;
import com.amazonaws.services.simpleworkflow.flow.DecisionContextProvider;
import com.amazonaws.services.simpleworkflow.flow.DecisionContextProviderImpl;
import com.amazonaws.services.simpleworkflow.flow.DynamicWorkflowClient;
import com.amazonaws.services.simpleworkflow.flow.JsonDataConverter;
import com.amazonaws.services.simpleworkflow.flow.StartWorkflowOptions;
import com.amazonaws.services.simpleworkflow.flow.core.Functor;
import com.amazonaws.services.simpleworkflow.flow.core.Promise;
import com.amazonaws.services.simpleworkflow.flow.core.Settable;
import com.amazonaws.services.simpleworkflow.flow.core.Task;
import com.amazonaws.services.simpleworkflow.flow.core.TryFinally;
import com.amazonaws.services.simpleworkflow.flow.generic.GenericWorkflowClient;
import com.amazonaws.services.simpleworkflow.flow.generic.SignalExternalWorkflowParameters;
import com.amazonaws.services.simpleworkflow.flow.generic.StartChildWorkflowExecutionParameters;
import com.amazonaws.services.simpleworkflow.flow.generic.StartChildWorkflowReply;
import com.amazonaws.services.simpleworkflow.flow.model.WorkflowExecution;
import com.amazonaws.services.simpleworkflow.flow.model.WorkflowType;
import com.amazonaws.services.simpleworkflow.flow.monitoring.MetricName;
import com.amazonaws.services.simpleworkflow.flow.monitoring.ThreadLocalMetrics;
import java.util.concurrent.TimeUnit;

public class DynamicWorkflowClientImpl
implements DynamicWorkflowClient {
    protected WorkflowType workflowType;
    protected GenericWorkflowClient genericClient;
    protected StartWorkflowOptions schedulingOptions;
    protected DataConverter dataConverter;
    protected WorkflowExecution workflowExecution;
    protected String requestedWorkflowId;
    protected boolean startAttempted;
    protected Settable<String> runId = new Settable();
    protected DecisionContextProvider decisionContextProvider = new DecisionContextProviderImpl();

    public DynamicWorkflowClientImpl() {
        this(null, null, null, null, null);
    }

    public DynamicWorkflowClientImpl(WorkflowExecution workflowExecution) {
        this(workflowExecution, null, null, null, null);
    }

    public DynamicWorkflowClientImpl(WorkflowExecution workflowExecution, WorkflowType workflowType) {
        this(workflowExecution, workflowType, null, null, null);
    }

    public DynamicWorkflowClientImpl(WorkflowExecution workflowExecution, WorkflowType workflowType, StartWorkflowOptions options) {
        this(workflowExecution, workflowType, options, null, null);
    }

    public DynamicWorkflowClientImpl(WorkflowExecution workflowExecution, WorkflowType workflowType, StartWorkflowOptions options, DataConverter dataConverter) {
        this(workflowExecution, workflowType, options, dataConverter, null);
    }

    public DynamicWorkflowClientImpl(WorkflowExecution workflowExecution, WorkflowType workflowType, StartWorkflowOptions options, DataConverter dataConverter, GenericWorkflowClient genericClient) {
        this.workflowType = workflowType;
        this.workflowExecution = workflowExecution;
        if (workflowExecution.getRunId() != null) {
            this.runId.set(workflowExecution.getRunId());
        }
        this.dataConverter = dataConverter == null ? new JsonDataConverter() : dataConverter;
        this.schedulingOptions = options;
        this.genericClient = genericClient;
    }

    @Override
    public DataConverter getDataConverter() {
        return this.dataConverter;
    }

    @Override
    public StartWorkflowOptions getSchedulingOptions() {
        return this.schedulingOptions;
    }

    @Override
    public GenericWorkflowClient getGenericClient() {
        return this.genericClient;
    }

    @Override
    public Promise<String> getRunId() {
        return this.runId;
    }

    @Override
    public WorkflowExecution getWorkflowExecution() {
        return this.workflowExecution;
    }

    @Override
    public WorkflowType getWorkflowType() {
        return this.workflowType;
    }

    public void setWorkflowType(WorkflowType workflowType) {
        this.workflowType = workflowType;
    }

    public void setGenericClient(GenericWorkflowClient genericClient) {
        this.genericClient = genericClient;
    }

    public void setSchedulingOptions(StartWorkflowOptions schedulingOptions) {
        this.schedulingOptions = schedulingOptions;
    }

    public void setDataConverter(DataConverter dataConverter) {
        this.dataConverter = dataConverter;
    }

    @Override
    public void requestCancelWorkflowExecution(Promise<?> ... waitFor) {
        this.checkWorkflowExecution();
        new Task((Promise[])waitFor){

            @Override
            protected void doExecute() throws Throwable {
                GenericWorkflowClient client = DynamicWorkflowClientImpl.this.getGenericClientToUse();
                client.requestCancelWorkflowExecution(DynamicWorkflowClientImpl.this.workflowExecution);
            }
        };
    }

    private void checkWorkflowExecution() {
        if (this.workflowExecution == null) {
            throw new IllegalStateException("required property workflowExecution is null");
        }
    }

    @Override
    public <T> Promise<T> startWorkflowExecution(final Promise<Object>[] arguments, final StartWorkflowOptions startOptionsOverride, final Class<T> returnType, final Promise<?> ... waitFor) {
        this.checkState();
        if (this.runId.isReady()) {
            this.runId = new Settable();
            this.workflowExecution.setRunId(null);
        }
        return new Functor<T>((Promise[])arguments){

            @Override
            protected Promise<T> doExecute() throws Throwable {
                Object[] input = new Object[arguments.length];
                for (int i = 0; i < arguments.length; ++i) {
                    Promise argument = arguments[i];
                    input[i] = argument.get();
                }
                return DynamicWorkflowClientImpl.this.startWorkflowExecution(input, startOptionsOverride, returnType, waitFor);
            }
        };
    }

    @Override
    public <T> Promise<T> startWorkflowExecution(final Object[] arguments, final StartWorkflowOptions startOptionsOverride, final Class<T> returnType, Promise<?> ... waitFor) {
        this.checkState();
        final Settable result = new Settable();
        if (this.runId.isReady()) {
            this.runId = new Settable();
            this.workflowExecution.setRunId(null);
        }
        new TryFinally((Promise[])waitFor){
            Promise<StartChildWorkflowReply> reply;

            @Override
            protected void doTry() throws Throwable {
                StartChildWorkflowExecutionParameters parameters = new StartChildWorkflowExecutionParameters();
                parameters.setWorkflowType(DynamicWorkflowClientImpl.this.workflowType);
                String convertedArguments = ThreadLocalMetrics.getMetrics().recordSupplier(() -> DynamicWorkflowClientImpl.this.dataConverter.toData(arguments), DynamicWorkflowClientImpl.this.dataConverter.getClass().getSimpleName() + "@" + MetricName.Operation.DATA_CONVERTER_SERIALIZE.getName(), TimeUnit.MILLISECONDS);
                parameters.setInput(convertedArguments);
                if (!DynamicWorkflowClientImpl.this.startAttempted) {
                    parameters.setWorkflowId(DynamicWorkflowClientImpl.this.workflowExecution.getWorkflowId());
                    DynamicWorkflowClientImpl.this.requestedWorkflowId = DynamicWorkflowClientImpl.this.workflowExecution.getWorkflowId();
                    DynamicWorkflowClientImpl.this.startAttempted = true;
                } else {
                    parameters.setWorkflowId(DynamicWorkflowClientImpl.this.requestedWorkflowId);
                    DynamicWorkflowClientImpl.this.workflowExecution.setWorkflowId(DynamicWorkflowClientImpl.this.requestedWorkflowId);
                }
                StartChildWorkflowExecutionParameters startParameters = parameters.createStartChildWorkflowExecutionParametersFromOptions(DynamicWorkflowClientImpl.this.schedulingOptions, startOptionsOverride);
                GenericWorkflowClient client = DynamicWorkflowClientImpl.this.getGenericClientToUse();
                this.reply = client.startChildWorkflow(startParameters);
                DynamicWorkflowClientImpl.this.runId.setDescription("runId of " + this.reply.getDescription());
                result.setDescription(this.reply.getDescription());
                new Task(new Promise[]{this.reply}){

                    @Override
                    protected void doExecute() throws Throwable {
                        StartChildWorkflowReply r = reply.get();
                        if (!DynamicWorkflowClientImpl.this.runId.isReady()) {
                            DynamicWorkflowClientImpl.this.runId.set(r.getRunId());
                            DynamicWorkflowClientImpl.this.workflowExecution.setRunId(r.getRunId());
                            DynamicWorkflowClientImpl.this.workflowExecution.setWorkflowId(r.getWorkflowId());
                        }
                    }
                };
            }

            @Override
            protected void doCatch(Throwable e) throws Throwable {
                if (e instanceof ChildWorkflowFailedException) {
                    ChildWorkflowFailedException taskFailedException = (ChildWorkflowFailedException)e;
                    try {
                        Throwable cause;
                        String details = taskFailedException.getDetails();
                        if (details != null && (cause = ThreadLocalMetrics.getMetrics().recordSupplier(() -> DynamicWorkflowClientImpl.this.dataConverter.fromData(details, Throwable.class), DynamicWorkflowClientImpl.this.dataConverter.getClass().getSimpleName() + "@" + MetricName.Operation.DATA_CONVERTER_DESERIALIZE.getName(), TimeUnit.MILLISECONDS)) != null && taskFailedException.getCause() == null) {
                            taskFailedException.initCause(cause);
                        }
                    }
                    catch (DataConverterException dataConverterException) {
                        if (dataConverterException.getCause() == null) {
                            dataConverterException.initCause(taskFailedException);
                        }
                        throw dataConverterException;
                    }
                }
                throw e;
            }

            @Override
            protected void doFinally() throws Throwable {
                if (this.reply != null && this.reply.isReady() && this.reply.get().getResult().isReady()) {
                    if (returnType.equals(Void.class)) {
                        result.set(null);
                    } else {
                        Object output = ThreadLocalMetrics.getMetrics().recordSupplier(() -> DynamicWorkflowClientImpl.this.dataConverter.fromData(this.reply.get().getResult().get(), returnType), DynamicWorkflowClientImpl.this.dataConverter.getClass().getSimpleName() + "@" + MetricName.Operation.DATA_CONVERTER_DESERIALIZE.getName(), TimeUnit.MILLISECONDS);
                        result.set(output);
                    }
                }
            }
        };
        return result;
    }

    @Override
    public void signalWorkflowExecution(final String signalName, final Object[] arguments, Promise<?> ... waitFor) {
        this.checkWorkflowExecution();
        new Task((Promise[])waitFor){

            @Override
            protected void doExecute() throws Throwable {
                SignalExternalWorkflowParameters parameters = new SignalExternalWorkflowParameters();
                parameters.setSignalName(signalName);
                String input = ThreadLocalMetrics.getMetrics().recordSupplier(() -> DynamicWorkflowClientImpl.this.dataConverter.toData(arguments), DynamicWorkflowClientImpl.this.dataConverter.getClass().getSimpleName() + "@" + MetricName.Operation.DATA_CONVERTER_SERIALIZE.getName(), TimeUnit.MILLISECONDS);
                parameters.setInput(input);
                parameters.setWorkflowId(DynamicWorkflowClientImpl.this.workflowExecution.getWorkflowId());
                parameters.setRunId(DynamicWorkflowClientImpl.this.workflowExecution.getRunId());
                GenericWorkflowClient client = DynamicWorkflowClientImpl.this.getGenericClientToUse();
                client.signalWorkflowExecution(parameters);
            }
        };
    }

    private void checkState() {
        if (this.workflowType == null) {
            throw new IllegalStateException("required property workflowType is null");
        }
        this.checkWorkflowExecution();
    }

    private GenericWorkflowClient getGenericClientToUse() {
        GenericWorkflowClient client = this.genericClient == null ? this.decisionContextProvider.getDecisionContext().getWorkflowClient() : this.genericClient;
        return client;
    }
}

