/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.generic;

import com.amazonaws.services.simpleworkflow.flow.StartWorkflowOptions;
import com.amazonaws.services.simpleworkflow.model.ChildPolicy;
import com.amazonaws.services.simpleworkflow.model.WorkflowType;
import java.util.List;

public class StartChildWorkflowExecutionParameters
implements Cloneable {
    private String control;
    private long executionStartToCloseTimeoutSeconds = -2L;
    private String input;
    private List<String> tagList;
    private String taskList;
    private long taskStartToCloseTimeoutSeconds = -2L;
    private String workflowId;
    private WorkflowType workflowType;
    private ChildPolicy childPolicy;
    private int taskPriority;

    public String getControl() {
        return this.control;
    }

    public void setControl(String control) {
        this.control = control;
    }

    public StartChildWorkflowExecutionParameters withControl(String control) {
        this.control = control;
        return this;
    }

    public long getExecutionStartToCloseTimeoutSeconds() {
        return this.executionStartToCloseTimeoutSeconds;
    }

    public void setExecutionStartToCloseTimeoutSeconds(long executionStartToCloseTimeoutSeconds) {
        this.executionStartToCloseTimeoutSeconds = executionStartToCloseTimeoutSeconds;
    }

    public StartChildWorkflowExecutionParameters withExecutionStartToCloseTimeoutSeconds(long executionStartToCloseTimeoutSeconds) {
        this.executionStartToCloseTimeoutSeconds = executionStartToCloseTimeoutSeconds;
        return this;
    }

    public String getInput() {
        return this.input;
    }

    public void setInput(String input) {
        this.input = input;
    }

    public StartChildWorkflowExecutionParameters withInput(String input) {
        this.input = input;
        return this;
    }

    public List<String> getTagList() {
        return this.tagList;
    }

    public void setTagList(List<String> tagList) {
        this.tagList = tagList;
    }

    public StartChildWorkflowExecutionParameters withTagList(List<String> tagList) {
        this.tagList = tagList;
        return this;
    }

    public String getTaskList() {
        return this.taskList;
    }

    public void setTaskList(String taskList) {
        this.taskList = taskList;
    }

    public StartChildWorkflowExecutionParameters withTaskList(String taskList) {
        this.taskList = taskList;
        return this;
    }

    public long getTaskStartToCloseTimeoutSeconds() {
        return this.taskStartToCloseTimeoutSeconds;
    }

    public void setTaskStartToCloseTimeoutSeconds(long taskStartToCloseTimeoutSeconds) {
        this.taskStartToCloseTimeoutSeconds = taskStartToCloseTimeoutSeconds;
    }

    public StartChildWorkflowExecutionParameters withTaskStartToCloseTimeoutSeconds(long taskStartToCloseTimeoutSeconds) {
        this.taskStartToCloseTimeoutSeconds = taskStartToCloseTimeoutSeconds;
        return this;
    }

    public String getWorkflowId() {
        return this.workflowId;
    }

    public void setWorkflowId(String workflowId) {
        this.workflowId = workflowId;
    }

    public StartChildWorkflowExecutionParameters withWorkflowId(String workflowId) {
        this.workflowId = workflowId;
        return this;
    }

    public WorkflowType getWorkflowType() {
        return this.workflowType;
    }

    public void setWorkflowType(WorkflowType workflowType) {
        this.workflowType = workflowType;
    }

    public StartChildWorkflowExecutionParameters withWorkflowType(WorkflowType workflowType) {
        this.workflowType = workflowType;
        return this;
    }

    public ChildPolicy getChildPolicy() {
        return this.childPolicy;
    }

    public void setChildPolicy(ChildPolicy childPolicy) {
        this.childPolicy = childPolicy;
    }

    public StartChildWorkflowExecutionParameters withChildPolicy(ChildPolicy childPolicy) {
        this.childPolicy = childPolicy;
        return this;
    }

    public int getTaskPriority() {
        return this.taskPriority;
    }

    public void setTaskPriority(int taskPriority) {
        this.taskPriority = taskPriority;
    }

    public StartChildWorkflowExecutionParameters withTaskPriority(int taskPriority) {
        this.taskPriority = taskPriority;
        return this;
    }

    public StartChildWorkflowExecutionParameters createStartChildWorkflowExecutionParametersFromOptions(StartWorkflowOptions options, StartWorkflowOptions optionsOverride) {
        Integer taskPriority;
        ChildPolicy childPolicy;
        String taskList;
        List<String> tagList;
        Long taskStartToCloseTimeoutSeconds;
        Long executionStartToCloseTimeoutSeconds;
        StartChildWorkflowExecutionParameters startChildWorkflowExecutionParameters = this.clone();
        if (options != null) {
            executionStartToCloseTimeoutSeconds = options.getExecutionStartToCloseTimeoutSeconds();
            if (executionStartToCloseTimeoutSeconds != null) {
                startChildWorkflowExecutionParameters.setExecutionStartToCloseTimeoutSeconds(executionStartToCloseTimeoutSeconds);
            }
            if ((taskStartToCloseTimeoutSeconds = options.getTaskStartToCloseTimeoutSeconds()) != null) {
                startChildWorkflowExecutionParameters.setTaskStartToCloseTimeoutSeconds(taskStartToCloseTimeoutSeconds);
            }
            if ((tagList = options.getTagList()) != null) {
                startChildWorkflowExecutionParameters.setTagList(tagList);
            }
            if ((taskList = options.getTaskList()) != null && !taskList.isEmpty()) {
                startChildWorkflowExecutionParameters.setTaskList(taskList);
            }
            if ((childPolicy = options.getChildPolicy()) != null) {
                startChildWorkflowExecutionParameters.setChildPolicy(childPolicy);
            }
            if ((taskPriority = options.getTaskPriority()) != null) {
                startChildWorkflowExecutionParameters.setTaskPriority(taskPriority);
            }
        }
        if (optionsOverride != null) {
            executionStartToCloseTimeoutSeconds = optionsOverride.getExecutionStartToCloseTimeoutSeconds();
            if (executionStartToCloseTimeoutSeconds != null) {
                startChildWorkflowExecutionParameters.setExecutionStartToCloseTimeoutSeconds(executionStartToCloseTimeoutSeconds);
            }
            if ((taskStartToCloseTimeoutSeconds = optionsOverride.getTaskStartToCloseTimeoutSeconds()) != null) {
                startChildWorkflowExecutionParameters.setTaskStartToCloseTimeoutSeconds(taskStartToCloseTimeoutSeconds);
            }
            if ((tagList = optionsOverride.getTagList()) != null) {
                startChildWorkflowExecutionParameters.setTagList(tagList);
            }
            if ((taskList = optionsOverride.getTaskList()) != null && !taskList.isEmpty()) {
                startChildWorkflowExecutionParameters.setTaskList(taskList);
            }
            if ((childPolicy = optionsOverride.getChildPolicy()) != null) {
                startChildWorkflowExecutionParameters.setChildPolicy(childPolicy);
            }
            if ((taskPriority = optionsOverride.getTaskPriority()) != null) {
                startChildWorkflowExecutionParameters.setTaskPriority(taskPriority);
            }
        }
        return startChildWorkflowExecutionParameters;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("WorkflowType: " + this.workflowType + ", ");
        sb.append("WorkflowId: " + this.workflowId + ", ");
        sb.append("Input: " + this.input + ", ");
        sb.append("Control: " + this.control + ", ");
        sb.append("ExecutionStartToCloseTimeout: " + this.executionStartToCloseTimeoutSeconds + ", ");
        sb.append("TaskStartToCloseTimeout: " + this.taskStartToCloseTimeoutSeconds + ", ");
        sb.append("TagList: " + this.tagList + ", ");
        sb.append("TaskList: " + this.taskList + ", ");
        sb.append("TaskPriority: " + this.taskPriority);
        sb.append("}");
        return sb.toString();
    }

    public StartChildWorkflowExecutionParameters clone() {
        StartChildWorkflowExecutionParameters result = new StartChildWorkflowExecutionParameters();
        result.setControl(this.control);
        result.setExecutionStartToCloseTimeoutSeconds(this.executionStartToCloseTimeoutSeconds);
        result.setInput(this.input);
        result.setTagList(this.tagList);
        result.setTaskList(this.taskList);
        result.setTaskStartToCloseTimeoutSeconds(this.taskStartToCloseTimeoutSeconds);
        result.setWorkflowId(this.workflowId);
        result.setWorkflowType(this.workflowType);
        result.setTaskPriority(this.taskPriority);
        return result;
    }
}

