/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.support.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.support.model.DescribeCasesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DescribeCasesRequestMarshaller
implements Marshaller<Request<DescribeCasesRequest>, DescribeCasesRequest> {
    public Request<DescribeCasesRequest> marshall(DescribeCasesRequest describeCasesRequest) {
        if (describeCasesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeCasesRequest, "AWSSupport");
        request.addHeader("X-Amz-Target", "AWSSupport_20130415.DescribeCases");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            SdkInternalList caseIdListList = (SdkInternalList)describeCasesRequest.getCaseIdList();
            if (!caseIdListList.isEmpty() || !caseIdListList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("caseIdList");
                jsonGenerator.writeStartArray();
                for (String caseIdListListValue : caseIdListList) {
                    if (caseIdListListValue == null) continue;
                    jsonGenerator.writeValue(caseIdListListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (describeCasesRequest.getDisplayId() != null) {
                jsonGenerator.writeFieldName("displayId").writeValue(describeCasesRequest.getDisplayId());
            }
            if (describeCasesRequest.getAfterTime() != null) {
                jsonGenerator.writeFieldName("afterTime").writeValue(describeCasesRequest.getAfterTime());
            }
            if (describeCasesRequest.getBeforeTime() != null) {
                jsonGenerator.writeFieldName("beforeTime").writeValue(describeCasesRequest.getBeforeTime());
            }
            if (describeCasesRequest.getIncludeResolvedCases() != null) {
                jsonGenerator.writeFieldName("includeResolvedCases").writeValue(describeCasesRequest.getIncludeResolvedCases().booleanValue());
            }
            if (describeCasesRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("nextToken").writeValue(describeCasesRequest.getNextToken());
            }
            if (describeCasesRequest.getMaxResults() != null) {
                jsonGenerator.writeFieldName("maxResults").writeValue((long)describeCasesRequest.getMaxResults().intValue());
            }
            if (describeCasesRequest.getLanguage() != null) {
                jsonGenerator.writeFieldName("language").writeValue(describeCasesRequest.getLanguage());
            }
            if (describeCasesRequest.getIncludeCommunications() != null) {
                jsonGenerator.writeFieldName("includeCommunications").writeValue(describeCasesRequest.getIncludeCommunications().booleanValue());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

