/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.support.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.support.model.AttachmentDetails;
import com.amazonaws.services.support.model.Communication;
import com.amazonaws.services.support.model.transform.AttachmentDetailsJsonMarshaller;
import com.amazonaws.util.json.SdkJsonGenerator;

public class CommunicationJsonMarshaller {
    private static CommunicationJsonMarshaller instance;

    public void marshall(Communication communication, SdkJsonGenerator jsonGenerator) {
        if (communication == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList attachmentSetList;
            jsonGenerator.writeStartObject();
            if (communication.getCaseId() != null) {
                jsonGenerator.writeFieldName("caseId").writeValue(communication.getCaseId());
            }
            if (communication.getBody() != null) {
                jsonGenerator.writeFieldName("body").writeValue(communication.getBody());
            }
            if (communication.getSubmittedBy() != null) {
                jsonGenerator.writeFieldName("submittedBy").writeValue(communication.getSubmittedBy());
            }
            if (communication.getTimeCreated() != null) {
                jsonGenerator.writeFieldName("timeCreated").writeValue(communication.getTimeCreated());
            }
            if (!(attachmentSetList = (SdkInternalList)communication.getAttachmentSet()).isEmpty() || !attachmentSetList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("attachmentSet");
                jsonGenerator.writeStartArray();
                for (AttachmentDetails attachmentSetListValue : attachmentSetList) {
                    if (attachmentSetListValue == null) continue;
                    AttachmentDetailsJsonMarshaller.getInstance().marshall(attachmentSetListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static CommunicationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new CommunicationJsonMarshaller();
        }
        return instance;
    }
}

