/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.storagegateway.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.storagegateway.model.Disk;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListLocalDisksResult
implements Serializable {
    private String gatewayARN;
    private ListWithAutoConstructFlag<Disk> disks;

    public String getGatewayARN() {
        return this.gatewayARN;
    }

    public void setGatewayARN(String gatewayARN) {
        this.gatewayARN = gatewayARN;
    }

    public ListLocalDisksResult withGatewayARN(String gatewayARN) {
        this.gatewayARN = gatewayARN;
        return this;
    }

    public List<Disk> getDisks() {
        if (this.disks == null) {
            this.disks = new ListWithAutoConstructFlag();
            this.disks.setAutoConstruct(true);
        }
        return this.disks;
    }

    public void setDisks(Collection<Disk> disks) {
        if (disks == null) {
            this.disks = null;
            return;
        }
        ListWithAutoConstructFlag disksCopy = new ListWithAutoConstructFlag(disks.size());
        disksCopy.addAll(disks);
        this.disks = disksCopy;
    }

    public ListLocalDisksResult withDisks(Disk ... disks) {
        if (this.getDisks() == null) {
            this.setDisks(new ArrayList<Disk>(disks.length));
        }
        for (Disk value : disks) {
            this.getDisks().add(value);
        }
        return this;
    }

    public ListLocalDisksResult withDisks(Collection<Disk> disks) {
        if (disks == null) {
            this.disks = null;
        } else {
            ListWithAutoConstructFlag disksCopy = new ListWithAutoConstructFlag(disks.size());
            disksCopy.addAll(disks);
            this.disks = disksCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getGatewayARN() != null) {
            sb.append("GatewayARN: " + this.getGatewayARN() + ",");
        }
        if (this.getDisks() != null) {
            sb.append("Disks: " + this.getDisks());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getGatewayARN() == null ? 0 : this.getGatewayARN().hashCode());
        hashCode = 31 * hashCode + (this.getDisks() == null ? 0 : this.getDisks().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLocalDisksResult)) {
            return false;
        }
        ListLocalDisksResult other = (ListLocalDisksResult)obj;
        if (other.getGatewayARN() == null ^ this.getGatewayARN() == null) {
            return false;
        }
        if (other.getGatewayARN() != null && !other.getGatewayARN().equals(this.getGatewayARN())) {
            return false;
        }
        if (other.getDisks() == null ^ this.getDisks() == null) {
            return false;
        }
        return other.getDisks() == null || other.getDisks().equals(this.getDisks());
    }
}

