/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.storagegateway.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.storagegateway.model.CreateStorediSCSIVolumeRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class CreateStorediSCSIVolumeRequestMarshaller
implements Marshaller<Request<CreateStorediSCSIVolumeRequest>, CreateStorediSCSIVolumeRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreateStorediSCSIVolumeRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<CreateStorediSCSIVolumeRequest> marshall(CreateStorediSCSIVolumeRequest createStorediSCSIVolumeRequest) {
        if (createStorediSCSIVolumeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createStorediSCSIVolumeRequest, "AWSStorageGateway");
        request.addHeader("X-Amz-Target", "StorageGateway_20130630.CreateStorediSCSIVolume");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createStorediSCSIVolumeRequest.getGatewayARN() != null) {
                jsonGenerator.writeFieldName("GatewayARN").writeValue(createStorediSCSIVolumeRequest.getGatewayARN());
            }
            if (createStorediSCSIVolumeRequest.getDiskId() != null) {
                jsonGenerator.writeFieldName("DiskId").writeValue(createStorediSCSIVolumeRequest.getDiskId());
            }
            if (createStorediSCSIVolumeRequest.getSnapshotId() != null) {
                jsonGenerator.writeFieldName("SnapshotId").writeValue(createStorediSCSIVolumeRequest.getSnapshotId());
            }
            if (createStorediSCSIVolumeRequest.getPreserveExistingData() != null) {
                jsonGenerator.writeFieldName("PreserveExistingData").writeValue(createStorediSCSIVolumeRequest.getPreserveExistingData().booleanValue());
            }
            if (createStorediSCSIVolumeRequest.getTargetName() != null) {
                jsonGenerator.writeFieldName("TargetName").writeValue(createStorediSCSIVolumeRequest.getTargetName());
            }
            if (createStorediSCSIVolumeRequest.getNetworkInterfaceId() != null) {
                jsonGenerator.writeFieldName("NetworkInterfaceId").writeValue(createStorediSCSIVolumeRequest.getNetworkInterfaceId());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

