/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.storagegateway;

import javax.annotation.Generated;

import com.amazonaws.services.storagegateway.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AWSStorageGateway}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSStorageGateway implements AWSStorageGateway {

    protected AbstractAWSStorageGateway() {
    }

    @Override
    public void setEndpoint(String endpoint) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void setRegion(com.amazonaws.regions.Region region) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ActivateGatewayResult activateGateway(ActivateGatewayRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AddCacheResult addCache(AddCacheRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AddTagsToResourceResult addTagsToResource(AddTagsToResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AddUploadBufferResult addUploadBuffer(AddUploadBufferRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AddWorkingStorageResult addWorkingStorage(AddWorkingStorageRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AttachVolumeResult attachVolume(AttachVolumeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CancelArchivalResult cancelArchival(CancelArchivalRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CancelRetrievalResult cancelRetrieval(CancelRetrievalRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateCachediSCSIVolumeResult createCachediSCSIVolume(CreateCachediSCSIVolumeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateNFSFileShareResult createNFSFileShare(CreateNFSFileShareRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateSMBFileShareResult createSMBFileShare(CreateSMBFileShareRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateSnapshotResult createSnapshot(CreateSnapshotRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateSnapshotFromVolumeRecoveryPointResult createSnapshotFromVolumeRecoveryPoint(CreateSnapshotFromVolumeRecoveryPointRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateStorediSCSIVolumeResult createStorediSCSIVolume(CreateStorediSCSIVolumeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateTapeWithBarcodeResult createTapeWithBarcode(CreateTapeWithBarcodeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateTapesResult createTapes(CreateTapesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteBandwidthRateLimitResult deleteBandwidthRateLimit(DeleteBandwidthRateLimitRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteChapCredentialsResult deleteChapCredentials(DeleteChapCredentialsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteFileShareResult deleteFileShare(DeleteFileShareRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteGatewayResult deleteGateway(DeleteGatewayRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteSnapshotScheduleResult deleteSnapshotSchedule(DeleteSnapshotScheduleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteTapeResult deleteTape(DeleteTapeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteTapeArchiveResult deleteTapeArchive(DeleteTapeArchiveRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteVolumeResult deleteVolume(DeleteVolumeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeBandwidthRateLimitResult describeBandwidthRateLimit(DescribeBandwidthRateLimitRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeCacheResult describeCache(DescribeCacheRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeCachediSCSIVolumesResult describeCachediSCSIVolumes(DescribeCachediSCSIVolumesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeChapCredentialsResult describeChapCredentials(DescribeChapCredentialsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeGatewayInformationResult describeGatewayInformation(DescribeGatewayInformationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeMaintenanceStartTimeResult describeMaintenanceStartTime(DescribeMaintenanceStartTimeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeNFSFileSharesResult describeNFSFileShares(DescribeNFSFileSharesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeSMBFileSharesResult describeSMBFileShares(DescribeSMBFileSharesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeSMBSettingsResult describeSMBSettings(DescribeSMBSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeSnapshotScheduleResult describeSnapshotSchedule(DescribeSnapshotScheduleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeStorediSCSIVolumesResult describeStorediSCSIVolumes(DescribeStorediSCSIVolumesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeTapeArchivesResult describeTapeArchives(DescribeTapeArchivesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeTapeArchivesResult describeTapeArchives() {
        return describeTapeArchives(new DescribeTapeArchivesRequest());
    }

    @Override
    public DescribeTapeRecoveryPointsResult describeTapeRecoveryPoints(DescribeTapeRecoveryPointsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeTapesResult describeTapes(DescribeTapesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeUploadBufferResult describeUploadBuffer(DescribeUploadBufferRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeVTLDevicesResult describeVTLDevices(DescribeVTLDevicesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeWorkingStorageResult describeWorkingStorage(DescribeWorkingStorageRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DetachVolumeResult detachVolume(DetachVolumeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisableGatewayResult disableGateway(DisableGatewayRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public JoinDomainResult joinDomain(JoinDomainRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListFileSharesResult listFileShares(ListFileSharesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListGatewaysResult listGateways(ListGatewaysRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListGatewaysResult listGateways() {
        return listGateways(new ListGatewaysRequest());
    }

    @Override
    public ListLocalDisksResult listLocalDisks(ListLocalDisksRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource() {
        return listTagsForResource(new ListTagsForResourceRequest());
    }

    @Override
    public ListTapesResult listTapes(ListTapesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListVolumeInitiatorsResult listVolumeInitiators(ListVolumeInitiatorsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListVolumeRecoveryPointsResult listVolumeRecoveryPoints(ListVolumeRecoveryPointsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListVolumesResult listVolumes(ListVolumesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public NotifyWhenUploadedResult notifyWhenUploaded(NotifyWhenUploadedRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RefreshCacheResult refreshCache(RefreshCacheRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RemoveTagsFromResourceResult removeTagsFromResource(RemoveTagsFromResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RemoveTagsFromResourceResult removeTagsFromResource() {
        return removeTagsFromResource(new RemoveTagsFromResourceRequest());
    }

    @Override
    public ResetCacheResult resetCache(ResetCacheRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RetrieveTapeArchiveResult retrieveTapeArchive(RetrieveTapeArchiveRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RetrieveTapeRecoveryPointResult retrieveTapeRecoveryPoint(RetrieveTapeRecoveryPointRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SetLocalConsolePasswordResult setLocalConsolePassword(SetLocalConsolePasswordRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SetSMBGuestPasswordResult setSMBGuestPassword(SetSMBGuestPasswordRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ShutdownGatewayResult shutdownGateway(ShutdownGatewayRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartGatewayResult startGateway(StartGatewayRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateBandwidthRateLimitResult updateBandwidthRateLimit(UpdateBandwidthRateLimitRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateChapCredentialsResult updateChapCredentials(UpdateChapCredentialsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateGatewayInformationResult updateGatewayInformation(UpdateGatewayInformationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateGatewaySoftwareNowResult updateGatewaySoftwareNow(UpdateGatewaySoftwareNowRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateMaintenanceStartTimeResult updateMaintenanceStartTime(UpdateMaintenanceStartTimeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateNFSFileShareResult updateNFSFileShare(UpdateNFSFileShareRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateSMBFileShareResult updateSMBFileShare(UpdateSMBFileShareRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateSnapshotScheduleResult updateSnapshotSchedule(UpdateSnapshotScheduleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateVTLDeviceTypeResult updateVTLDeviceType(UpdateVTLDeviceTypeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
