/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.storagegateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.storagegateway.model.NetworkInterface;
import com.amazonaws.util.json.StructuredJsonGenerator;

public class NetworkInterfaceJsonMarshaller {
    private static NetworkInterfaceJsonMarshaller instance;

    public void marshall(NetworkInterface networkInterface, StructuredJsonGenerator jsonGenerator) {
        if (networkInterface == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (networkInterface.getIpv4Address() != null) {
                jsonGenerator.writeFieldName("Ipv4Address").writeValue(networkInterface.getIpv4Address());
            }
            if (networkInterface.getMacAddress() != null) {
                jsonGenerator.writeFieldName("MacAddress").writeValue(networkInterface.getMacAddress());
            }
            if (networkInterface.getIpv6Address() != null) {
                jsonGenerator.writeFieldName("Ipv6Address").writeValue(networkInterface.getIpv6Address());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static NetworkInterfaceJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new NetworkInterfaceJsonMarshaller();
        }
        return instance;
    }
}

