/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ssooidc;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.ssooidc.AWSSSOOIDCAsync;
import com.amazonaws.services.ssooidc.AWSSSOOIDCAsyncClientBuilder;
import com.amazonaws.services.ssooidc.AWSSSOOIDCClient;
import com.amazonaws.services.ssooidc.model.CreateTokenRequest;
import com.amazonaws.services.ssooidc.model.CreateTokenResult;
import com.amazonaws.services.ssooidc.model.CreateTokenWithIAMRequest;
import com.amazonaws.services.ssooidc.model.CreateTokenWithIAMResult;
import com.amazonaws.services.ssooidc.model.RegisterClientRequest;
import com.amazonaws.services.ssooidc.model.RegisterClientResult;
import com.amazonaws.services.ssooidc.model.StartDeviceAuthorizationRequest;
import com.amazonaws.services.ssooidc.model.StartDeviceAuthorizationResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSSSOOIDCAsyncClient
extends AWSSSOOIDCClient
implements AWSSSOOIDCAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSSSOOIDCAsyncClientBuilder asyncBuilder() {
        return AWSSSOOIDCAsyncClientBuilder.standard();
    }

    AWSSSOOIDCAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSSSOOIDCAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateTokenResult> createTokenAsync(CreateTokenRequest request) {
        return this.createTokenAsync(request, null);
    }

    @Override
    public Future<CreateTokenResult> createTokenAsync(CreateTokenRequest request, final AsyncHandler<CreateTokenRequest, CreateTokenResult> asyncHandler) {
        final CreateTokenRequest finalRequest = (CreateTokenRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateTokenResult>(){

            @Override
            public CreateTokenResult call() throws Exception {
                CreateTokenResult result = null;
                try {
                    result = AWSSSOOIDCAsyncClient.this.executeCreateToken(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateTokenWithIAMResult> createTokenWithIAMAsync(CreateTokenWithIAMRequest request) {
        return this.createTokenWithIAMAsync(request, null);
    }

    @Override
    public Future<CreateTokenWithIAMResult> createTokenWithIAMAsync(CreateTokenWithIAMRequest request, final AsyncHandler<CreateTokenWithIAMRequest, CreateTokenWithIAMResult> asyncHandler) {
        final CreateTokenWithIAMRequest finalRequest = (CreateTokenWithIAMRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateTokenWithIAMResult>(){

            @Override
            public CreateTokenWithIAMResult call() throws Exception {
                CreateTokenWithIAMResult result = null;
                try {
                    result = AWSSSOOIDCAsyncClient.this.executeCreateTokenWithIAM(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RegisterClientResult> registerClientAsync(RegisterClientRequest request) {
        return this.registerClientAsync(request, null);
    }

    @Override
    public Future<RegisterClientResult> registerClientAsync(RegisterClientRequest request, final AsyncHandler<RegisterClientRequest, RegisterClientResult> asyncHandler) {
        final RegisterClientRequest finalRequest = (RegisterClientRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RegisterClientResult>(){

            @Override
            public RegisterClientResult call() throws Exception {
                RegisterClientResult result = null;
                try {
                    result = AWSSSOOIDCAsyncClient.this.executeRegisterClient(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartDeviceAuthorizationResult> startDeviceAuthorizationAsync(StartDeviceAuthorizationRequest request) {
        return this.startDeviceAuthorizationAsync(request, null);
    }

    @Override
    public Future<StartDeviceAuthorizationResult> startDeviceAuthorizationAsync(StartDeviceAuthorizationRequest request, final AsyncHandler<StartDeviceAuthorizationRequest, StartDeviceAuthorizationResult> asyncHandler) {
        final StartDeviceAuthorizationRequest finalRequest = (StartDeviceAuthorizationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartDeviceAuthorizationResult>(){

            @Override
            public StartDeviceAuthorizationResult call() throws Exception {
                StartDeviceAuthorizationResult result = null;
                try {
                    result = AWSSSOOIDCAsyncClient.this.executeStartDeviceAuthorization(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

