/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ssmsap;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.ssmsap.AWSSsmSap;
import com.amazonaws.services.ssmsap.AWSSsmSapClientBuilder;
import com.amazonaws.services.ssmsap.model.AWSSsmSapException;
import com.amazonaws.services.ssmsap.model.DeleteResourcePermissionRequest;
import com.amazonaws.services.ssmsap.model.DeleteResourcePermissionResult;
import com.amazonaws.services.ssmsap.model.DeregisterApplicationRequest;
import com.amazonaws.services.ssmsap.model.DeregisterApplicationResult;
import com.amazonaws.services.ssmsap.model.GetApplicationRequest;
import com.amazonaws.services.ssmsap.model.GetApplicationResult;
import com.amazonaws.services.ssmsap.model.GetComponentRequest;
import com.amazonaws.services.ssmsap.model.GetComponentResult;
import com.amazonaws.services.ssmsap.model.GetDatabaseRequest;
import com.amazonaws.services.ssmsap.model.GetDatabaseResult;
import com.amazonaws.services.ssmsap.model.GetOperationRequest;
import com.amazonaws.services.ssmsap.model.GetOperationResult;
import com.amazonaws.services.ssmsap.model.GetResourcePermissionRequest;
import com.amazonaws.services.ssmsap.model.GetResourcePermissionResult;
import com.amazonaws.services.ssmsap.model.ListApplicationsRequest;
import com.amazonaws.services.ssmsap.model.ListApplicationsResult;
import com.amazonaws.services.ssmsap.model.ListComponentsRequest;
import com.amazonaws.services.ssmsap.model.ListComponentsResult;
import com.amazonaws.services.ssmsap.model.ListDatabasesRequest;
import com.amazonaws.services.ssmsap.model.ListDatabasesResult;
import com.amazonaws.services.ssmsap.model.ListOperationsRequest;
import com.amazonaws.services.ssmsap.model.ListOperationsResult;
import com.amazonaws.services.ssmsap.model.ListTagsForResourceRequest;
import com.amazonaws.services.ssmsap.model.ListTagsForResourceResult;
import com.amazonaws.services.ssmsap.model.PutResourcePermissionRequest;
import com.amazonaws.services.ssmsap.model.PutResourcePermissionResult;
import com.amazonaws.services.ssmsap.model.RegisterApplicationRequest;
import com.amazonaws.services.ssmsap.model.RegisterApplicationResult;
import com.amazonaws.services.ssmsap.model.StartApplicationRefreshRequest;
import com.amazonaws.services.ssmsap.model.StartApplicationRefreshResult;
import com.amazonaws.services.ssmsap.model.TagResourceRequest;
import com.amazonaws.services.ssmsap.model.TagResourceResult;
import com.amazonaws.services.ssmsap.model.UntagResourceRequest;
import com.amazonaws.services.ssmsap.model.UntagResourceResult;
import com.amazonaws.services.ssmsap.model.UpdateApplicationSettingsRequest;
import com.amazonaws.services.ssmsap.model.UpdateApplicationSettingsResult;
import com.amazonaws.services.ssmsap.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.ssmsap.model.transform.DeleteResourcePermissionRequestProtocolMarshaller;
import com.amazonaws.services.ssmsap.model.transform.DeleteResourcePermissionResultJsonUnmarshaller;
import com.amazonaws.services.ssmsap.model.transform.DeregisterApplicationRequestProtocolMarshaller;
import com.amazonaws.services.ssmsap.model.transform.DeregisterApplicationResultJsonUnmarshaller;
import com.amazonaws.services.ssmsap.model.transform.GetApplicationRequestProtocolMarshaller;
import com.amazonaws.services.ssmsap.model.transform.GetApplicationResultJsonUnmarshaller;
import com.amazonaws.services.ssmsap.model.transform.GetComponentRequestProtocolMarshaller;
import com.amazonaws.services.ssmsap.model.transform.GetComponentResultJsonUnmarshaller;
import com.amazonaws.services.ssmsap.model.transform.GetDatabaseRequestProtocolMarshaller;
import com.amazonaws.services.ssmsap.model.transform.GetDatabaseResultJsonUnmarshaller;
import com.amazonaws.services.ssmsap.model.transform.GetOperationRequestProtocolMarshaller;
import com.amazonaws.services.ssmsap.model.transform.GetOperationResultJsonUnmarshaller;
import com.amazonaws.services.ssmsap.model.transform.GetResourcePermissionRequestProtocolMarshaller;
import com.amazonaws.services.ssmsap.model.transform.GetResourcePermissionResultJsonUnmarshaller;
import com.amazonaws.services.ssmsap.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.ssmsap.model.transform.ListApplicationsRequestProtocolMarshaller;
import com.amazonaws.services.ssmsap.model.transform.ListApplicationsResultJsonUnmarshaller;
import com.amazonaws.services.ssmsap.model.transform.ListComponentsRequestProtocolMarshaller;
import com.amazonaws.services.ssmsap.model.transform.ListComponentsResultJsonUnmarshaller;
import com.amazonaws.services.ssmsap.model.transform.ListDatabasesRequestProtocolMarshaller;
import com.amazonaws.services.ssmsap.model.transform.ListDatabasesResultJsonUnmarshaller;
import com.amazonaws.services.ssmsap.model.transform.ListOperationsRequestProtocolMarshaller;
import com.amazonaws.services.ssmsap.model.transform.ListOperationsResultJsonUnmarshaller;
import com.amazonaws.services.ssmsap.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.ssmsap.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.ssmsap.model.transform.PutResourcePermissionRequestProtocolMarshaller;
import com.amazonaws.services.ssmsap.model.transform.PutResourcePermissionResultJsonUnmarshaller;
import com.amazonaws.services.ssmsap.model.transform.RegisterApplicationRequestProtocolMarshaller;
import com.amazonaws.services.ssmsap.model.transform.RegisterApplicationResultJsonUnmarshaller;
import com.amazonaws.services.ssmsap.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.ssmsap.model.transform.StartApplicationRefreshRequestProtocolMarshaller;
import com.amazonaws.services.ssmsap.model.transform.StartApplicationRefreshResultJsonUnmarshaller;
import com.amazonaws.services.ssmsap.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.ssmsap.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.ssmsap.model.transform.UnauthorizedExceptionUnmarshaller;
import com.amazonaws.services.ssmsap.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.ssmsap.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.ssmsap.model.transform.UpdateApplicationSettingsRequestProtocolMarshaller;
import com.amazonaws.services.ssmsap.model.transform.UpdateApplicationSettingsResultJsonUnmarshaller;
import com.amazonaws.services.ssmsap.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSSsmSapClient
extends AmazonWebServiceClient
implements AWSSsmSap {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSSsmSap.class);
    private static final String DEFAULT_SIGNING_NAME = "ssm-sap";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("application/json").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnauthorizedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)UnauthorizedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSSsmSapException.class));

    public static AWSSsmSapClientBuilder builder() {
        return AWSSsmSapClientBuilder.standard();
    }

    AWSSsmSapClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSSsmSapClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("ssm-sap.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/ssmsap/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/ssmsap/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public DeleteResourcePermissionResult deleteResourcePermission(DeleteResourcePermissionRequest request) {
        request = (DeleteResourcePermissionRequest)this.beforeClientExecution(request);
        return this.executeDeleteResourcePermission(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteResourcePermissionResult executeDeleteResourcePermission(DeleteResourcePermissionRequest deleteResourcePermissionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteResourcePermissionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteResourcePermissionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteResourcePermissionRequestProtocolMarshaller(protocolFactory).marshall((DeleteResourcePermissionRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteResourcePermissionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Ssm Sap");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteResourcePermission");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteResourcePermissionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteResourcePermissionResult deleteResourcePermissionResult = (DeleteResourcePermissionResult)response.getAwsResponse();
            return deleteResourcePermissionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeregisterApplicationResult deregisterApplication(DeregisterApplicationRequest request) {
        request = (DeregisterApplicationRequest)this.beforeClientExecution(request);
        return this.executeDeregisterApplication(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeregisterApplicationResult executeDeregisterApplication(DeregisterApplicationRequest deregisterApplicationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deregisterApplicationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeregisterApplicationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeregisterApplicationRequestProtocolMarshaller(protocolFactory).marshall((DeregisterApplicationRequest)super.beforeMarshalling((AmazonWebServiceRequest)deregisterApplicationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Ssm Sap");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeregisterApplication");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeregisterApplicationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeregisterApplicationResult deregisterApplicationResult = (DeregisterApplicationResult)response.getAwsResponse();
            return deregisterApplicationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetApplicationResult getApplication(GetApplicationRequest request) {
        request = (GetApplicationRequest)this.beforeClientExecution(request);
        return this.executeGetApplication(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetApplicationResult executeGetApplication(GetApplicationRequest getApplicationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getApplicationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetApplicationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetApplicationRequestProtocolMarshaller(protocolFactory).marshall((GetApplicationRequest)super.beforeMarshalling((AmazonWebServiceRequest)getApplicationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Ssm Sap");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetApplication");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetApplicationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetApplicationResult getApplicationResult = (GetApplicationResult)response.getAwsResponse();
            return getApplicationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetComponentResult getComponent(GetComponentRequest request) {
        request = (GetComponentRequest)this.beforeClientExecution(request);
        return this.executeGetComponent(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetComponentResult executeGetComponent(GetComponentRequest getComponentRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getComponentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetComponentRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetComponentRequestProtocolMarshaller(protocolFactory).marshall((GetComponentRequest)super.beforeMarshalling((AmazonWebServiceRequest)getComponentRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Ssm Sap");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetComponent");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetComponentResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetComponentResult getComponentResult = (GetComponentResult)response.getAwsResponse();
            return getComponentResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetDatabaseResult getDatabase(GetDatabaseRequest request) {
        request = (GetDatabaseRequest)this.beforeClientExecution(request);
        return this.executeGetDatabase(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetDatabaseResult executeGetDatabase(GetDatabaseRequest getDatabaseRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getDatabaseRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetDatabaseRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetDatabaseRequestProtocolMarshaller(protocolFactory).marshall((GetDatabaseRequest)super.beforeMarshalling((AmazonWebServiceRequest)getDatabaseRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Ssm Sap");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetDatabase");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetDatabaseResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetDatabaseResult getDatabaseResult = (GetDatabaseResult)response.getAwsResponse();
            return getDatabaseResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetOperationResult getOperation(GetOperationRequest request) {
        request = (GetOperationRequest)this.beforeClientExecution(request);
        return this.executeGetOperation(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetOperationResult executeGetOperation(GetOperationRequest getOperationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getOperationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetOperationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetOperationRequestProtocolMarshaller(protocolFactory).marshall((GetOperationRequest)super.beforeMarshalling((AmazonWebServiceRequest)getOperationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Ssm Sap");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetOperation");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetOperationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetOperationResult getOperationResult = (GetOperationResult)response.getAwsResponse();
            return getOperationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetResourcePermissionResult getResourcePermission(GetResourcePermissionRequest request) {
        request = (GetResourcePermissionRequest)this.beforeClientExecution(request);
        return this.executeGetResourcePermission(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetResourcePermissionResult executeGetResourcePermission(GetResourcePermissionRequest getResourcePermissionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getResourcePermissionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetResourcePermissionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetResourcePermissionRequestProtocolMarshaller(protocolFactory).marshall((GetResourcePermissionRequest)super.beforeMarshalling((AmazonWebServiceRequest)getResourcePermissionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Ssm Sap");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetResourcePermission");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetResourcePermissionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetResourcePermissionResult getResourcePermissionResult = (GetResourcePermissionResult)response.getAwsResponse();
            return getResourcePermissionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListApplicationsResult listApplications(ListApplicationsRequest request) {
        request = (ListApplicationsRequest)this.beforeClientExecution(request);
        return this.executeListApplications(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListApplicationsResult executeListApplications(ListApplicationsRequest listApplicationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listApplicationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListApplicationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListApplicationsRequestProtocolMarshaller(protocolFactory).marshall((ListApplicationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listApplicationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Ssm Sap");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListApplications");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListApplicationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListApplicationsResult listApplicationsResult = (ListApplicationsResult)response.getAwsResponse();
            return listApplicationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListComponentsResult listComponents(ListComponentsRequest request) {
        request = (ListComponentsRequest)this.beforeClientExecution(request);
        return this.executeListComponents(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListComponentsResult executeListComponents(ListComponentsRequest listComponentsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listComponentsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListComponentsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListComponentsRequestProtocolMarshaller(protocolFactory).marshall((ListComponentsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listComponentsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Ssm Sap");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListComponents");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListComponentsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListComponentsResult listComponentsResult = (ListComponentsResult)response.getAwsResponse();
            return listComponentsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListDatabasesResult listDatabases(ListDatabasesRequest request) {
        request = (ListDatabasesRequest)this.beforeClientExecution(request);
        return this.executeListDatabases(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListDatabasesResult executeListDatabases(ListDatabasesRequest listDatabasesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listDatabasesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListDatabasesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListDatabasesRequestProtocolMarshaller(protocolFactory).marshall((ListDatabasesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listDatabasesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Ssm Sap");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListDatabases");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListDatabasesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListDatabasesResult listDatabasesResult = (ListDatabasesResult)response.getAwsResponse();
            return listDatabasesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListOperationsResult listOperations(ListOperationsRequest request) {
        request = (ListOperationsRequest)this.beforeClientExecution(request);
        return this.executeListOperations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListOperationsResult executeListOperations(ListOperationsRequest listOperationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listOperationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListOperationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListOperationsRequestProtocolMarshaller(protocolFactory).marshall((ListOperationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listOperationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Ssm Sap");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListOperations");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListOperationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListOperationsResult listOperationsResult = (ListOperationsResult)response.getAwsResponse();
            return listOperationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Ssm Sap");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutResourcePermissionResult putResourcePermission(PutResourcePermissionRequest request) {
        request = (PutResourcePermissionRequest)this.beforeClientExecution(request);
        return this.executePutResourcePermission(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutResourcePermissionResult executePutResourcePermission(PutResourcePermissionRequest putResourcePermissionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putResourcePermissionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutResourcePermissionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutResourcePermissionRequestProtocolMarshaller(protocolFactory).marshall((PutResourcePermissionRequest)super.beforeMarshalling((AmazonWebServiceRequest)putResourcePermissionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Ssm Sap");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutResourcePermission");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutResourcePermissionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutResourcePermissionResult putResourcePermissionResult = (PutResourcePermissionResult)response.getAwsResponse();
            return putResourcePermissionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public RegisterApplicationResult registerApplication(RegisterApplicationRequest request) {
        request = (RegisterApplicationRequest)this.beforeClientExecution(request);
        return this.executeRegisterApplication(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final RegisterApplicationResult executeRegisterApplication(RegisterApplicationRequest registerApplicationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(registerApplicationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RegisterApplicationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RegisterApplicationRequestProtocolMarshaller(protocolFactory).marshall((RegisterApplicationRequest)super.beforeMarshalling((AmazonWebServiceRequest)registerApplicationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Ssm Sap");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"RegisterApplication");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RegisterApplicationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            RegisterApplicationResult registerApplicationResult = (RegisterApplicationResult)response.getAwsResponse();
            return registerApplicationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartApplicationRefreshResult startApplicationRefresh(StartApplicationRefreshRequest request) {
        request = (StartApplicationRefreshRequest)this.beforeClientExecution(request);
        return this.executeStartApplicationRefresh(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartApplicationRefreshResult executeStartApplicationRefresh(StartApplicationRefreshRequest startApplicationRefreshRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startApplicationRefreshRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartApplicationRefreshRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartApplicationRefreshRequestProtocolMarshaller(protocolFactory).marshall((StartApplicationRefreshRequest)super.beforeMarshalling((AmazonWebServiceRequest)startApplicationRefreshRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Ssm Sap");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StartApplicationRefresh");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartApplicationRefreshResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartApplicationRefreshResult startApplicationRefreshResult = (StartApplicationRefreshResult)response.getAwsResponse();
            return startApplicationRefreshResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall((TagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Ssm Sap");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall((UntagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Ssm Sap");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateApplicationSettingsResult updateApplicationSettings(UpdateApplicationSettingsRequest request) {
        request = (UpdateApplicationSettingsRequest)this.beforeClientExecution(request);
        return this.executeUpdateApplicationSettings(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateApplicationSettingsResult executeUpdateApplicationSettings(UpdateApplicationSettingsRequest updateApplicationSettingsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateApplicationSettingsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateApplicationSettingsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateApplicationSettingsRequestProtocolMarshaller(protocolFactory).marshall((UpdateApplicationSettingsRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateApplicationSettingsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Ssm Sap");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateApplicationSettings");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateApplicationSettingsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateApplicationSettingsResult updateApplicationSettingsResult = (UpdateApplicationSettingsResult)response.getAwsResponse();
            return updateApplicationSettingsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

