/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.simplesystemsmanagement.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.simplesystemsmanagement.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * InventoryDeletionStatusItem JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class InventoryDeletionStatusItemJsonUnmarshaller implements Unmarshaller<InventoryDeletionStatusItem, JsonUnmarshallerContext> {

    public InventoryDeletionStatusItem unmarshall(JsonUnmarshallerContext context) throws Exception {
        InventoryDeletionStatusItem inventoryDeletionStatusItem = new InventoryDeletionStatusItem();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("DeletionId", targetDepth)) {
                    context.nextToken();
                    inventoryDeletionStatusItem.setDeletionId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("TypeName", targetDepth)) {
                    context.nextToken();
                    inventoryDeletionStatusItem.setTypeName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("DeletionStartTime", targetDepth)) {
                    context.nextToken();
                    inventoryDeletionStatusItem.setDeletionStartTime(DateJsonUnmarshallerFactory.getInstance("unixTimestamp").unmarshall(context));
                }
                if (context.testExpression("LastStatus", targetDepth)) {
                    context.nextToken();
                    inventoryDeletionStatusItem.setLastStatus(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("LastStatusMessage", targetDepth)) {
                    context.nextToken();
                    inventoryDeletionStatusItem.setLastStatusMessage(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("DeletionSummary", targetDepth)) {
                    context.nextToken();
                    inventoryDeletionStatusItem.setDeletionSummary(InventoryDeletionSummaryJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("LastStatusUpdateTime", targetDepth)) {
                    context.nextToken();
                    inventoryDeletionStatusItem.setLastStatusUpdateTime(DateJsonUnmarshallerFactory.getInstance("unixTimestamp").unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return inventoryDeletionStatusItem;
    }

    private static InventoryDeletionStatusItemJsonUnmarshaller instance;

    public static InventoryDeletionStatusItemJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new InventoryDeletionStatusItemJsonUnmarshaller();
        return instance;
    }
}
