/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.simplesystemsmanagement.model.transform;

import java.util.Map;
import java.util.List;
import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.simplesystemsmanagement.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * StartChangeRequestExecutionRequestMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class StartChangeRequestExecutionRequestMarshaller {

    private static final MarshallingInfo<java.util.Date> SCHEDULEDTIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ScheduledTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> DOCUMENTNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DocumentName").build();
    private static final MarshallingInfo<String> DOCUMENTVERSION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DocumentVersion").build();
    private static final MarshallingInfo<Map> PARAMETERS_BINDING = MarshallingInfo.builder(MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("Parameters").build();
    private static final MarshallingInfo<String> CHANGEREQUESTNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ChangeRequestName").build();
    private static final MarshallingInfo<String> CLIENTTOKEN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClientToken").build();
    private static final MarshallingInfo<Boolean> AUTOAPPROVE_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AutoApprove").build();
    private static final MarshallingInfo<List> RUNBOOKS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("Runbooks").build();
    private static final MarshallingInfo<List> TAGS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("Tags").build();
    private static final MarshallingInfo<java.util.Date> SCHEDULEDENDTIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ScheduledEndTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> CHANGEDETAILS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ChangeDetails").build();

    private static final StartChangeRequestExecutionRequestMarshaller instance = new StartChangeRequestExecutionRequestMarshaller();

    public static StartChangeRequestExecutionRequestMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(StartChangeRequestExecutionRequest startChangeRequestExecutionRequest, ProtocolMarshaller protocolMarshaller) {

        if (startChangeRequestExecutionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(startChangeRequestExecutionRequest.getScheduledTime(), SCHEDULEDTIME_BINDING);
            protocolMarshaller.marshall(startChangeRequestExecutionRequest.getDocumentName(), DOCUMENTNAME_BINDING);
            protocolMarshaller.marshall(startChangeRequestExecutionRequest.getDocumentVersion(), DOCUMENTVERSION_BINDING);
            protocolMarshaller.marshall(startChangeRequestExecutionRequest.getParameters(), PARAMETERS_BINDING);
            protocolMarshaller.marshall(startChangeRequestExecutionRequest.getChangeRequestName(), CHANGEREQUESTNAME_BINDING);
            protocolMarshaller.marshall(startChangeRequestExecutionRequest.getClientToken(), CLIENTTOKEN_BINDING);
            protocolMarshaller.marshall(startChangeRequestExecutionRequest.getAutoApprove(), AUTOAPPROVE_BINDING);
            protocolMarshaller.marshall(startChangeRequestExecutionRequest.getRunbooks(), RUNBOOKS_BINDING);
            protocolMarshaller.marshall(startChangeRequestExecutionRequest.getTags(), TAGS_BINDING);
            protocolMarshaller.marshall(startChangeRequestExecutionRequest.getScheduledEndTime(), SCHEDULEDENDTIME_BINDING);
            protocolMarshaller.marshall(startChangeRequestExecutionRequest.getChangeDetails(), CHANGEDETAILS_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
