/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.buffered;

import com.amazonaws.AmazonClientException;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.sqs.AmazonSQSAsync;
import com.amazonaws.services.sqs.buffered.QueueBufferCallback;
import com.amazonaws.services.sqs.buffered.QueueBufferConfig;
import com.amazonaws.services.sqs.buffered.QueueBufferFuture;
import com.amazonaws.services.sqs.buffered.ReceiveQueueBuffer;
import com.amazonaws.services.sqs.buffered.SendQueueBuffer;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityRequest;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityResult;
import com.amazonaws.services.sqs.model.DeleteMessageRequest;
import com.amazonaws.services.sqs.model.DeleteMessageResult;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import com.amazonaws.services.sqs.model.ReceiveMessageResult;
import com.amazonaws.services.sqs.model.SendMessageRequest;
import com.amazonaws.services.sqs.model.SendMessageResult;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

class QueueBuffer {
    private final SendQueueBuffer sendBuffer;
    private final ReceiveQueueBuffer receiveBuffer;
    private final AmazonSQSAsync realSqs;
    QueueBufferConfig config;
    static ExecutorService executor = Executors.newCachedThreadPool(new DaemonThreadFactory());

    QueueBuffer(QueueBufferConfig paramConfig, String url, AmazonSQSAsync sqs) {
        this.realSqs = sqs;
        this.config = paramConfig;
        this.sendBuffer = new SendQueueBuffer(sqs, executor, paramConfig, url);
        this.receiveBuffer = new ReceiveQueueBuffer(sqs, executor, paramConfig, url);
    }

    public Future<SendMessageResult> sendMessage(SendMessageRequest request, AsyncHandler<SendMessageRequest, SendMessageResult> handler) {
        QueueBufferCallback<SendMessageRequest, SendMessageResult> callback = null;
        if (handler != null) {
            callback = new QueueBufferCallback<SendMessageRequest, SendMessageResult>(handler, request);
        }
        QueueBufferFuture<SendMessageRequest, SendMessageResult> future = this.sendBuffer.sendMessage(request, callback);
        future.setBuffer(this);
        return future;
    }

    public SendMessageResult sendMessageSync(SendMessageRequest request) {
        Future<SendMessageResult> future = this.sendMessage(request, null);
        return this.waitForFuture(future);
    }

    public Future<DeleteMessageResult> deleteMessage(DeleteMessageRequest request, AsyncHandler<DeleteMessageRequest, DeleteMessageResult> handler) {
        QueueBufferCallback<DeleteMessageRequest, DeleteMessageResult> callback = null;
        if (handler != null) {
            callback = new QueueBufferCallback<DeleteMessageRequest, DeleteMessageResult>(handler, request);
        }
        QueueBufferFuture<DeleteMessageRequest, DeleteMessageResult> future = this.sendBuffer.deleteMessage(request, callback);
        future.setBuffer(this);
        return future;
    }

    public DeleteMessageResult deleteMessageSync(DeleteMessageRequest request) {
        Future<DeleteMessageResult> future = this.deleteMessage(request, null);
        return this.waitForFuture(future);
    }

    public Future<ChangeMessageVisibilityResult> changeMessageVisibility(ChangeMessageVisibilityRequest request, AsyncHandler<ChangeMessageVisibilityRequest, ChangeMessageVisibilityResult> handler) {
        QueueBufferCallback<ChangeMessageVisibilityRequest, ChangeMessageVisibilityResult> callback = null;
        if (handler != null) {
            callback = new QueueBufferCallback<ChangeMessageVisibilityRequest, ChangeMessageVisibilityResult>(handler, request);
        }
        QueueBufferFuture<ChangeMessageVisibilityRequest, ChangeMessageVisibilityResult> future = this.sendBuffer.changeMessageVisibility(request, callback);
        future.setBuffer(this);
        return future;
    }

    public ChangeMessageVisibilityResult changeMessageVisibilitySync(ChangeMessageVisibilityRequest request) {
        QueueBufferFuture<ChangeMessageVisibilityRequest, ChangeMessageVisibilityResult> future = this.sendBuffer.changeMessageVisibility(request, null);
        return (ChangeMessageVisibilityResult)this.waitForFuture(future);
    }

    public Future<ReceiveMessageResult> receiveMessage(ReceiveMessageRequest rq, AsyncHandler<ReceiveMessageRequest, ReceiveMessageResult> handler) {
        if (this.canBeRetrievedFromQueueBuffer(rq)) {
            QueueBufferCallback<ReceiveMessageRequest, ReceiveMessageResult> callback = null;
            if (handler != null) {
                callback = new QueueBufferCallback<ReceiveMessageRequest, ReceiveMessageResult>(handler, rq);
            }
            QueueBufferFuture<ReceiveMessageRequest, ReceiveMessageResult> future = this.receiveBuffer.receiveMessageAsync(rq, callback);
            future.setBuffer(this);
            return future;
        }
        if (handler != null) {
            return this.realSqs.receiveMessageAsync(rq, handler);
        }
        return this.realSqs.receiveMessageAsync(rq);
    }

    public ReceiveMessageResult receiveMessageSync(ReceiveMessageRequest rq) {
        Future<ReceiveMessageResult> future = this.receiveMessage(rq, null);
        return this.waitForFuture(future);
    }

    public void shutdown() {
        if (this.config.isFlushOnShutdown()) {
            this.flush();
        }
        this.receiveBuffer.shutdown();
    }

    void flush() {
        this.sendBuffer.flush();
    }

    private boolean canBeRetrievedFromQueueBuffer(ReceiveMessageRequest rq) {
        return !this.hasRequestedQueueAttributes(rq) && !this.hasRequestedMessageAttributes(rq) && this.isBufferingEnabled() && rq.getVisibilityTimeout() == null;
    }

    private boolean hasRequestedQueueAttributes(ReceiveMessageRequest rq) {
        return rq.getAttributeNames() != null && !rq.getAttributeNames().isEmpty();
    }

    private boolean hasRequestedMessageAttributes(ReceiveMessageRequest rq) {
        return rq.getMessageAttributeNames() != null && !rq.getMessageAttributeNames().isEmpty();
    }

    private boolean isBufferingEnabled() {
        return this.config.getMaxInflightReceiveBatches() > 0 && this.config.getMaxDoneReceiveBatches() > 0;
    }

    private <ResultType> ResultType waitForFuture(Future<ResultType> future) {
        ResultType toReturn = null;
        try {
            toReturn = future.get();
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            AmazonClientException ce = new AmazonClientException("Thread interrupted while waiting for execution result");
            ce.initCause((Throwable)ie);
            throw ce;
        }
        catch (ExecutionException ee) {
            Throwable cause = ee.getCause();
            if (cause instanceof AmazonClientException) {
                throw (AmazonClientException)cause;
            }
            AmazonClientException ce = new AmazonClientException("Caught an exception while waiting for request to complete...");
            ce.initCause((Throwable)ee);
            throw ce;
        }
        return toReturn;
    }

    private static class DaemonThreadFactory
    implements ThreadFactory {
        static AtomicInteger threadCount = new AtomicInteger(0);

        private DaemonThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            int threadNumber = threadCount.addAndGet(1);
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            thread.setName("SQSQueueBufferWorkerThread-" + threadNumber);
            return thread;
        }
    }
}

