/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.auth.Signer;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.DefaultErrorResponseHandler;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.http.StaxResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.internal.auth.SignerProvider;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.AmazonSQSClientBuilder;
import com.amazonaws.services.sqs.AmazonSQSClientConfigurationFactory;
import com.amazonaws.services.sqs.internal.auth.SQSSignerProvider;
import com.amazonaws.services.sqs.model.AddPermissionRequest;
import com.amazonaws.services.sqs.model.AddPermissionResult;
import com.amazonaws.services.sqs.model.AmazonSQSException;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchRequest;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchRequestEntry;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchResult;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityRequest;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityResult;
import com.amazonaws.services.sqs.model.CreateQueueRequest;
import com.amazonaws.services.sqs.model.CreateQueueResult;
import com.amazonaws.services.sqs.model.DeleteMessageBatchRequest;
import com.amazonaws.services.sqs.model.DeleteMessageBatchRequestEntry;
import com.amazonaws.services.sqs.model.DeleteMessageBatchResult;
import com.amazonaws.services.sqs.model.DeleteMessageRequest;
import com.amazonaws.services.sqs.model.DeleteMessageResult;
import com.amazonaws.services.sqs.model.DeleteQueueRequest;
import com.amazonaws.services.sqs.model.DeleteQueueResult;
import com.amazonaws.services.sqs.model.GetQueueAttributesRequest;
import com.amazonaws.services.sqs.model.GetQueueAttributesResult;
import com.amazonaws.services.sqs.model.GetQueueUrlRequest;
import com.amazonaws.services.sqs.model.GetQueueUrlResult;
import com.amazonaws.services.sqs.model.ListDeadLetterSourceQueuesRequest;
import com.amazonaws.services.sqs.model.ListDeadLetterSourceQueuesResult;
import com.amazonaws.services.sqs.model.ListQueueTagsRequest;
import com.amazonaws.services.sqs.model.ListQueueTagsResult;
import com.amazonaws.services.sqs.model.ListQueuesRequest;
import com.amazonaws.services.sqs.model.ListQueuesResult;
import com.amazonaws.services.sqs.model.PurgeQueueRequest;
import com.amazonaws.services.sqs.model.PurgeQueueResult;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import com.amazonaws.services.sqs.model.ReceiveMessageResult;
import com.amazonaws.services.sqs.model.RemovePermissionRequest;
import com.amazonaws.services.sqs.model.RemovePermissionResult;
import com.amazonaws.services.sqs.model.SendMessageBatchRequest;
import com.amazonaws.services.sqs.model.SendMessageBatchRequestEntry;
import com.amazonaws.services.sqs.model.SendMessageBatchResult;
import com.amazonaws.services.sqs.model.SendMessageRequest;
import com.amazonaws.services.sqs.model.SendMessageResult;
import com.amazonaws.services.sqs.model.SetQueueAttributesRequest;
import com.amazonaws.services.sqs.model.SetQueueAttributesResult;
import com.amazonaws.services.sqs.model.TagQueueRequest;
import com.amazonaws.services.sqs.model.TagQueueResult;
import com.amazonaws.services.sqs.model.UntagQueueRequest;
import com.amazonaws.services.sqs.model.UntagQueueResult;
import com.amazonaws.services.sqs.model.transform.AddPermissionRequestMarshaller;
import com.amazonaws.services.sqs.model.transform.AddPermissionResultStaxUnmarshaller;
import com.amazonaws.services.sqs.model.transform.BatchEntryIdsNotDistinctExceptionUnmarshaller;
import com.amazonaws.services.sqs.model.transform.BatchRequestTooLongExceptionUnmarshaller;
import com.amazonaws.services.sqs.model.transform.ChangeMessageVisibilityBatchRequestMarshaller;
import com.amazonaws.services.sqs.model.transform.ChangeMessageVisibilityBatchResultStaxUnmarshaller;
import com.amazonaws.services.sqs.model.transform.ChangeMessageVisibilityRequestMarshaller;
import com.amazonaws.services.sqs.model.transform.ChangeMessageVisibilityResultStaxUnmarshaller;
import com.amazonaws.services.sqs.model.transform.CreateQueueRequestMarshaller;
import com.amazonaws.services.sqs.model.transform.CreateQueueResultStaxUnmarshaller;
import com.amazonaws.services.sqs.model.transform.DeleteMessageBatchRequestMarshaller;
import com.amazonaws.services.sqs.model.transform.DeleteMessageBatchResultStaxUnmarshaller;
import com.amazonaws.services.sqs.model.transform.DeleteMessageRequestMarshaller;
import com.amazonaws.services.sqs.model.transform.DeleteMessageResultStaxUnmarshaller;
import com.amazonaws.services.sqs.model.transform.DeleteQueueRequestMarshaller;
import com.amazonaws.services.sqs.model.transform.DeleteQueueResultStaxUnmarshaller;
import com.amazonaws.services.sqs.model.transform.EmptyBatchRequestExceptionUnmarshaller;
import com.amazonaws.services.sqs.model.transform.GetQueueAttributesRequestMarshaller;
import com.amazonaws.services.sqs.model.transform.GetQueueAttributesResultStaxUnmarshaller;
import com.amazonaws.services.sqs.model.transform.GetQueueUrlRequestMarshaller;
import com.amazonaws.services.sqs.model.transform.GetQueueUrlResultStaxUnmarshaller;
import com.amazonaws.services.sqs.model.transform.InvalidAttributeNameExceptionUnmarshaller;
import com.amazonaws.services.sqs.model.transform.InvalidBatchEntryIdExceptionUnmarshaller;
import com.amazonaws.services.sqs.model.transform.InvalidIdFormatExceptionUnmarshaller;
import com.amazonaws.services.sqs.model.transform.InvalidMessageContentsExceptionUnmarshaller;
import com.amazonaws.services.sqs.model.transform.ListDeadLetterSourceQueuesRequestMarshaller;
import com.amazonaws.services.sqs.model.transform.ListDeadLetterSourceQueuesResultStaxUnmarshaller;
import com.amazonaws.services.sqs.model.transform.ListQueueTagsRequestMarshaller;
import com.amazonaws.services.sqs.model.transform.ListQueueTagsResultStaxUnmarshaller;
import com.amazonaws.services.sqs.model.transform.ListQueuesRequestMarshaller;
import com.amazonaws.services.sqs.model.transform.ListQueuesResultStaxUnmarshaller;
import com.amazonaws.services.sqs.model.transform.MessageNotInflightExceptionUnmarshaller;
import com.amazonaws.services.sqs.model.transform.OverLimitExceptionUnmarshaller;
import com.amazonaws.services.sqs.model.transform.PurgeQueueInProgressExceptionUnmarshaller;
import com.amazonaws.services.sqs.model.transform.PurgeQueueRequestMarshaller;
import com.amazonaws.services.sqs.model.transform.PurgeQueueResultStaxUnmarshaller;
import com.amazonaws.services.sqs.model.transform.QueueDeletedRecentlyExceptionUnmarshaller;
import com.amazonaws.services.sqs.model.transform.QueueDoesNotExistExceptionUnmarshaller;
import com.amazonaws.services.sqs.model.transform.QueueNameExistsExceptionUnmarshaller;
import com.amazonaws.services.sqs.model.transform.ReceiptHandleIsInvalidExceptionUnmarshaller;
import com.amazonaws.services.sqs.model.transform.ReceiveMessageRequestMarshaller;
import com.amazonaws.services.sqs.model.transform.ReceiveMessageResultStaxUnmarshaller;
import com.amazonaws.services.sqs.model.transform.RemovePermissionRequestMarshaller;
import com.amazonaws.services.sqs.model.transform.RemovePermissionResultStaxUnmarshaller;
import com.amazonaws.services.sqs.model.transform.SendMessageBatchRequestMarshaller;
import com.amazonaws.services.sqs.model.transform.SendMessageBatchResultStaxUnmarshaller;
import com.amazonaws.services.sqs.model.transform.SendMessageRequestMarshaller;
import com.amazonaws.services.sqs.model.transform.SendMessageResultStaxUnmarshaller;
import com.amazonaws.services.sqs.model.transform.SetQueueAttributesRequestMarshaller;
import com.amazonaws.services.sqs.model.transform.SetQueueAttributesResultStaxUnmarshaller;
import com.amazonaws.services.sqs.model.transform.TagQueueRequestMarshaller;
import com.amazonaws.services.sqs.model.transform.TagQueueResultStaxUnmarshaller;
import com.amazonaws.services.sqs.model.transform.TooManyEntriesInBatchRequestExceptionUnmarshaller;
import com.amazonaws.services.sqs.model.transform.UnsupportedOperationExceptionUnmarshaller;
import com.amazonaws.services.sqs.model.transform.UntagQueueRequestMarshaller;
import com.amazonaws.services.sqs.model.transform.UntagQueueResultStaxUnmarshaller;
import com.amazonaws.transform.StandardErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;

@ThreadSafe
public class AmazonSQSClient
extends AmazonWebServiceClient
implements AmazonSQS {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonSQS.class);
    private static final String DEFAULT_SIGNING_NAME = "sqs";
    protected static final AmazonSQSClientConfigurationFactory configFactory = new AmazonSQSClientConfigurationFactory();
    protected final List<Unmarshaller<AmazonServiceException, Node>> exceptionUnmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, Node>>();

    @Deprecated
    public AmazonSQSClient() {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), configFactory.getConfig());
    }

    @Deprecated
    public AmazonSQSClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration);
    }

    @Deprecated
    public AmazonSQSClient(AWSCredentials awsCredentials) {
        this(awsCredentials, configFactory.getConfig());
    }

    @Deprecated
    public AmazonSQSClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    @Deprecated
    public AmazonSQSClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, configFactory.getConfig());
    }

    @Deprecated
    public AmazonSQSClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    @Deprecated
    public AmazonSQSClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    public static AmazonSQSClientBuilder builder() {
        return AmazonSQSClientBuilder.standard();
    }

    AmazonSQSClient(AwsSyncClientParams clientParams) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.init();
    }

    private void init() {
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new PurgeQueueInProgressExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new InvalidAttributeNameExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new BatchEntryIdsNotDistinctExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new TooManyEntriesInBatchRequestExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new BatchRequestTooLongExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new UnsupportedOperationExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new InvalidIdFormatExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new OverLimitExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new QueueDoesNotExistExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new QueueNameExistsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new MessageNotInflightExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new ReceiptHandleIsInvalidExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new InvalidMessageContentsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new QueueDeletedRecentlyExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new EmptyBatchRequestExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new InvalidBatchEntryIdExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new StandardErrorUnmarshaller(AmazonSQSException.class));
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("https://sqs.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/sqs/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/sqs/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public AddPermissionResult addPermission(AddPermissionRequest request) {
        request = (AddPermissionRequest)this.beforeClientExecution(request);
        return this.executeAddPermission(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final AddPermissionResult executeAddPermission(AddPermissionRequest addPermissionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(addPermissionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AddPermissionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AddPermissionRequestMarshaller().marshall((AddPermissionRequest)super.beforeMarshalling((AmazonWebServiceRequest)addPermissionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SQS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"AddPermission");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new AddPermissionResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            AddPermissionResult addPermissionResult = (AddPermissionResult)response.getAwsResponse();
            return addPermissionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public AddPermissionResult addPermission(String queueUrl, String label, List<String> aWSAccountIds, List<String> actions) {
        return this.addPermission(new AddPermissionRequest().withQueueUrl(queueUrl).withLabel(label).withAWSAccountIds(aWSAccountIds).withActions(actions));
    }

    @Override
    public ChangeMessageVisibilityResult changeMessageVisibility(ChangeMessageVisibilityRequest request) {
        request = (ChangeMessageVisibilityRequest)this.beforeClientExecution(request);
        return this.executeChangeMessageVisibility(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ChangeMessageVisibilityResult executeChangeMessageVisibility(ChangeMessageVisibilityRequest changeMessageVisibilityRequest) {
        ExecutionContext executionContext = this.createExecutionContext(changeMessageVisibilityRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ChangeMessageVisibilityRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ChangeMessageVisibilityRequestMarshaller().marshall((ChangeMessageVisibilityRequest)super.beforeMarshalling((AmazonWebServiceRequest)changeMessageVisibilityRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SQS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ChangeMessageVisibility");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new ChangeMessageVisibilityResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ChangeMessageVisibilityResult changeMessageVisibilityResult = (ChangeMessageVisibilityResult)response.getAwsResponse();
            return changeMessageVisibilityResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ChangeMessageVisibilityResult changeMessageVisibility(String queueUrl, String receiptHandle, Integer visibilityTimeout) {
        return this.changeMessageVisibility(new ChangeMessageVisibilityRequest().withQueueUrl(queueUrl).withReceiptHandle(receiptHandle).withVisibilityTimeout(visibilityTimeout));
    }

    @Override
    public ChangeMessageVisibilityBatchResult changeMessageVisibilityBatch(ChangeMessageVisibilityBatchRequest request) {
        request = (ChangeMessageVisibilityBatchRequest)this.beforeClientExecution(request);
        return this.executeChangeMessageVisibilityBatch(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ChangeMessageVisibilityBatchResult executeChangeMessageVisibilityBatch(ChangeMessageVisibilityBatchRequest changeMessageVisibilityBatchRequest) {
        ExecutionContext executionContext = this.createExecutionContext(changeMessageVisibilityBatchRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ChangeMessageVisibilityBatchRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ChangeMessageVisibilityBatchRequestMarshaller().marshall((ChangeMessageVisibilityBatchRequest)super.beforeMarshalling((AmazonWebServiceRequest)changeMessageVisibilityBatchRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SQS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ChangeMessageVisibilityBatch");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new ChangeMessageVisibilityBatchResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ChangeMessageVisibilityBatchResult changeMessageVisibilityBatchResult = (ChangeMessageVisibilityBatchResult)response.getAwsResponse();
            return changeMessageVisibilityBatchResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ChangeMessageVisibilityBatchResult changeMessageVisibilityBatch(String queueUrl, List<ChangeMessageVisibilityBatchRequestEntry> entries) {
        return this.changeMessageVisibilityBatch(new ChangeMessageVisibilityBatchRequest().withQueueUrl(queueUrl).withEntries(entries));
    }

    @Override
    public CreateQueueResult createQueue(CreateQueueRequest request) {
        request = (CreateQueueRequest)this.beforeClientExecution(request);
        return this.executeCreateQueue(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateQueueResult executeCreateQueue(CreateQueueRequest createQueueRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createQueueRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateQueueRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateQueueRequestMarshaller().marshall((CreateQueueRequest)super.beforeMarshalling((AmazonWebServiceRequest)createQueueRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SQS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateQueue");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new CreateQueueResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            CreateQueueResult createQueueResult = (CreateQueueResult)response.getAwsResponse();
            return createQueueResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateQueueResult createQueue(String queueName) {
        return this.createQueue(new CreateQueueRequest().withQueueName(queueName));
    }

    @Override
    public DeleteMessageResult deleteMessage(DeleteMessageRequest request) {
        request = (DeleteMessageRequest)this.beforeClientExecution(request);
        return this.executeDeleteMessage(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteMessageResult executeDeleteMessage(DeleteMessageRequest deleteMessageRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteMessageRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteMessageRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteMessageRequestMarshaller().marshall((DeleteMessageRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteMessageRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SQS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteMessage");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DeleteMessageResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DeleteMessageResult deleteMessageResult = (DeleteMessageResult)response.getAwsResponse();
            return deleteMessageResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteMessageResult deleteMessage(String queueUrl, String receiptHandle) {
        return this.deleteMessage(new DeleteMessageRequest().withQueueUrl(queueUrl).withReceiptHandle(receiptHandle));
    }

    @Override
    public DeleteMessageBatchResult deleteMessageBatch(DeleteMessageBatchRequest request) {
        request = (DeleteMessageBatchRequest)this.beforeClientExecution(request);
        return this.executeDeleteMessageBatch(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteMessageBatchResult executeDeleteMessageBatch(DeleteMessageBatchRequest deleteMessageBatchRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteMessageBatchRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteMessageBatchRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteMessageBatchRequestMarshaller().marshall((DeleteMessageBatchRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteMessageBatchRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SQS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteMessageBatch");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DeleteMessageBatchResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DeleteMessageBatchResult deleteMessageBatchResult = (DeleteMessageBatchResult)response.getAwsResponse();
            return deleteMessageBatchResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteMessageBatchResult deleteMessageBatch(String queueUrl, List<DeleteMessageBatchRequestEntry> entries) {
        return this.deleteMessageBatch(new DeleteMessageBatchRequest().withQueueUrl(queueUrl).withEntries(entries));
    }

    @Override
    public DeleteQueueResult deleteQueue(DeleteQueueRequest request) {
        request = (DeleteQueueRequest)this.beforeClientExecution(request);
        return this.executeDeleteQueue(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteQueueResult executeDeleteQueue(DeleteQueueRequest deleteQueueRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteQueueRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteQueueRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteQueueRequestMarshaller().marshall((DeleteQueueRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteQueueRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SQS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteQueue");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DeleteQueueResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DeleteQueueResult deleteQueueResult = (DeleteQueueResult)response.getAwsResponse();
            return deleteQueueResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteQueueResult deleteQueue(String queueUrl) {
        return this.deleteQueue(new DeleteQueueRequest().withQueueUrl(queueUrl));
    }

    @Override
    public GetQueueAttributesResult getQueueAttributes(GetQueueAttributesRequest request) {
        request = (GetQueueAttributesRequest)this.beforeClientExecution(request);
        return this.executeGetQueueAttributes(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetQueueAttributesResult executeGetQueueAttributes(GetQueueAttributesRequest getQueueAttributesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getQueueAttributesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetQueueAttributesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetQueueAttributesRequestMarshaller().marshall((GetQueueAttributesRequest)super.beforeMarshalling((AmazonWebServiceRequest)getQueueAttributesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SQS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetQueueAttributes");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new GetQueueAttributesResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            GetQueueAttributesResult getQueueAttributesResult = (GetQueueAttributesResult)response.getAwsResponse();
            return getQueueAttributesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetQueueAttributesResult getQueueAttributes(String queueUrl, List<String> attributeNames) {
        return this.getQueueAttributes(new GetQueueAttributesRequest().withQueueUrl(queueUrl).withAttributeNames(attributeNames));
    }

    @Override
    public GetQueueUrlResult getQueueUrl(GetQueueUrlRequest request) {
        request = (GetQueueUrlRequest)this.beforeClientExecution(request);
        return this.executeGetQueueUrl(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetQueueUrlResult executeGetQueueUrl(GetQueueUrlRequest getQueueUrlRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getQueueUrlRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetQueueUrlRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetQueueUrlRequestMarshaller().marshall((GetQueueUrlRequest)super.beforeMarshalling((AmazonWebServiceRequest)getQueueUrlRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SQS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetQueueUrl");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new GetQueueUrlResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            GetQueueUrlResult getQueueUrlResult = (GetQueueUrlResult)response.getAwsResponse();
            return getQueueUrlResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetQueueUrlResult getQueueUrl(String queueName) {
        return this.getQueueUrl(new GetQueueUrlRequest().withQueueName(queueName));
    }

    @Override
    public ListDeadLetterSourceQueuesResult listDeadLetterSourceQueues(ListDeadLetterSourceQueuesRequest request) {
        request = (ListDeadLetterSourceQueuesRequest)this.beforeClientExecution(request);
        return this.executeListDeadLetterSourceQueues(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListDeadLetterSourceQueuesResult executeListDeadLetterSourceQueues(ListDeadLetterSourceQueuesRequest listDeadLetterSourceQueuesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listDeadLetterSourceQueuesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListDeadLetterSourceQueuesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListDeadLetterSourceQueuesRequestMarshaller().marshall((ListDeadLetterSourceQueuesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listDeadLetterSourceQueuesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SQS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListDeadLetterSourceQueues");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new ListDeadLetterSourceQueuesResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ListDeadLetterSourceQueuesResult listDeadLetterSourceQueuesResult = (ListDeadLetterSourceQueuesResult)response.getAwsResponse();
            return listDeadLetterSourceQueuesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListQueueTagsResult listQueueTags(ListQueueTagsRequest request) {
        request = (ListQueueTagsRequest)this.beforeClientExecution(request);
        return this.executeListQueueTags(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListQueueTagsResult executeListQueueTags(ListQueueTagsRequest listQueueTagsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listQueueTagsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListQueueTagsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListQueueTagsRequestMarshaller().marshall((ListQueueTagsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listQueueTagsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SQS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListQueueTags");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new ListQueueTagsResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ListQueueTagsResult listQueueTagsResult = (ListQueueTagsResult)response.getAwsResponse();
            return listQueueTagsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListQueueTagsResult listQueueTags(String queueUrl) {
        return this.listQueueTags(new ListQueueTagsRequest().withQueueUrl(queueUrl));
    }

    @Override
    public ListQueuesResult listQueues(ListQueuesRequest request) {
        request = (ListQueuesRequest)this.beforeClientExecution(request);
        return this.executeListQueues(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListQueuesResult executeListQueues(ListQueuesRequest listQueuesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listQueuesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListQueuesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListQueuesRequestMarshaller().marshall((ListQueuesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listQueuesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SQS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListQueues");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new ListQueuesResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ListQueuesResult listQueuesResult = (ListQueuesResult)response.getAwsResponse();
            return listQueuesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListQueuesResult listQueues() {
        return this.listQueues(new ListQueuesRequest());
    }

    @Override
    public ListQueuesResult listQueues(String queueNamePrefix) {
        return this.listQueues(new ListQueuesRequest().withQueueNamePrefix(queueNamePrefix));
    }

    @Override
    public PurgeQueueResult purgeQueue(PurgeQueueRequest request) {
        request = (PurgeQueueRequest)this.beforeClientExecution(request);
        return this.executePurgeQueue(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PurgeQueueResult executePurgeQueue(PurgeQueueRequest purgeQueueRequest) {
        ExecutionContext executionContext = this.createExecutionContext(purgeQueueRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PurgeQueueRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PurgeQueueRequestMarshaller().marshall((PurgeQueueRequest)super.beforeMarshalling((AmazonWebServiceRequest)purgeQueueRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SQS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PurgeQueue");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new PurgeQueueResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            PurgeQueueResult purgeQueueResult = (PurgeQueueResult)response.getAwsResponse();
            return purgeQueueResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ReceiveMessageResult receiveMessage(ReceiveMessageRequest request) {
        request = (ReceiveMessageRequest)this.beforeClientExecution(request);
        return this.executeReceiveMessage(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ReceiveMessageResult executeReceiveMessage(ReceiveMessageRequest receiveMessageRequest) {
        ExecutionContext executionContext = this.createExecutionContext(receiveMessageRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ReceiveMessageRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ReceiveMessageRequestMarshaller().marshall((ReceiveMessageRequest)super.beforeMarshalling((AmazonWebServiceRequest)receiveMessageRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SQS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ReceiveMessage");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new ReceiveMessageResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ReceiveMessageResult receiveMessageResult = (ReceiveMessageResult)response.getAwsResponse();
            return receiveMessageResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ReceiveMessageResult receiveMessage(String queueUrl) {
        return this.receiveMessage(new ReceiveMessageRequest().withQueueUrl(queueUrl));
    }

    @Override
    public RemovePermissionResult removePermission(RemovePermissionRequest request) {
        request = (RemovePermissionRequest)this.beforeClientExecution(request);
        return this.executeRemovePermission(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final RemovePermissionResult executeRemovePermission(RemovePermissionRequest removePermissionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(removePermissionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RemovePermissionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RemovePermissionRequestMarshaller().marshall((RemovePermissionRequest)super.beforeMarshalling((AmazonWebServiceRequest)removePermissionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SQS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"RemovePermission");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new RemovePermissionResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            RemovePermissionResult removePermissionResult = (RemovePermissionResult)response.getAwsResponse();
            return removePermissionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public RemovePermissionResult removePermission(String queueUrl, String label) {
        return this.removePermission(new RemovePermissionRequest().withQueueUrl(queueUrl).withLabel(label));
    }

    @Override
    public SendMessageResult sendMessage(SendMessageRequest request) {
        request = (SendMessageRequest)this.beforeClientExecution(request);
        return this.executeSendMessage(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final SendMessageResult executeSendMessage(SendMessageRequest sendMessageRequest) {
        ExecutionContext executionContext = this.createExecutionContext(sendMessageRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SendMessageRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SendMessageRequestMarshaller().marshall((SendMessageRequest)super.beforeMarshalling((AmazonWebServiceRequest)sendMessageRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SQS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"SendMessage");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new SendMessageResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            SendMessageResult sendMessageResult = (SendMessageResult)response.getAwsResponse();
            return sendMessageResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public SendMessageResult sendMessage(String queueUrl, String messageBody) {
        return this.sendMessage(new SendMessageRequest().withQueueUrl(queueUrl).withMessageBody(messageBody));
    }

    @Override
    public SendMessageBatchResult sendMessageBatch(SendMessageBatchRequest request) {
        request = (SendMessageBatchRequest)this.beforeClientExecution(request);
        return this.executeSendMessageBatch(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final SendMessageBatchResult executeSendMessageBatch(SendMessageBatchRequest sendMessageBatchRequest) {
        ExecutionContext executionContext = this.createExecutionContext(sendMessageBatchRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SendMessageBatchRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SendMessageBatchRequestMarshaller().marshall((SendMessageBatchRequest)super.beforeMarshalling((AmazonWebServiceRequest)sendMessageBatchRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SQS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"SendMessageBatch");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new SendMessageBatchResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            SendMessageBatchResult sendMessageBatchResult = (SendMessageBatchResult)response.getAwsResponse();
            return sendMessageBatchResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public SendMessageBatchResult sendMessageBatch(String queueUrl, List<SendMessageBatchRequestEntry> entries) {
        return this.sendMessageBatch(new SendMessageBatchRequest().withQueueUrl(queueUrl).withEntries(entries));
    }

    @Override
    public SetQueueAttributesResult setQueueAttributes(SetQueueAttributesRequest request) {
        request = (SetQueueAttributesRequest)this.beforeClientExecution(request);
        return this.executeSetQueueAttributes(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final SetQueueAttributesResult executeSetQueueAttributes(SetQueueAttributesRequest setQueueAttributesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(setQueueAttributesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SetQueueAttributesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SetQueueAttributesRequestMarshaller().marshall((SetQueueAttributesRequest)super.beforeMarshalling((AmazonWebServiceRequest)setQueueAttributesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SQS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"SetQueueAttributes");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new SetQueueAttributesResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            SetQueueAttributesResult setQueueAttributesResult = (SetQueueAttributesResult)response.getAwsResponse();
            return setQueueAttributesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public SetQueueAttributesResult setQueueAttributes(String queueUrl, Map<String, String> attributes) {
        return this.setQueueAttributes(new SetQueueAttributesRequest().withQueueUrl(queueUrl).withAttributes(attributes));
    }

    @Override
    public TagQueueResult tagQueue(TagQueueRequest request) {
        request = (TagQueueRequest)this.beforeClientExecution(request);
        return this.executeTagQueue(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagQueueResult executeTagQueue(TagQueueRequest tagQueueRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagQueueRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagQueueRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagQueueRequestMarshaller().marshall((TagQueueRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagQueueRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SQS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagQueue");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new TagQueueResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            TagQueueResult tagQueueResult = (TagQueueResult)response.getAwsResponse();
            return tagQueueResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagQueueResult tagQueue(String queueUrl, Map<String, String> tags) {
        return this.tagQueue(new TagQueueRequest().withQueueUrl(queueUrl).withTags(tags));
    }

    @Override
    public UntagQueueResult untagQueue(UntagQueueRequest request) {
        request = (UntagQueueRequest)this.beforeClientExecution(request);
        return this.executeUntagQueue(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagQueueResult executeUntagQueue(UntagQueueRequest untagQueueRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagQueueRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagQueueRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagQueueRequestMarshaller().marshall((UntagQueueRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagQueueRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SQS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagQueue");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new UntagQueueResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            UntagQueueResult untagQueueResult = (UntagQueueResult)response.getAwsResponse();
            return untagQueueResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagQueueResult untagQueue(String queueUrl, List<String> tagKeys) {
        return this.untagQueue(new UntagQueueRequest().withQueueUrl(queueUrl).withTagKeys(tagKeys));
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    protected final SignerProvider createSignerProvider(Signer signer) {
        return new SQSSignerProvider(this, signer);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.client.execute(request, responseHandler, (HttpResponseHandler)errorResponseHandler, executionContext);
    }
}

