/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.snowdevicemanagement.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.snowdevicemanagement.model.ResourceSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListDeviceResourcesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String nextToken;
    private List<ResourceSummary> resources;

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListDeviceResourcesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<ResourceSummary> getResources() {
        return this.resources;
    }

    public void setResources(Collection<ResourceSummary> resources) {
        if (resources == null) {
            this.resources = null;
            return;
        }
        this.resources = new ArrayList<ResourceSummary>(resources);
    }

    public ListDeviceResourcesResult withResources(ResourceSummary ... resources) {
        if (this.resources == null) {
            this.setResources(new ArrayList<ResourceSummary>(resources.length));
        }
        for (ResourceSummary ele : resources) {
            this.resources.add(ele);
        }
        return this;
    }

    public ListDeviceResourcesResult withResources(Collection<ResourceSummary> resources) {
        this.setResources(resources);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getResources() != null) {
            sb.append("Resources: ").append(this.getResources());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeviceResourcesResult)) {
            return false;
        }
        ListDeviceResourcesResult other = (ListDeviceResourcesResult)obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getResources() == null ^ this.getResources() == null) {
            return false;
        }
        return other.getResources() == null || other.getResources().equals(this.getResources());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getResources() == null ? 0 : this.getResources().hashCode());
        return hashCode;
    }

    public ListDeviceResourcesResult clone() {
        try {
            return (ListDeviceResourcesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

