/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.snowball.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.snowball.model.KeyRange;
import com.amazonaws.services.snowball.model.TargetOnDeviceService;
import com.amazonaws.services.snowball.model.transform.S3ResourceMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class S3Resource
implements Serializable,
Cloneable,
StructuredPojo {
    private String bucketArn;
    private KeyRange keyRange;
    private List<TargetOnDeviceService> targetOnDeviceServices;

    public void setBucketArn(String bucketArn) {
        this.bucketArn = bucketArn;
    }

    public String getBucketArn() {
        return this.bucketArn;
    }

    public S3Resource withBucketArn(String bucketArn) {
        this.setBucketArn(bucketArn);
        return this;
    }

    public void setKeyRange(KeyRange keyRange) {
        this.keyRange = keyRange;
    }

    public KeyRange getKeyRange() {
        return this.keyRange;
    }

    public S3Resource withKeyRange(KeyRange keyRange) {
        this.setKeyRange(keyRange);
        return this;
    }

    public List<TargetOnDeviceService> getTargetOnDeviceServices() {
        return this.targetOnDeviceServices;
    }

    public void setTargetOnDeviceServices(Collection<TargetOnDeviceService> targetOnDeviceServices) {
        if (targetOnDeviceServices == null) {
            this.targetOnDeviceServices = null;
            return;
        }
        this.targetOnDeviceServices = new ArrayList<TargetOnDeviceService>(targetOnDeviceServices);
    }

    public S3Resource withTargetOnDeviceServices(TargetOnDeviceService ... targetOnDeviceServices) {
        if (this.targetOnDeviceServices == null) {
            this.setTargetOnDeviceServices(new ArrayList<TargetOnDeviceService>(targetOnDeviceServices.length));
        }
        for (TargetOnDeviceService ele : targetOnDeviceServices) {
            this.targetOnDeviceServices.add(ele);
        }
        return this;
    }

    public S3Resource withTargetOnDeviceServices(Collection<TargetOnDeviceService> targetOnDeviceServices) {
        this.setTargetOnDeviceServices(targetOnDeviceServices);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBucketArn() != null) {
            sb.append("BucketArn: ").append(this.getBucketArn()).append(",");
        }
        if (this.getKeyRange() != null) {
            sb.append("KeyRange: ").append(this.getKeyRange()).append(",");
        }
        if (this.getTargetOnDeviceServices() != null) {
            sb.append("TargetOnDeviceServices: ").append(this.getTargetOnDeviceServices());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Resource)) {
            return false;
        }
        S3Resource other = (S3Resource)obj;
        if (other.getBucketArn() == null ^ this.getBucketArn() == null) {
            return false;
        }
        if (other.getBucketArn() != null && !other.getBucketArn().equals(this.getBucketArn())) {
            return false;
        }
        if (other.getKeyRange() == null ^ this.getKeyRange() == null) {
            return false;
        }
        if (other.getKeyRange() != null && !other.getKeyRange().equals(this.getKeyRange())) {
            return false;
        }
        if (other.getTargetOnDeviceServices() == null ^ this.getTargetOnDeviceServices() == null) {
            return false;
        }
        return other.getTargetOnDeviceServices() == null || other.getTargetOnDeviceServices().equals(this.getTargetOnDeviceServices());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBucketArn() == null ? 0 : this.getBucketArn().hashCode());
        hashCode = 31 * hashCode + (this.getKeyRange() == null ? 0 : this.getKeyRange().hashCode());
        hashCode = 31 * hashCode + (this.getTargetOnDeviceServices() == null ? 0 : this.getTargetOnDeviceServices().hashCode());
        return hashCode;
    }

    public S3Resource clone() {
        try {
            return (S3Resource)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3ResourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

