/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.simpleworkflow.model.PollForDecisionTaskRequest;
import com.amazonaws.services.simpleworkflow.model.transform.TaskListJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class PollForDecisionTaskRequestMarshaller
implements Marshaller<Request<PollForDecisionTaskRequest>, PollForDecisionTaskRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public PollForDecisionTaskRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<PollForDecisionTaskRequest> marshall(PollForDecisionTaskRequest pollForDecisionTaskRequest) {
        if (pollForDecisionTaskRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)pollForDecisionTaskRequest, "AmazonSimpleWorkflow");
        request.addHeader("X-Amz-Target", "SimpleWorkflowService.PollForDecisionTask");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (pollForDecisionTaskRequest.getDomain() != null) {
                jsonGenerator.writeFieldName("domain").writeValue(pollForDecisionTaskRequest.getDomain());
            }
            if (pollForDecisionTaskRequest.getTaskList() != null) {
                jsonGenerator.writeFieldName("taskList");
                TaskListJsonMarshaller.getInstance().marshall(pollForDecisionTaskRequest.getTaskList(), jsonGenerator);
            }
            if (pollForDecisionTaskRequest.getIdentity() != null) {
                jsonGenerator.writeFieldName("identity").writeValue(pollForDecisionTaskRequest.getIdentity());
            }
            if (pollForDecisionTaskRequest.getNextPageToken() != null) {
                jsonGenerator.writeFieldName("nextPageToken").writeValue(pollForDecisionTaskRequest.getNextPageToken());
            }
            if (pollForDecisionTaskRequest.getMaximumPageSize() != null) {
                jsonGenerator.writeFieldName("maximumPageSize").writeValue(pollForDecisionTaskRequest.getMaximumPageSize().intValue());
            }
            if (pollForDecisionTaskRequest.getReverseOrder() != null) {
                jsonGenerator.writeFieldName("reverseOrder").writeValue(pollForDecisionTaskRequest.getReverseOrder().booleanValue());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

