/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.simpleworkflow.model.CloseStatus;
import com.amazonaws.services.simpleworkflow.model.ExecutionStatus;
import com.amazonaws.services.simpleworkflow.model.WorkflowExecution;
import com.amazonaws.services.simpleworkflow.model.WorkflowType;
import com.amazonaws.services.simpleworkflow.model.transform.WorkflowExecutionInfoMarshaller;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class WorkflowExecutionInfo
implements Serializable,
Cloneable,
StructuredPojo {
    private WorkflowExecution execution;
    private WorkflowType workflowType;
    private Date startTimestamp;
    private Date closeTimestamp;
    private String executionStatus;
    private String closeStatus;
    private WorkflowExecution parent;
    private List<String> tagList;
    private Boolean cancelRequested;

    public void setExecution(WorkflowExecution execution) {
        this.execution = execution;
    }

    public WorkflowExecution getExecution() {
        return this.execution;
    }

    public WorkflowExecutionInfo withExecution(WorkflowExecution execution) {
        this.setExecution(execution);
        return this;
    }

    public void setWorkflowType(WorkflowType workflowType) {
        this.workflowType = workflowType;
    }

    public WorkflowType getWorkflowType() {
        return this.workflowType;
    }

    public WorkflowExecutionInfo withWorkflowType(WorkflowType workflowType) {
        this.setWorkflowType(workflowType);
        return this;
    }

    public void setStartTimestamp(Date startTimestamp) {
        this.startTimestamp = startTimestamp;
    }

    public Date getStartTimestamp() {
        return this.startTimestamp;
    }

    public WorkflowExecutionInfo withStartTimestamp(Date startTimestamp) {
        this.setStartTimestamp(startTimestamp);
        return this;
    }

    public void setCloseTimestamp(Date closeTimestamp) {
        this.closeTimestamp = closeTimestamp;
    }

    public Date getCloseTimestamp() {
        return this.closeTimestamp;
    }

    public WorkflowExecutionInfo withCloseTimestamp(Date closeTimestamp) {
        this.setCloseTimestamp(closeTimestamp);
        return this;
    }

    public void setExecutionStatus(String executionStatus) {
        this.executionStatus = executionStatus;
    }

    public String getExecutionStatus() {
        return this.executionStatus;
    }

    public WorkflowExecutionInfo withExecutionStatus(String executionStatus) {
        this.setExecutionStatus(executionStatus);
        return this;
    }

    @JsonIgnore
    public void setExecutionStatus(ExecutionStatus executionStatus) {
        this.executionStatus = executionStatus.toString();
    }

    public WorkflowExecutionInfo withExecutionStatus(ExecutionStatus executionStatus) {
        this.setExecutionStatus(executionStatus);
        return this;
    }

    public void setCloseStatus(String closeStatus) {
        this.closeStatus = closeStatus;
    }

    public String getCloseStatus() {
        return this.closeStatus;
    }

    public WorkflowExecutionInfo withCloseStatus(String closeStatus) {
        this.setCloseStatus(closeStatus);
        return this;
    }

    @JsonIgnore
    public void setCloseStatus(CloseStatus closeStatus) {
        this.closeStatus = closeStatus.toString();
    }

    public WorkflowExecutionInfo withCloseStatus(CloseStatus closeStatus) {
        this.setCloseStatus(closeStatus);
        return this;
    }

    public void setParent(WorkflowExecution parent) {
        this.parent = parent;
    }

    public WorkflowExecution getParent() {
        return this.parent;
    }

    public WorkflowExecutionInfo withParent(WorkflowExecution parent) {
        this.setParent(parent);
        return this;
    }

    public List<String> getTagList() {
        return this.tagList;
    }

    public void setTagList(Collection<String> tagList) {
        if (tagList == null) {
            this.tagList = null;
            return;
        }
        this.tagList = new ArrayList<String>(tagList);
    }

    public WorkflowExecutionInfo withTagList(String ... tagList) {
        if (this.tagList == null) {
            this.setTagList(new ArrayList<String>(tagList.length));
        }
        for (String ele : tagList) {
            this.tagList.add(ele);
        }
        return this;
    }

    public WorkflowExecutionInfo withTagList(Collection<String> tagList) {
        this.setTagList(tagList);
        return this;
    }

    public void setCancelRequested(Boolean cancelRequested) {
        this.cancelRequested = cancelRequested;
    }

    public Boolean getCancelRequested() {
        return this.cancelRequested;
    }

    public WorkflowExecutionInfo withCancelRequested(Boolean cancelRequested) {
        this.setCancelRequested(cancelRequested);
        return this;
    }

    public Boolean isCancelRequested() {
        return this.cancelRequested;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getExecution() != null) {
            sb.append("Execution: ").append(this.getExecution()).append(",");
        }
        if (this.getWorkflowType() != null) {
            sb.append("WorkflowType: ").append(this.getWorkflowType()).append(",");
        }
        if (this.getStartTimestamp() != null) {
            sb.append("StartTimestamp: ").append(this.getStartTimestamp()).append(",");
        }
        if (this.getCloseTimestamp() != null) {
            sb.append("CloseTimestamp: ").append(this.getCloseTimestamp()).append(",");
        }
        if (this.getExecutionStatus() != null) {
            sb.append("ExecutionStatus: ").append(this.getExecutionStatus()).append(",");
        }
        if (this.getCloseStatus() != null) {
            sb.append("CloseStatus: ").append(this.getCloseStatus()).append(",");
        }
        if (this.getParent() != null) {
            sb.append("Parent: ").append(this.getParent()).append(",");
        }
        if (this.getTagList() != null) {
            sb.append("TagList: ").append(this.getTagList()).append(",");
        }
        if (this.getCancelRequested() != null) {
            sb.append("CancelRequested: ").append(this.getCancelRequested());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkflowExecutionInfo)) {
            return false;
        }
        WorkflowExecutionInfo other = (WorkflowExecutionInfo)obj;
        if (other.getExecution() == null ^ this.getExecution() == null) {
            return false;
        }
        if (other.getExecution() != null && !other.getExecution().equals(this.getExecution())) {
            return false;
        }
        if (other.getWorkflowType() == null ^ this.getWorkflowType() == null) {
            return false;
        }
        if (other.getWorkflowType() != null && !other.getWorkflowType().equals(this.getWorkflowType())) {
            return false;
        }
        if (other.getStartTimestamp() == null ^ this.getStartTimestamp() == null) {
            return false;
        }
        if (other.getStartTimestamp() != null && !other.getStartTimestamp().equals(this.getStartTimestamp())) {
            return false;
        }
        if (other.getCloseTimestamp() == null ^ this.getCloseTimestamp() == null) {
            return false;
        }
        if (other.getCloseTimestamp() != null && !other.getCloseTimestamp().equals(this.getCloseTimestamp())) {
            return false;
        }
        if (other.getExecutionStatus() == null ^ this.getExecutionStatus() == null) {
            return false;
        }
        if (other.getExecutionStatus() != null && !other.getExecutionStatus().equals(this.getExecutionStatus())) {
            return false;
        }
        if (other.getCloseStatus() == null ^ this.getCloseStatus() == null) {
            return false;
        }
        if (other.getCloseStatus() != null && !other.getCloseStatus().equals(this.getCloseStatus())) {
            return false;
        }
        if (other.getParent() == null ^ this.getParent() == null) {
            return false;
        }
        if (other.getParent() != null && !other.getParent().equals(this.getParent())) {
            return false;
        }
        if (other.getTagList() == null ^ this.getTagList() == null) {
            return false;
        }
        if (other.getTagList() != null && !other.getTagList().equals(this.getTagList())) {
            return false;
        }
        if (other.getCancelRequested() == null ^ this.getCancelRequested() == null) {
            return false;
        }
        return other.getCancelRequested() == null || other.getCancelRequested().equals(this.getCancelRequested());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getExecution() == null ? 0 : this.getExecution().hashCode());
        hashCode = 31 * hashCode + (this.getWorkflowType() == null ? 0 : this.getWorkflowType().hashCode());
        hashCode = 31 * hashCode + (this.getStartTimestamp() == null ? 0 : this.getStartTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.getCloseTimestamp() == null ? 0 : this.getCloseTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.getExecutionStatus() == null ? 0 : this.getExecutionStatus().hashCode());
        hashCode = 31 * hashCode + (this.getCloseStatus() == null ? 0 : this.getCloseStatus().hashCode());
        hashCode = 31 * hashCode + (this.getParent() == null ? 0 : this.getParent().hashCode());
        hashCode = 31 * hashCode + (this.getTagList() == null ? 0 : this.getTagList().hashCode());
        hashCode = 31 * hashCode + (this.getCancelRequested() == null ? 0 : this.getCancelRequested().hashCode());
        return hashCode;
    }

    public WorkflowExecutionInfo clone() {
        try {
            return (WorkflowExecutionInfo)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        WorkflowExecutionInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

