/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.simpleworkflow.model.PollForActivityTaskRequest;
import com.amazonaws.services.simpleworkflow.model.transform.TaskListJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class PollForActivityTaskRequestMarshaller
implements Marshaller<Request<PollForActivityTaskRequest>, PollForActivityTaskRequest> {
    public Request<PollForActivityTaskRequest> marshall(PollForActivityTaskRequest pollForActivityTaskRequest) {
        if (pollForActivityTaskRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)pollForActivityTaskRequest, "AmazonSimpleWorkflow");
        request.addHeader("X-Amz-Target", "SimpleWorkflowService.PollForActivityTask");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter((boolean)false, (String)"1.0");
            jsonGenerator.writeStartObject();
            if (pollForActivityTaskRequest.getDomain() != null) {
                jsonGenerator.writeFieldName("domain").writeValue(pollForActivityTaskRequest.getDomain());
            }
            if (pollForActivityTaskRequest.getTaskList() != null) {
                jsonGenerator.writeFieldName("taskList");
                TaskListJsonMarshaller.getInstance().marshall(pollForActivityTaskRequest.getTaskList(), jsonGenerator);
            }
            if (pollForActivityTaskRequest.getIdentity() != null) {
                jsonGenerator.writeFieldName("identity").writeValue(pollForActivityTaskRequest.getIdentity());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

