/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.simpleworkflow.model.StartWorkflowExecutionRequest;
import com.amazonaws.services.simpleworkflow.model.TaskList;
import com.amazonaws.services.simpleworkflow.model.WorkflowType;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class StartWorkflowExecutionRequestMarshaller
implements Marshaller<Request<StartWorkflowExecutionRequest>, StartWorkflowExecutionRequest> {
    public Request<StartWorkflowExecutionRequest> marshall(StartWorkflowExecutionRequest startWorkflowExecutionRequest) {
        if (startWorkflowExecutionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)startWorkflowExecutionRequest, "AmazonSimpleWorkflow");
        String target = "SimpleWorkflowService.StartWorkflowExecution";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            ListWithAutoConstructFlag tagListList;
            TaskList taskList;
            WorkflowType workflowType;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (startWorkflowExecutionRequest.getDomain() != null) {
                jsonWriter.key("domain").value((Object)startWorkflowExecutionRequest.getDomain());
            }
            if (startWorkflowExecutionRequest.getWorkflowId() != null) {
                jsonWriter.key("workflowId").value((Object)startWorkflowExecutionRequest.getWorkflowId());
            }
            if ((workflowType = startWorkflowExecutionRequest.getWorkflowType()) != null) {
                jsonWriter.key("workflowType");
                jsonWriter.object();
                if (workflowType.getName() != null) {
                    jsonWriter.key("name").value((Object)workflowType.getName());
                }
                if (workflowType.getVersion() != null) {
                    jsonWriter.key("version").value((Object)workflowType.getVersion());
                }
                jsonWriter.endObject();
            }
            if ((taskList = startWorkflowExecutionRequest.getTaskList()) != null) {
                jsonWriter.key("taskList");
                jsonWriter.object();
                if (taskList.getName() != null) {
                    jsonWriter.key("name").value((Object)taskList.getName());
                }
                jsonWriter.endObject();
            }
            if (startWorkflowExecutionRequest.getTaskPriority() != null) {
                jsonWriter.key("taskPriority").value((Object)startWorkflowExecutionRequest.getTaskPriority());
            }
            if (startWorkflowExecutionRequest.getInput() != null) {
                jsonWriter.key("input").value((Object)startWorkflowExecutionRequest.getInput());
            }
            if (startWorkflowExecutionRequest.getExecutionStartToCloseTimeout() != null) {
                jsonWriter.key("executionStartToCloseTimeout").value((Object)startWorkflowExecutionRequest.getExecutionStartToCloseTimeout());
            }
            if (!((tagListList = (ListWithAutoConstructFlag)startWorkflowExecutionRequest.getTagList()) == null || tagListList.isAutoConstruct() && tagListList.isEmpty())) {
                jsonWriter.key("tagList");
                jsonWriter.array();
                for (String tagListListValue : tagListList) {
                    if (tagListListValue == null) continue;
                    jsonWriter.value((Object)tagListListValue);
                }
                jsonWriter.endArray();
            }
            if (startWorkflowExecutionRequest.getTaskStartToCloseTimeout() != null) {
                jsonWriter.key("taskStartToCloseTimeout").value((Object)startWorkflowExecutionRequest.getTaskStartToCloseTimeout());
            }
            if (startWorkflowExecutionRequest.getChildPolicy() != null) {
                jsonWriter.key("childPolicy").value((Object)startWorkflowExecutionRequest.getChildPolicy());
            }
            if (startWorkflowExecutionRequest.getLambdaRole() != null) {
                jsonWriter.key("lambdaRole").value((Object)startWorkflowExecutionRequest.getLambdaRole());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

