/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpledb;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.DefaultErrorResponseHandler;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.services.simpledb.AmazonSimpleDB;
import com.amazonaws.services.simpledb.SimpleDBResponseMetadata;
import com.amazonaws.services.simpledb.internal.SimpleDBStaxResponseHandler;
import com.amazonaws.services.simpledb.model.BatchDeleteAttributesRequest;
import com.amazonaws.services.simpledb.model.BatchDeleteAttributesResult;
import com.amazonaws.services.simpledb.model.BatchPutAttributesRequest;
import com.amazonaws.services.simpledb.model.BatchPutAttributesResult;
import com.amazonaws.services.simpledb.model.CreateDomainRequest;
import com.amazonaws.services.simpledb.model.CreateDomainResult;
import com.amazonaws.services.simpledb.model.DeleteAttributesRequest;
import com.amazonaws.services.simpledb.model.DeleteAttributesResult;
import com.amazonaws.services.simpledb.model.DeleteDomainRequest;
import com.amazonaws.services.simpledb.model.DeleteDomainResult;
import com.amazonaws.services.simpledb.model.DomainMetadataRequest;
import com.amazonaws.services.simpledb.model.DomainMetadataResult;
import com.amazonaws.services.simpledb.model.GetAttributesRequest;
import com.amazonaws.services.simpledb.model.GetAttributesResult;
import com.amazonaws.services.simpledb.model.ListDomainsRequest;
import com.amazonaws.services.simpledb.model.ListDomainsResult;
import com.amazonaws.services.simpledb.model.PutAttributesRequest;
import com.amazonaws.services.simpledb.model.PutAttributesResult;
import com.amazonaws.services.simpledb.model.SelectRequest;
import com.amazonaws.services.simpledb.model.SelectResult;
import com.amazonaws.services.simpledb.model.transform.AttributeDoesNotExistExceptionUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.BatchDeleteAttributesRequestMarshaller;
import com.amazonaws.services.simpledb.model.transform.BatchDeleteAttributesResultStaxUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.BatchPutAttributesRequestMarshaller;
import com.amazonaws.services.simpledb.model.transform.BatchPutAttributesResultStaxUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.CreateDomainRequestMarshaller;
import com.amazonaws.services.simpledb.model.transform.CreateDomainResultStaxUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.DeleteAttributesRequestMarshaller;
import com.amazonaws.services.simpledb.model.transform.DeleteAttributesResultStaxUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.DeleteDomainRequestMarshaller;
import com.amazonaws.services.simpledb.model.transform.DeleteDomainResultStaxUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.DomainMetadataRequestMarshaller;
import com.amazonaws.services.simpledb.model.transform.DomainMetadataResultStaxUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.DuplicateItemNameExceptionUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.GetAttributesRequestMarshaller;
import com.amazonaws.services.simpledb.model.transform.GetAttributesResultStaxUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.InvalidNextTokenExceptionUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.InvalidNumberPredicatesExceptionUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.InvalidNumberValueTestsExceptionUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.InvalidParameterValueExceptionUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.InvalidQueryExpressionExceptionUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.ListDomainsRequestMarshaller;
import com.amazonaws.services.simpledb.model.transform.ListDomainsResultStaxUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.MissingParameterExceptionUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.NoSuchDomainExceptionUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.NumberDomainAttributesExceededExceptionUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.NumberDomainBytesExceededExceptionUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.NumberDomainsExceededExceptionUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.NumberItemAttributesExceededExceptionUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.NumberSubmittedAttributesExceededExceptionUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.NumberSubmittedItemsExceededExceptionUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.PutAttributesRequestMarshaller;
import com.amazonaws.services.simpledb.model.transform.PutAttributesResultStaxUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.RequestTimeoutExceptionUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.SelectRequestMarshaller;
import com.amazonaws.services.simpledb.model.transform.SelectResultStaxUnmarshaller;
import com.amazonaws.services.simpledb.model.transform.TooManyRequestedAttributesExceptionUnmarshaller;
import com.amazonaws.transform.LegacyErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;

@ThreadSafe
public class AmazonSimpleDBClient
extends AmazonWebServiceClient
implements AmazonSimpleDB {
    private AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonSimpleDB.class);
    private static final String DEFAULT_SIGNING_NAME = "sdb";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    protected final List<Unmarshaller<AmazonServiceException, Node>> exceptionUnmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, Node>>();

    public AmazonSimpleDBClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), configFactory.getConfig());
    }

    public AmazonSimpleDBClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AmazonSimpleDBClient(AWSCredentials awsCredentials) {
        this(awsCredentials, configFactory.getConfig());
    }

    public AmazonSimpleDBClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AmazonSimpleDBClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, configFactory.getConfig());
    }

    public AmazonSimpleDBClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    public AmazonSimpleDBClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new DuplicateItemNameExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new InvalidNextTokenExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new NumberDomainAttributesExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new InvalidNumberValueTestsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new RequestTimeoutExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new NoSuchDomainExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new TooManyRequestedAttributesExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new MissingParameterExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new InvalidNumberPredicatesExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new NumberSubmittedAttributesExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new AttributeDoesNotExistExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new NumberDomainsExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new NumberItemAttributesExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new NumberDomainBytesExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new InvalidParameterValueExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new NumberSubmittedItemsExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new InvalidQueryExpressionExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new LegacyErrorUnmarshaller());
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("sdb.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/simpledb/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/simpledb/request.handler2s"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchDeleteAttributesResult batchDeleteAttributes(BatchDeleteAttributesRequest batchDeleteAttributesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchDeleteAttributesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchDeleteAttributesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchDeleteAttributesRequestMarshaller().marshall((BatchDeleteAttributesRequest)super.beforeMarshalling((AmazonWebServiceRequest)batchDeleteAttributesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            SimpleDBStaxResponseHandler<BatchDeleteAttributesResult> responseHandler = new SimpleDBStaxResponseHandler<BatchDeleteAttributesResult>(new BatchDeleteAttributesResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            BatchDeleteAttributesResult batchDeleteAttributesResult = (BatchDeleteAttributesResult)response.getAwsResponse();
            return batchDeleteAttributesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchPutAttributesResult batchPutAttributes(BatchPutAttributesRequest batchPutAttributesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchPutAttributesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchPutAttributesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchPutAttributesRequestMarshaller().marshall((BatchPutAttributesRequest)super.beforeMarshalling((AmazonWebServiceRequest)batchPutAttributesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            SimpleDBStaxResponseHandler<BatchPutAttributesResult> responseHandler = new SimpleDBStaxResponseHandler<BatchPutAttributesResult>(new BatchPutAttributesResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            BatchPutAttributesResult batchPutAttributesResult = (BatchPutAttributesResult)response.getAwsResponse();
            return batchPutAttributesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDomainResult createDomain(CreateDomainRequest createDomainRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createDomainRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateDomainRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateDomainRequestMarshaller().marshall((CreateDomainRequest)super.beforeMarshalling((AmazonWebServiceRequest)createDomainRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            SimpleDBStaxResponseHandler<CreateDomainResult> responseHandler = new SimpleDBStaxResponseHandler<CreateDomainResult>(new CreateDomainResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            CreateDomainResult createDomainResult = (CreateDomainResult)response.getAwsResponse();
            return createDomainResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAttributesResult deleteAttributes(DeleteAttributesRequest deleteAttributesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteAttributesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteAttributesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteAttributesRequestMarshaller().marshall((DeleteAttributesRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteAttributesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            SimpleDBStaxResponseHandler<DeleteAttributesResult> responseHandler = new SimpleDBStaxResponseHandler<DeleteAttributesResult>(new DeleteAttributesResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DeleteAttributesResult deleteAttributesResult = (DeleteAttributesResult)response.getAwsResponse();
            return deleteAttributesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDomainResult deleteDomain(DeleteDomainRequest deleteDomainRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteDomainRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteDomainRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteDomainRequestMarshaller().marshall((DeleteDomainRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteDomainRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            SimpleDBStaxResponseHandler<DeleteDomainResult> responseHandler = new SimpleDBStaxResponseHandler<DeleteDomainResult>(new DeleteDomainResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DeleteDomainResult deleteDomainResult = (DeleteDomainResult)response.getAwsResponse();
            return deleteDomainResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DomainMetadataResult domainMetadata(DomainMetadataRequest domainMetadataRequest) {
        ExecutionContext executionContext = this.createExecutionContext(domainMetadataRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DomainMetadataRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DomainMetadataRequestMarshaller().marshall((DomainMetadataRequest)super.beforeMarshalling((AmazonWebServiceRequest)domainMetadataRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            SimpleDBStaxResponseHandler<DomainMetadataResult> responseHandler = new SimpleDBStaxResponseHandler<DomainMetadataResult>(new DomainMetadataResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DomainMetadataResult domainMetadataResult = (DomainMetadataResult)response.getAwsResponse();
            return domainMetadataResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAttributesResult getAttributes(GetAttributesRequest getAttributesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getAttributesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetAttributesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetAttributesRequestMarshaller().marshall((GetAttributesRequest)super.beforeMarshalling((AmazonWebServiceRequest)getAttributesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            SimpleDBStaxResponseHandler<GetAttributesResult> responseHandler = new SimpleDBStaxResponseHandler<GetAttributesResult>(new GetAttributesResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            GetAttributesResult getAttributesResult = (GetAttributesResult)response.getAwsResponse();
            return getAttributesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDomainsResult listDomains(ListDomainsRequest listDomainsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listDomainsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListDomainsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListDomainsRequestMarshaller().marshall((ListDomainsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listDomainsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            SimpleDBStaxResponseHandler<ListDomainsResult> responseHandler = new SimpleDBStaxResponseHandler<ListDomainsResult>(new ListDomainsResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ListDomainsResult listDomainsResult = (ListDomainsResult)response.getAwsResponse();
            return listDomainsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListDomainsResult listDomains() {
        return this.listDomains(new ListDomainsRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutAttributesResult putAttributes(PutAttributesRequest putAttributesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putAttributesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutAttributesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutAttributesRequestMarshaller().marshall((PutAttributesRequest)super.beforeMarshalling((AmazonWebServiceRequest)putAttributesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            SimpleDBStaxResponseHandler<PutAttributesResult> responseHandler = new SimpleDBStaxResponseHandler<PutAttributesResult>(new PutAttributesResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            PutAttributesResult putAttributesResult = (PutAttributesResult)response.getAwsResponse();
            return putAttributesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SelectResult select(SelectRequest selectRequest) {
        ExecutionContext executionContext = this.createExecutionContext(selectRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SelectRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SelectRequestMarshaller().marshall((SelectRequest)super.beforeMarshalling((AmazonWebServiceRequest)selectRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            SimpleDBStaxResponseHandler<SelectResult> responseHandler = new SimpleDBStaxResponseHandler<SelectResult>(new SelectResultStaxUnmarshaller());
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            SelectResult selectResult = (SelectResult)response.getAwsResponse();
            return selectResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    public SimpleDBResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        ResponseMetadata metadata = this.client.getResponseMetadataForRequest(request);
        if (metadata != null) {
            return new SimpleDBResponseMetadata(metadata);
        }
        return null;
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.client.execute(request, responseHandler, (HttpResponseHandler)errorResponseHandler, executionContext);
    }
}

