/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.shield;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.shield.AWSShield;
import com.amazonaws.services.shield.AWSShieldClientBuilder;
import com.amazonaws.services.shield.model.AWSShieldException;
import com.amazonaws.services.shield.model.AccessDeniedException;
import com.amazonaws.services.shield.model.AccessDeniedForDependencyException;
import com.amazonaws.services.shield.model.AssociateDRTLogBucketRequest;
import com.amazonaws.services.shield.model.AssociateDRTLogBucketResult;
import com.amazonaws.services.shield.model.AssociateDRTRoleRequest;
import com.amazonaws.services.shield.model.AssociateDRTRoleResult;
import com.amazonaws.services.shield.model.CreateProtectionRequest;
import com.amazonaws.services.shield.model.CreateProtectionResult;
import com.amazonaws.services.shield.model.CreateSubscriptionRequest;
import com.amazonaws.services.shield.model.CreateSubscriptionResult;
import com.amazonaws.services.shield.model.DeleteProtectionRequest;
import com.amazonaws.services.shield.model.DeleteProtectionResult;
import com.amazonaws.services.shield.model.DeleteSubscriptionRequest;
import com.amazonaws.services.shield.model.DeleteSubscriptionResult;
import com.amazonaws.services.shield.model.DescribeAttackRequest;
import com.amazonaws.services.shield.model.DescribeAttackResult;
import com.amazonaws.services.shield.model.DescribeDRTAccessRequest;
import com.amazonaws.services.shield.model.DescribeDRTAccessResult;
import com.amazonaws.services.shield.model.DescribeEmergencyContactSettingsRequest;
import com.amazonaws.services.shield.model.DescribeEmergencyContactSettingsResult;
import com.amazonaws.services.shield.model.DescribeProtectionRequest;
import com.amazonaws.services.shield.model.DescribeProtectionResult;
import com.amazonaws.services.shield.model.DescribeSubscriptionRequest;
import com.amazonaws.services.shield.model.DescribeSubscriptionResult;
import com.amazonaws.services.shield.model.DisassociateDRTLogBucketRequest;
import com.amazonaws.services.shield.model.DisassociateDRTLogBucketResult;
import com.amazonaws.services.shield.model.DisassociateDRTRoleRequest;
import com.amazonaws.services.shield.model.DisassociateDRTRoleResult;
import com.amazonaws.services.shield.model.GetSubscriptionStateRequest;
import com.amazonaws.services.shield.model.GetSubscriptionStateResult;
import com.amazonaws.services.shield.model.InternalErrorException;
import com.amazonaws.services.shield.model.InvalidOperationException;
import com.amazonaws.services.shield.model.InvalidPaginationTokenException;
import com.amazonaws.services.shield.model.InvalidParameterException;
import com.amazonaws.services.shield.model.InvalidResourceException;
import com.amazonaws.services.shield.model.LimitsExceededException;
import com.amazonaws.services.shield.model.ListAttacksRequest;
import com.amazonaws.services.shield.model.ListAttacksResult;
import com.amazonaws.services.shield.model.ListProtectionsRequest;
import com.amazonaws.services.shield.model.ListProtectionsResult;
import com.amazonaws.services.shield.model.LockedSubscriptionException;
import com.amazonaws.services.shield.model.NoAssociatedRoleException;
import com.amazonaws.services.shield.model.OptimisticLockException;
import com.amazonaws.services.shield.model.ResourceAlreadyExistsException;
import com.amazonaws.services.shield.model.ResourceNotFoundException;
import com.amazonaws.services.shield.model.UpdateEmergencyContactSettingsRequest;
import com.amazonaws.services.shield.model.UpdateEmergencyContactSettingsResult;
import com.amazonaws.services.shield.model.UpdateSubscriptionRequest;
import com.amazonaws.services.shield.model.UpdateSubscriptionResult;
import com.amazonaws.services.shield.model.transform.AssociateDRTLogBucketRequestProtocolMarshaller;
import com.amazonaws.services.shield.model.transform.AssociateDRTLogBucketResultJsonUnmarshaller;
import com.amazonaws.services.shield.model.transform.AssociateDRTRoleRequestProtocolMarshaller;
import com.amazonaws.services.shield.model.transform.AssociateDRTRoleResultJsonUnmarshaller;
import com.amazonaws.services.shield.model.transform.CreateProtectionRequestProtocolMarshaller;
import com.amazonaws.services.shield.model.transform.CreateProtectionResultJsonUnmarshaller;
import com.amazonaws.services.shield.model.transform.CreateSubscriptionRequestProtocolMarshaller;
import com.amazonaws.services.shield.model.transform.CreateSubscriptionResultJsonUnmarshaller;
import com.amazonaws.services.shield.model.transform.DeleteProtectionRequestProtocolMarshaller;
import com.amazonaws.services.shield.model.transform.DeleteProtectionResultJsonUnmarshaller;
import com.amazonaws.services.shield.model.transform.DeleteSubscriptionRequestProtocolMarshaller;
import com.amazonaws.services.shield.model.transform.DeleteSubscriptionResultJsonUnmarshaller;
import com.amazonaws.services.shield.model.transform.DescribeAttackRequestProtocolMarshaller;
import com.amazonaws.services.shield.model.transform.DescribeAttackResultJsonUnmarshaller;
import com.amazonaws.services.shield.model.transform.DescribeDRTAccessRequestProtocolMarshaller;
import com.amazonaws.services.shield.model.transform.DescribeDRTAccessResultJsonUnmarshaller;
import com.amazonaws.services.shield.model.transform.DescribeEmergencyContactSettingsRequestProtocolMarshaller;
import com.amazonaws.services.shield.model.transform.DescribeEmergencyContactSettingsResultJsonUnmarshaller;
import com.amazonaws.services.shield.model.transform.DescribeProtectionRequestProtocolMarshaller;
import com.amazonaws.services.shield.model.transform.DescribeProtectionResultJsonUnmarshaller;
import com.amazonaws.services.shield.model.transform.DescribeSubscriptionRequestProtocolMarshaller;
import com.amazonaws.services.shield.model.transform.DescribeSubscriptionResultJsonUnmarshaller;
import com.amazonaws.services.shield.model.transform.DisassociateDRTLogBucketRequestProtocolMarshaller;
import com.amazonaws.services.shield.model.transform.DisassociateDRTLogBucketResultJsonUnmarshaller;
import com.amazonaws.services.shield.model.transform.DisassociateDRTRoleRequestProtocolMarshaller;
import com.amazonaws.services.shield.model.transform.DisassociateDRTRoleResultJsonUnmarshaller;
import com.amazonaws.services.shield.model.transform.GetSubscriptionStateRequestProtocolMarshaller;
import com.amazonaws.services.shield.model.transform.GetSubscriptionStateResultJsonUnmarshaller;
import com.amazonaws.services.shield.model.transform.ListAttacksRequestProtocolMarshaller;
import com.amazonaws.services.shield.model.transform.ListAttacksResultJsonUnmarshaller;
import com.amazonaws.services.shield.model.transform.ListProtectionsRequestProtocolMarshaller;
import com.amazonaws.services.shield.model.transform.ListProtectionsResultJsonUnmarshaller;
import com.amazonaws.services.shield.model.transform.UpdateEmergencyContactSettingsRequestProtocolMarshaller;
import com.amazonaws.services.shield.model.transform.UpdateEmergencyContactSettingsResultJsonUnmarshaller;
import com.amazonaws.services.shield.model.transform.UpdateSubscriptionRequestProtocolMarshaller;
import com.amazonaws.services.shield.model.transform.UpdateSubscriptionResultJsonUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSShieldClient
extends AmazonWebServiceClient
implements AWSShield {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSShield.class);
    private static final String DEFAULT_SIGNING_NAME = "shield";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withModeledClass(AccessDeniedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("OptimisticLockException").withModeledClass(OptimisticLockException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LockedSubscriptionException").withModeledClass(LockedSubscriptionException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidResourceException").withModeledClass(InvalidResourceException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidParameterException").withModeledClass(InvalidParameterException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidOperationException").withModeledClass(InvalidOperationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withModeledClass(ResourceNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceAlreadyExistsException").withModeledClass(ResourceAlreadyExistsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalErrorException").withModeledClass(InternalErrorException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidPaginationTokenException").withModeledClass(InvalidPaginationTokenException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitsExceededException").withModeledClass(LimitsExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NoAssociatedRoleException").withModeledClass(NoAssociatedRoleException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedForDependencyException").withModeledClass(AccessDeniedForDependencyException.class)).withBaseServiceExceptionClass(AWSShieldException.class));

    @Deprecated
    public AWSShieldClient() {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), configFactory.getConfig());
    }

    @Deprecated
    public AWSShieldClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration);
    }

    @Deprecated
    public AWSShieldClient(AWSCredentials awsCredentials) {
        this(awsCredentials, configFactory.getConfig());
    }

    @Deprecated
    public AWSShieldClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.advancedConfig = AdvancedConfig.EMPTY;
        this.init();
    }

    @Deprecated
    public AWSShieldClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, configFactory.getConfig());
    }

    @Deprecated
    public AWSShieldClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    @Deprecated
    public AWSShieldClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.advancedConfig = AdvancedConfig.EMPTY;
        this.init();
    }

    public static AWSShieldClientBuilder builder() {
        return AWSShieldClientBuilder.standard();
    }

    AWSShieldClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSShieldClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("shield.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/shield/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/shield/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public AssociateDRTLogBucketResult associateDRTLogBucket(AssociateDRTLogBucketRequest request) {
        request = (AssociateDRTLogBucketRequest)this.beforeClientExecution(request);
        return this.executeAssociateDRTLogBucket(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final AssociateDRTLogBucketResult executeAssociateDRTLogBucket(AssociateDRTLogBucketRequest associateDRTLogBucketRequest) {
        ExecutionContext executionContext = this.createExecutionContext(associateDRTLogBucketRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AssociateDRTLogBucketRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AssociateDRTLogBucketRequestProtocolMarshaller(protocolFactory).marshall((AssociateDRTLogBucketRequest)super.beforeMarshalling((AmazonWebServiceRequest)associateDRTLogBucketRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Shield");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"AssociateDRTLogBucket");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AssociateDRTLogBucketResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AssociateDRTLogBucketResult associateDRTLogBucketResult = (AssociateDRTLogBucketResult)response.getAwsResponse();
            return associateDRTLogBucketResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public AssociateDRTRoleResult associateDRTRole(AssociateDRTRoleRequest request) {
        request = (AssociateDRTRoleRequest)this.beforeClientExecution(request);
        return this.executeAssociateDRTRole(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final AssociateDRTRoleResult executeAssociateDRTRole(AssociateDRTRoleRequest associateDRTRoleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(associateDRTRoleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AssociateDRTRoleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AssociateDRTRoleRequestProtocolMarshaller(protocolFactory).marshall((AssociateDRTRoleRequest)super.beforeMarshalling((AmazonWebServiceRequest)associateDRTRoleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Shield");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"AssociateDRTRole");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AssociateDRTRoleResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AssociateDRTRoleResult associateDRTRoleResult = (AssociateDRTRoleResult)response.getAwsResponse();
            return associateDRTRoleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateProtectionResult createProtection(CreateProtectionRequest request) {
        request = (CreateProtectionRequest)this.beforeClientExecution(request);
        return this.executeCreateProtection(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateProtectionResult executeCreateProtection(CreateProtectionRequest createProtectionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createProtectionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateProtectionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateProtectionRequestProtocolMarshaller(protocolFactory).marshall((CreateProtectionRequest)super.beforeMarshalling((AmazonWebServiceRequest)createProtectionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Shield");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateProtection");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateProtectionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateProtectionResult createProtectionResult = (CreateProtectionResult)response.getAwsResponse();
            return createProtectionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateSubscriptionResult createSubscription(CreateSubscriptionRequest request) {
        request = (CreateSubscriptionRequest)this.beforeClientExecution(request);
        return this.executeCreateSubscription(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateSubscriptionResult executeCreateSubscription(CreateSubscriptionRequest createSubscriptionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createSubscriptionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateSubscriptionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateSubscriptionRequestProtocolMarshaller(protocolFactory).marshall((CreateSubscriptionRequest)super.beforeMarshalling((AmazonWebServiceRequest)createSubscriptionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Shield");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateSubscription");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateSubscriptionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateSubscriptionResult createSubscriptionResult = (CreateSubscriptionResult)response.getAwsResponse();
            return createSubscriptionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteProtectionResult deleteProtection(DeleteProtectionRequest request) {
        request = (DeleteProtectionRequest)this.beforeClientExecution(request);
        return this.executeDeleteProtection(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteProtectionResult executeDeleteProtection(DeleteProtectionRequest deleteProtectionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteProtectionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteProtectionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteProtectionRequestProtocolMarshaller(protocolFactory).marshall((DeleteProtectionRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteProtectionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Shield");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteProtection");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteProtectionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteProtectionResult deleteProtectionResult = (DeleteProtectionResult)response.getAwsResponse();
            return deleteProtectionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    @Deprecated
    public DeleteSubscriptionResult deleteSubscription(DeleteSubscriptionRequest request) {
        request = (DeleteSubscriptionRequest)this.beforeClientExecution(request);
        return this.executeDeleteSubscription(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteSubscriptionResult executeDeleteSubscription(DeleteSubscriptionRequest deleteSubscriptionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteSubscriptionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteSubscriptionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteSubscriptionRequestProtocolMarshaller(protocolFactory).marshall((DeleteSubscriptionRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteSubscriptionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Shield");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteSubscription");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteSubscriptionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteSubscriptionResult deleteSubscriptionResult = (DeleteSubscriptionResult)response.getAwsResponse();
            return deleteSubscriptionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeAttackResult describeAttack(DescribeAttackRequest request) {
        request = (DescribeAttackRequest)this.beforeClientExecution(request);
        return this.executeDescribeAttack(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeAttackResult executeDescribeAttack(DescribeAttackRequest describeAttackRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeAttackRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeAttackRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeAttackRequestProtocolMarshaller(protocolFactory).marshall((DescribeAttackRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeAttackRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Shield");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeAttack");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeAttackResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeAttackResult describeAttackResult = (DescribeAttackResult)response.getAwsResponse();
            return describeAttackResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeDRTAccessResult describeDRTAccess(DescribeDRTAccessRequest request) {
        request = (DescribeDRTAccessRequest)this.beforeClientExecution(request);
        return this.executeDescribeDRTAccess(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeDRTAccessResult executeDescribeDRTAccess(DescribeDRTAccessRequest describeDRTAccessRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeDRTAccessRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeDRTAccessRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeDRTAccessRequestProtocolMarshaller(protocolFactory).marshall((DescribeDRTAccessRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeDRTAccessRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Shield");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeDRTAccess");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeDRTAccessResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeDRTAccessResult describeDRTAccessResult = (DescribeDRTAccessResult)response.getAwsResponse();
            return describeDRTAccessResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeEmergencyContactSettingsResult describeEmergencyContactSettings(DescribeEmergencyContactSettingsRequest request) {
        request = (DescribeEmergencyContactSettingsRequest)this.beforeClientExecution(request);
        return this.executeDescribeEmergencyContactSettings(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeEmergencyContactSettingsResult executeDescribeEmergencyContactSettings(DescribeEmergencyContactSettingsRequest describeEmergencyContactSettingsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeEmergencyContactSettingsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeEmergencyContactSettingsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeEmergencyContactSettingsRequestProtocolMarshaller(protocolFactory).marshall((DescribeEmergencyContactSettingsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeEmergencyContactSettingsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Shield");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeEmergencyContactSettings");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeEmergencyContactSettingsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeEmergencyContactSettingsResult describeEmergencyContactSettingsResult = (DescribeEmergencyContactSettingsResult)response.getAwsResponse();
            return describeEmergencyContactSettingsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeProtectionResult describeProtection(DescribeProtectionRequest request) {
        request = (DescribeProtectionRequest)this.beforeClientExecution(request);
        return this.executeDescribeProtection(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeProtectionResult executeDescribeProtection(DescribeProtectionRequest describeProtectionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeProtectionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeProtectionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeProtectionRequestProtocolMarshaller(protocolFactory).marshall((DescribeProtectionRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeProtectionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Shield");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeProtection");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeProtectionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeProtectionResult describeProtectionResult = (DescribeProtectionResult)response.getAwsResponse();
            return describeProtectionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeSubscriptionResult describeSubscription(DescribeSubscriptionRequest request) {
        request = (DescribeSubscriptionRequest)this.beforeClientExecution(request);
        return this.executeDescribeSubscription(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeSubscriptionResult executeDescribeSubscription(DescribeSubscriptionRequest describeSubscriptionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeSubscriptionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeSubscriptionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeSubscriptionRequestProtocolMarshaller(protocolFactory).marshall((DescribeSubscriptionRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeSubscriptionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Shield");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeSubscription");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeSubscriptionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeSubscriptionResult describeSubscriptionResult = (DescribeSubscriptionResult)response.getAwsResponse();
            return describeSubscriptionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DisassociateDRTLogBucketResult disassociateDRTLogBucket(DisassociateDRTLogBucketRequest request) {
        request = (DisassociateDRTLogBucketRequest)this.beforeClientExecution(request);
        return this.executeDisassociateDRTLogBucket(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DisassociateDRTLogBucketResult executeDisassociateDRTLogBucket(DisassociateDRTLogBucketRequest disassociateDRTLogBucketRequest) {
        ExecutionContext executionContext = this.createExecutionContext(disassociateDRTLogBucketRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DisassociateDRTLogBucketRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DisassociateDRTLogBucketRequestProtocolMarshaller(protocolFactory).marshall((DisassociateDRTLogBucketRequest)super.beforeMarshalling((AmazonWebServiceRequest)disassociateDRTLogBucketRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Shield");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DisassociateDRTLogBucket");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DisassociateDRTLogBucketResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DisassociateDRTLogBucketResult disassociateDRTLogBucketResult = (DisassociateDRTLogBucketResult)response.getAwsResponse();
            return disassociateDRTLogBucketResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DisassociateDRTRoleResult disassociateDRTRole(DisassociateDRTRoleRequest request) {
        request = (DisassociateDRTRoleRequest)this.beforeClientExecution(request);
        return this.executeDisassociateDRTRole(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DisassociateDRTRoleResult executeDisassociateDRTRole(DisassociateDRTRoleRequest disassociateDRTRoleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(disassociateDRTRoleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DisassociateDRTRoleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DisassociateDRTRoleRequestProtocolMarshaller(protocolFactory).marshall((DisassociateDRTRoleRequest)super.beforeMarshalling((AmazonWebServiceRequest)disassociateDRTRoleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Shield");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DisassociateDRTRole");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DisassociateDRTRoleResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DisassociateDRTRoleResult disassociateDRTRoleResult = (DisassociateDRTRoleResult)response.getAwsResponse();
            return disassociateDRTRoleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetSubscriptionStateResult getSubscriptionState(GetSubscriptionStateRequest request) {
        request = (GetSubscriptionStateRequest)this.beforeClientExecution(request);
        return this.executeGetSubscriptionState(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetSubscriptionStateResult executeGetSubscriptionState(GetSubscriptionStateRequest getSubscriptionStateRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getSubscriptionStateRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetSubscriptionStateRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetSubscriptionStateRequestProtocolMarshaller(protocolFactory).marshall((GetSubscriptionStateRequest)super.beforeMarshalling((AmazonWebServiceRequest)getSubscriptionStateRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Shield");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetSubscriptionState");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetSubscriptionStateResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetSubscriptionStateResult getSubscriptionStateResult = (GetSubscriptionStateResult)response.getAwsResponse();
            return getSubscriptionStateResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListAttacksResult listAttacks(ListAttacksRequest request) {
        request = (ListAttacksRequest)this.beforeClientExecution(request);
        return this.executeListAttacks(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListAttacksResult executeListAttacks(ListAttacksRequest listAttacksRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listAttacksRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListAttacksRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListAttacksRequestProtocolMarshaller(protocolFactory).marshall((ListAttacksRequest)super.beforeMarshalling((AmazonWebServiceRequest)listAttacksRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Shield");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListAttacks");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListAttacksResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListAttacksResult listAttacksResult = (ListAttacksResult)response.getAwsResponse();
            return listAttacksResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListProtectionsResult listProtections(ListProtectionsRequest request) {
        request = (ListProtectionsRequest)this.beforeClientExecution(request);
        return this.executeListProtections(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListProtectionsResult executeListProtections(ListProtectionsRequest listProtectionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listProtectionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListProtectionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListProtectionsRequestProtocolMarshaller(protocolFactory).marshall((ListProtectionsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listProtectionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Shield");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListProtections");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListProtectionsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListProtectionsResult listProtectionsResult = (ListProtectionsResult)response.getAwsResponse();
            return listProtectionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateEmergencyContactSettingsResult updateEmergencyContactSettings(UpdateEmergencyContactSettingsRequest request) {
        request = (UpdateEmergencyContactSettingsRequest)this.beforeClientExecution(request);
        return this.executeUpdateEmergencyContactSettings(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateEmergencyContactSettingsResult executeUpdateEmergencyContactSettings(UpdateEmergencyContactSettingsRequest updateEmergencyContactSettingsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateEmergencyContactSettingsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateEmergencyContactSettingsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateEmergencyContactSettingsRequestProtocolMarshaller(protocolFactory).marshall((UpdateEmergencyContactSettingsRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateEmergencyContactSettingsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Shield");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateEmergencyContactSettings");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateEmergencyContactSettingsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateEmergencyContactSettingsResult updateEmergencyContactSettingsResult = (UpdateEmergencyContactSettingsResult)response.getAwsResponse();
            return updateEmergencyContactSettingsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateSubscriptionResult updateSubscription(UpdateSubscriptionRequest request) {
        request = (UpdateSubscriptionRequest)this.beforeClientExecution(request);
        return this.executeUpdateSubscription(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateSubscriptionResult executeUpdateSubscription(UpdateSubscriptionRequest updateSubscriptionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateSubscriptionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateSubscriptionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateSubscriptionRequestProtocolMarshaller(protocolFactory).marshall((UpdateSubscriptionRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateSubscriptionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Shield");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateSubscription");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateSubscriptionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateSubscriptionResult updateSubscriptionResult = (UpdateSubscriptionResult)response.getAwsResponse();
            return updateSubscriptionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

